/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.velocity;

import de.themoep.connectorplugin.velocity.VelocityConnectorPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.regex.Pattern;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.yaml.YAMLConfigurationLoader;
import org.yaml.snakeyaml.DumperOptions;

public class PluginConfig {
    private static final Pattern PATH_PATTERN = Pattern.compile("\\.");
    private final VelocityConnectorPlugin plugin;
    private final File configFile;
    private final String defaultFile;
    private final YAMLConfigurationLoader configLoader;
    private ConfigurationNode config;
    private ConfigurationNode defaultConfig;

    public PluginConfig(VelocityConnectorPlugin plugin, File configFile) {
        this(plugin, configFile, configFile.getName());
    }

    public PluginConfig(VelocityConnectorPlugin plugin, File configFile, String defaultFile) {
        this.plugin = plugin;
        this.configFile = configFile;
        this.defaultFile = defaultFile;
        this.configLoader = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setIndent(2).setPath(configFile.toPath())).setFlowStyle(DumperOptions.FlowStyle.BLOCK).build();
    }

    public boolean load() {
        try {
            this.config = this.configLoader.load();
            if (this.defaultFile != null) {
                this.defaultConfig = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setIndent(2).setSource(() -> new BufferedReader(new InputStreamReader(this.plugin.getResourceAsStream(this.defaultFile))))).build().load();
                if (this.config.isEmpty()) {
                    this.config = this.defaultConfig.copy();
                }
            }
            this.plugin.logDebug("Loaded " + this.configFile.getName(), new Throwable[0]);
            return true;
        }
        catch (IOException e) {
            this.plugin.logError("Unable to load configuration file " + this.configFile.getName(), e);
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean createDefaultConfig() throws IOException {
        block14: {
            try (InputStream in = this.plugin.getResourceAsStream(this.defaultFile);){
                if (in == null) {
                    this.plugin.logWarning("No default config '" + this.defaultFile + "' found in " + this.plugin.getName() + "!", new Throwable[0]);
                    boolean bl = false;
                    return bl;
                }
                if (this.configFile.exists()) break block14;
                File parent = this.configFile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                try {
                    Files.copy(in, this.configFile.toPath(), new CopyOption[0]);
                    boolean bl = true;
                    return bl;
                }
                catch (IOException ex) {
                    this.plugin.logError("Could not save " + this.configFile.getName() + " to " + this.configFile, ex);
                }
            }
            catch (IOException ex) {
                this.plugin.logError("Could not load default config from " + this.defaultFile, ex);
            }
        }
        return false;
    }

    public void save() {
        try {
            this.configLoader.save(this.config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Object set(String path, Object value) {
        ConfigurationNode node = this.config.getNode(PluginConfig.splitPath(path));
        Object prev = node.getValue();
        node.setValue(value);
        return prev;
    }

    public ConfigurationNode remove(String path) {
        ConfigurationNode node = this.config.getNode(PluginConfig.splitPath(path));
        return node.isVirtual() ? node : node.setValue(null);
    }

    public ConfigurationNode getRawConfig() {
        return this.config;
    }

    public ConfigurationNode getRawConfig(String path) {
        return this.getRawConfig().getNode(PluginConfig.splitPath(path));
    }

    public boolean has(String path) {
        return !this.getRawConfig(path).isVirtual();
    }

    public boolean isSection(String path) {
        return this.getRawConfig(path).hasMapChildren();
    }

    public int getInt(String path) {
        return this.getInt(path, 0);
    }

    public int getInt(String path, int def) {
        return this.getRawConfig(path).getInt(def);
    }

    public long getLong(String path) {
        return this.getLong(path, 0L);
    }

    public long getLong(String path, long def) {
        return this.getRawConfig(path).getLong(def);
    }

    public double getDouble(String path) {
        return this.getDouble(path, 0.0);
    }

    public double getDouble(String path, double def) {
        return this.getRawConfig(path).getDouble(def);
    }

    public String getString(String path) {
        return this.getString(path, null);
    }

    public String getString(String path, String def) {
        return this.getRawConfig(path).getString(def);
    }

    public boolean getBoolean(String path) {
        return this.getBoolean(path, false);
    }

    public boolean getBoolean(String path, boolean def) {
        return this.getRawConfig(path).getBoolean(def);
    }

    private static Object[] splitPath(String key) {
        return PATH_PATTERN.split(key);
    }
}

