/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import de.themoep.connectorplugin.ConnectorPlugin;
import de.themoep.connectorplugin.connector.MessageTarget;
import de.themoep.connectorplugin.velocity.Bridge;
import de.themoep.connectorplugin.velocity.PluginConfig;
import de.themoep.connectorplugin.velocity.commands.ConnectorCommand;
import de.themoep.connectorplugin.velocity.connector.MqttConnector;
import de.themoep.connectorplugin.velocity.connector.PluginMessageConnector;
import de.themoep.connectorplugin.velocity.connector.RedisConnector;
import de.themoep.connectorplugin.velocity.connector.VelocityConnector;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Locale;
import org.slf4j.Logger;

public final class VelocityConnectorPlugin
implements ConnectorPlugin {
    private final ProxyServer proxy;
    private final Logger logger;
    private final File dataFolder;
    private PluginConfig config;
    private VelocityConnector connector;
    private Bridge bridge;
    private boolean debug = true;
    private String serverId;

    @Inject
    public VelocityConnectorPlugin(ProxyServer proxy, Logger logger, @DataDirectory Path dataFolder) {
        this.proxy = proxy;
        this.logger = logger;
        this.dataFolder = dataFolder.toFile();
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        String messengerType;
        this.config = new PluginConfig(this, new File(this.dataFolder, "config.yml"), "velocity-config.yml");
        if (!this.config.load()) {
            return;
        }
        this.debug = this.getConfig().getBoolean("debug");
        this.serverId = this.getConfig().getString("server-id");
        switch (messengerType = this.getConfig().getString("messenger-type", "plugin_messages").toLowerCase(Locale.ROOT)) {
            default: {
                this.logger.warn("Messenger type '" + messengerType + "' is not supported, falling back to plugin messages!");
            }
            case "plugin_messages": {
                this.connector = new PluginMessageConnector(this);
                break;
            }
            case "redis": {
                this.connector = new RedisConnector(this);
                break;
            }
            case "mqtt": {
                this.connector = new MqttConnector(this);
            }
        }
        ConnectorCommand command = new ConnectorCommand(this);
        this.getProxy().getCommandManager().register((CommandMeta)command, (Command)command);
        this.bridge = new Bridge(this);
    }

    @Subscribe
    public void onProxyInitialization(ProxyShutdownEvent event) {
        this.connector.close();
    }

    @Override
    public VelocityConnector getConnector() {
        return this.connector;
    }

    public Bridge getBridge() {
        return this.bridge;
    }

    @Override
    public void runAsync(Runnable runnable) {
        this.getProxy().getScheduler().buildTask((Object)this, runnable).schedule();
    }

    @Override
    public MessageTarget.Type getSourceType() {
        return MessageTarget.Type.PROXY;
    }

    @Override
    public void logDebug(String message, Throwable ... throwables) {
        if (this.debug) {
            this.logger.info("[DEBUG] " + message, throwables.length > 0 ? throwables[0] : null);
        }
    }

    @Override
    public void logWarning(String message, Throwable ... throwables) {
        this.logger.warn(message, throwables.length > 0 ? throwables[0] : null);
    }

    @Override
    public void logError(String message, Throwable ... throwables) {
        this.logger.error(message, throwables.length > 0 ? throwables[0] : null);
    }

    @Override
    public String getServerName() {
        return "proxy:" + this.serverId;
    }

    @Override
    public String getGroup() {
        return "";
    }

    @Override
    public String getName() {
        return "ConnectorPlugin";
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    public PluginConfig getConfig() {
        return this.config;
    }

    public InputStream getResourceAsStream(String file) {
        return this.getClass().getResourceAsStream(file);
    }
}

