/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import de.themoep.connectorplugin.velocity.commands.ConnectorCommand;
import de.themoep.connectorplugin.velocity.commands.SubCommand;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class ServerConsoleCommand
extends SubCommand {
    public ServerConsoleCommand(ConnectorCommand parent) {
        super(parent.getPlugin(), "servercommand <servername|p:player> <command...>", parent.getPermission() + ".servercommand", "serverconsole", "serverconsolecommand", "server", "scc");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean run(CommandSource sender, String alias, String[] args) {
        if (args.length < 2) {
            return false;
        }
        String serverName = args[0];
        if (serverName.startsWith("p:")) {
            Optional player = this.plugin.getProxy().getPlayer(serverName.substring(2));
            if (!player.isPresent()) {
                sender.sendMessage(Component.text((String)("The player '" + serverName.substring(2) + "' is not online?")).color((TextColor)NamedTextColor.RED));
                return false;
            }
            if (!((Player)player.get()).getCurrentServer().isPresent()) {
                sender.sendMessage(Component.text((String)("Player '" + ((Player)player.get()).getUsername() + "' is not connected to any server?")).color((TextColor)NamedTextColor.RED));
                return false;
            }
            serverName = ((ServerConnection)((Player)player.get()).getCurrentServer().get()).getServerInfo().getName();
        } else if (!this.plugin.getProxy().getServer(serverName).isPresent()) {
            sender.sendMessage(Component.text((String)("There is no server with the name of '" + serverName + "' on the proxy. Trying to send command anyways...")).color((TextColor)NamedTextColor.GRAY));
        }
        String commandString = Arrays.stream(args).skip(1L).collect(Collectors.joining(" "));
        sender.sendMessage(Component.text((String)("Executing '" + commandString + "' on server '" + serverName + "'")).color((TextColor)NamedTextColor.GRAY));
        this.plugin.getBridge().runServerConsoleCommand(serverName, commandString, m -> sender.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(m))).thenAccept(success -> sender.sendMessage((Component)Component.text((String)(success != false ? "Successfully executed command!" : "Error while executing the command."))));
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSource sender, String[] args) {
        if (!sender.hasPermission(this.getPermission())) {
            return Collections.emptyList();
        }
        if (args.length == 0) {
            return this.plugin.getProxy().getAllServers().stream().map(s -> s.getServerInfo().getName()).collect(Collectors.toList());
        }
        if (args.length == 1) {
            return this.plugin.getProxy().getAllServers().stream().map(s -> s.getServerInfo().getName()).filter(s -> s.startsWith(args[0].toLowerCase(Locale.ROOT))).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

