/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import de.themoep.connectorplugin.velocity.commands.ConnectorCommand;
import de.themoep.connectorplugin.velocity.commands.SubCommand;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class ServerPlayerCommand
extends SubCommand {
    public ServerPlayerCommand(ConnectorCommand parent) {
        super(parent.getPlugin(), "serverplayercommand <playername> <command...>", parent.getPermission() + ".serverplayercommand", "serverplayer", "player", "spc");
    }

    @Override
    public boolean run(CommandSource sender, String alias, String[] args) {
        if (args.length < 2) {
            return false;
        }
        Player player = this.plugin.getProxy().getPlayer(args[0]).orElse(null);
        if (player == null) {
            sender.sendMessage((Component)Component.text((String)("No player with the name " + args[0] + " is online on this server!")));
            return true;
        }
        String commandString = Arrays.stream(args).skip(1L).collect(Collectors.joining(" "));
        sender.sendMessage(Component.text((String)("Executing '" + commandString + "' on the server for player '" + player.getUsername() + "'")).color((TextColor)NamedTextColor.GRAY));
        this.plugin.getBridge().runServerPlayerCommand(player, commandString).thenAccept(success -> sender.sendMessage((Component)Component.text((String)(success != false ? "Successfully executed command!" : "Error while executing the command."))));
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSource sender, String[] args) {
        if (!sender.hasPermission(this.getPermission())) {
            return Collections.emptyList();
        }
        if (args.length == 0) {
            return this.plugin.getProxy().getAllPlayers().stream().map(Player::getUsername).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
        }
        if (args.length == 1) {
            return this.plugin.getProxy().getAllPlayers().stream().map(Player::getUsername).filter(s -> s.startsWith(args[0].toLowerCase(Locale.ROOT))).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

