/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.velocity.commands;

import com.mojang.brigadier.tree.CommandNode;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import de.themoep.connectorplugin.velocity.VelocityConnectorPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class SubCommand
implements CommandMeta,
SimpleCommand {
    protected final VelocityConnectorPlugin plugin;
    private final String name;
    private final String usage;
    private final String permission;
    private final Collection<String> aliases;
    private Map<String, SubCommand> subCommands = new LinkedHashMap<String, SubCommand>();
    private Map<String, SubCommand> subCommandAliases = new LinkedHashMap<String, SubCommand>();

    public SubCommand(VelocityConnectorPlugin plugin, String name) {
        this(plugin, name, null, new String[0]);
    }

    public SubCommand(VelocityConnectorPlugin plugin, String usage, String permission, String ... aliases) {
        this.plugin = plugin;
        String[] usageParts = usage.split(" ", 2);
        this.name = usageParts[0];
        this.usage = usageParts.length > 1 ? usageParts[1] : "";
        this.permission = permission;
        this.aliases = new ArrayList<String>();
        this.aliases.add(this.name);
        Collections.addAll(this.aliases, aliases);
    }

    public void registerSubCommand(SubCommand subCommand) {
        this.subCommands.put(subCommand.getName().toLowerCase(Locale.ROOT), subCommand);
        for (String alias : subCommand.getAliases()) {
            this.subCommandAliases.put(alias.toLowerCase(Locale.ROOT), subCommand);
        }
    }

    public SubCommand getSubCommand(String name) {
        SubCommand subCommand = this.subCommands.get(name.toLowerCase(Locale.ROOT));
        if (subCommand == null) {
            return this.subCommandAliases.get(name.toLowerCase(Locale.ROOT));
        }
        return subCommand;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        if (!this.run(invocation.source(), invocation.alias(), (String[])invocation.arguments()) && this.getUsage() != null) {
            invocation.source().sendMessage((Component)Component.text((String)("Usage: /" + invocation.alias() + " " + this.getUsage())));
        }
    }

    public boolean run(CommandSource sender, String alias, String[] args) {
        if (args.length == 0) {
            return false;
        }
        SubCommand subCommand = this.getSubCommand(args[0]);
        if (subCommand != null) {
            subCommand.execute(new SubInvocation(sender, alias + " " + args[0], Arrays.copyOfRange(args, 1, args.length)));
            return true;
        }
        return false;
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        return this.onTabComplete(invocation.source(), (String[])invocation.arguments());
    }

    public List<String> onTabComplete(CommandSource sender, String[] args) {
        if (!sender.hasPermission(this.getPermission())) {
            return Collections.emptyList();
        }
        if (args.length == 0 || args[0].isEmpty()) {
            return new ArrayList<String>(this.subCommands.keySet());
        }
        SubCommand subCommand = this.getSubCommand(args[0]);
        if (subCommand != null && sender.hasPermission(subCommand.getPermission())) {
            return subCommand.onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
        }
        ArrayList<String> completions = new ArrayList<String>();
        for (Map.Entry<String, SubCommand> e : this.subCommands.entrySet()) {
            if (!e.getKey().startsWith(args[0].toLowerCase(Locale.ROOT)) || !sender.hasPermission(e.getValue().getPermission())) continue;
            completions.add(e.getKey());
        }
        for (Map.Entry<String, SubCommand> e : this.subCommandAliases.entrySet()) {
            if (!e.getKey().startsWith(args[0].toLowerCase(Locale.ROOT)) || !sender.hasPermission(e.getValue().getPermission())) continue;
            completions.add(e.getKey());
        }
        return completions;
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return this.getPermission() == null || invocation.source().hasPermission(this.getPermission());
    }

    public Map<String, SubCommand> getSubCommands() {
        return this.subCommands;
    }

    public VelocityConnectorPlugin getPlugin() {
        return this.plugin;
    }

    public String getName() {
        return this.name;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getPermission() {
        return this.permission;
    }

    public Collection<String> getAliases() {
        return this.aliases;
    }

    public Collection<CommandNode<CommandSource>> getHints() {
        return Collections.emptySet();
    }

    private class SubInvocation
    implements SimpleCommand.Invocation {
        private final CommandSource source;
        private final String alias;
        private final String[] args;

        public SubInvocation(CommandSource source, String alias, String[] args) {
            this.source = source;
            this.alias = alias;
            this.args = args;
        }

        public String alias() {
            return this.alias;
        }

        public CommandSource source() {
            return this.source;
        }

        public String @NonNull [] arguments() {
            return this.args;
        }
    }
}

