/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import de.themoep.connectorplugin.LocationInfo;
import de.themoep.connectorplugin.velocity.commands.ConnectorCommand;
import de.themoep.connectorplugin.velocity.commands.SubCommand;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class TeleportCommand
extends SubCommand {
    public TeleportCommand(ConnectorCommand parent) {
        super(parent.getPlugin(), "teleport <player> <server> [<world> <x> <y> <z> [<yaw> <pitch>]]", parent.getPermission() + ".teleport", "tp", "send");
    }

    @Override
    public boolean run(CommandSource sender, String alias, String[] args) {
        if (args.length < 2) {
            return false;
        }
        Player player = this.plugin.getProxy().getPlayer(args[0]).orElse(null);
        if (player == null) {
            sender.sendMessage(Component.text((String)("No player with the name " + args[0] + " found!")).color((TextColor)NamedTextColor.RED));
            return true;
        }
        RegisteredServer server = this.plugin.getProxy().getServer(args[1]).orElse(null);
        if (server == null) {
            sender.sendMessage(Component.text((String)("No server with the name " + args[1] + " found!")).color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (args.length == 2) {
            player.createConnectionRequest(server).connect().thenAccept(result -> {
                if (result.isSuccessful()) {
                    sender.sendMessage(Component.text((String)("Connected player " + player.getUsername() + " to server " + server.getServerInfo().getName())).color((TextColor)NamedTextColor.GREEN));
                } else {
                    sender.sendMessage(Component.text((String)("Error while connecting player " + player.getUsername() + " to server " + server.getServerInfo().getName() + ": " + result.getReasonComponent().orElse(Component.empty()))).color((TextColor)NamedTextColor.RED));
                }
            });
            return true;
        }
        if (args.length == 3) {
            this.plugin.getBridge().teleport(player.getUsername(), server.getServerInfo().getName(), args[2], m -> sender.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(m))).thenAccept(success -> {
                if (!success.booleanValue()) {
                    sender.sendMessage(Component.text((String)"Error while teleporting...").color((TextColor)NamedTextColor.RED));
                }
            });
            return true;
        }
        if (args.length < 6) {
            return false;
        }
        try {
            LocationInfo location = new LocationInfo(server.getServerInfo().getName(), args[2], Double.parseDouble(args[3]), Double.parseDouble(args[4]), Double.parseDouble(args[5]), args.length > 6 ? Float.parseFloat(args[6]) : 0.0f, args.length > 7 ? Float.parseFloat(args[7]) : 0.0f);
            this.plugin.getBridge().teleport(player.getUsername(), location, m -> sender.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(m))).thenAccept(success -> {
                if (!success.booleanValue()) {
                    sender.sendMessage(Component.text((String)"Error while teleporting...").color((TextColor)NamedTextColor.RED));
                }
            });
            return true;
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(Component.text((String)("Error while parsing input! " + e.getMessage())).color((TextColor)NamedTextColor.RED));
            return false;
        }
    }

    @Override
    public List<String> onTabComplete(CommandSource sender, String[] args) {
        if (!sender.hasPermission(this.getPermission())) {
            return Collections.emptyList();
        }
        if (args.length == 0) {
            return this.plugin.getProxy().getAllPlayers().stream().map(Player::getUsername).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
        }
        if (args.length == 1) {
            return this.plugin.getProxy().getAllPlayers().stream().map(Player::getUsername).filter(s -> s.startsWith(args[0].toLowerCase(Locale.ROOT))).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
        }
        if (args.length == 2) {
            return this.plugin.getProxy().getAllServers().stream().map(s -> s.getServerInfo().getName()).filter(s -> s.startsWith(args[0].toLowerCase(Locale.ROOT))).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

