/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import de.themoep.connectorplugin.velocity.commands.ConnectorCommand;
import de.themoep.connectorplugin.velocity.commands.SubCommand;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class TeleportToPlayerCommand
extends SubCommand {
    public TeleportToPlayerCommand(ConnectorCommand parent) {
        super(parent.getPlugin(), "teleporttoplayer <player> [<target>]", parent.getPermission() + ".teleporttoplayer", "teleportplayer");
    }

    @Override
    public boolean run(CommandSource sender, String alias, String[] args) {
        String targetName;
        String playerName;
        if (args.length == 1 && sender instanceof Player) {
            playerName = ((Player)sender).getUsername();
            targetName = args[0];
        } else if (args.length == 2) {
            playerName = args[0];
            targetName = args[1];
        } else {
            return false;
        }
        Player player = this.plugin.getProxy().getPlayer(playerName).orElse(null);
        if (player == null) {
            sender.sendMessage(Component.text((String)("No player with the name " + playerName + " found!")).color((TextColor)NamedTextColor.RED));
            return true;
        }
        Player target = this.plugin.getProxy().getPlayer(targetName).orElse(null);
        if (target == null) {
            sender.sendMessage(Component.text((String)("No player with the name " + targetName + " found!")).color((TextColor)NamedTextColor.RED));
            return true;
        }
        this.plugin.getBridge().teleport(player.getUsername(), target.getUsername(), m -> sender.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(m))).thenAccept(success -> {
            if (!success.booleanValue()) {
                sender.sendMessage(Component.text((String)"Error while teleporting...").color((TextColor)NamedTextColor.RED));
            }
        });
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSource sender, String[] args) {
        if (!sender.hasPermission(this.getPermission())) {
            return Collections.emptyList();
        }
        if (args.length == 0) {
            return this.plugin.getProxy().getAllPlayers().stream().map(Player::getUsername).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
        }
        if (args.length == 1) {
            return this.plugin.getProxy().getAllPlayers().stream().map(Player::getUsername).filter(s -> s.startsWith(args[0].toLowerCase(Locale.ROOT))).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
        }
        if (args.length == 2) {
            return this.plugin.getProxy().getAllPlayers().stream().map(Player::getUsername).filter(s -> s.startsWith(args[1].toLowerCase(Locale.ROOT))).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

