/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.velocity.connector;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import de.themoep.connectorplugin.connector.Message;
import de.themoep.connectorplugin.connector.VersionMismatchException;
import de.themoep.connectorplugin.velocity.VelocityConnectorPlugin;
import de.themoep.connectorplugin.velocity.connector.VelocityConnector;

public class PluginMessageConnector
extends VelocityConnector {
    private final ChannelIdentifier messageChannel;
    private final Multimap<String, byte[]> messageQueue = MultimapBuilder.hashKeys().linkedListValues().build();

    public PluginMessageConnector(VelocityConnectorPlugin plugin) {
        super(plugin, true);
        this.messageChannel = MinecraftChannelIdentifier.from((String)plugin.getMessageChannel());
        plugin.getProxy().getChannelRegistrar().register(new ChannelIdentifier[]{this.messageChannel});
    }

    @Subscribe
    public void onPluginMessage(PluginMessageEvent event) {
        if (!event.getResult().isAllowed() || !event.getIdentifier().equals(this.messageChannel)) {
            return;
        }
        if (event.getSource() instanceof Player) {
            event.setResult(PluginMessageEvent.ForwardResult.handled());
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])event.getData());
        String group = in.readUTF();
        int messageLength = in.readInt();
        byte[] messageData = new byte[messageLength];
        in.readFully(messageData);
        try {
            Message message = Message.fromByteArray(messageData);
            switch (message.getTarget()) {
                case ALL_WITH_PLAYERS: {
                    this.sendToAllWithPlayers(event.getData(), null);
                    break;
                }
                case ALL_QUEUE: {
                    this.sendToAllAndQueue(event.getData(), null);
                    break;
                }
                case OTHERS_WITH_PLAYERS: {
                    if (((Player)event.getTarget()).getCurrentServer().isPresent()) {
                        this.sendToAllWithPlayers(event.getData(), ((ServerConnection)((Player)event.getTarget()).getCurrentServer().get()).getServer());
                        break;
                    }
                    this.sendToAllWithPlayers(event.getData(), null);
                    break;
                }
                case OTHERS_QUEUE: {
                    if (((Player)event.getTarget()).getCurrentServer().isPresent()) {
                        this.sendToAllAndQueue(event.getData(), ((ServerConnection)((Player)event.getTarget()).getCurrentServer().get()).getServer());
                        break;
                    }
                    this.sendToAllAndQueue(event.getData(), null);
                    break;
                }
                case PROXY: 
                case ALL_PROXIES: {
                    this.handle((Player)event.getTarget(), message);
                    break;
                }
                default: {
                    ((VelocityConnectorPlugin)this.plugin).logError("Receiving " + (Object)((Object)message.getTarget()) + " is not supported!", new Throwable[0]);
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            ((VelocityConnectorPlugin)this.plugin).logError("Invalid message target! " + e.getMessage(), new Throwable[0]);
        }
        catch (VersionMismatchException e) {
            ((VelocityConnectorPlugin)this.plugin).logWarning(e.getMessage() + ". Ignoring message!", new Throwable[0]);
        }
    }

    private void sendToAllWithPlayers(byte[] data, RegisteredServer excludedServer) {
        this.sendToAll(data, false, excludedServer);
    }

    private void sendToAllAndQueue(byte[] data, RegisteredServer excludedServer) {
        this.sendToAll(data, true, excludedServer);
    }

    private void sendToAll(byte[] data, boolean queue, RegisteredServer excludedServer) {
        for (RegisteredServer server : ((VelocityConnectorPlugin)this.plugin).getProxy().getAllServers()) {
            if (excludedServer != null && excludedServer == server || server.sendPluginMessage(this.messageChannel, data) || !queue) continue;
            this.messageQueue.put((Object)server.getServerInfo().getName(), (Object)data);
        }
    }

    @Subscribe
    public void onPlayerServerConnect(ServerConnectedEvent event) {
        for (byte[] data : this.messageQueue.removeAll((Object)event.getServer().getServerInfo().getName())) {
            event.getServer().sendPluginMessage(this.messageChannel, data);
        }
    }

    @Override
    public void sendDataImplementation(String targetData, Message message) {
        byte[] messageData = message.writeToByteArray(this.plugin);
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(((VelocityConnectorPlugin)this.plugin).getGroup());
        out.writeInt(messageData.length);
        out.write(messageData);
        byte[] dataToSend = out.toByteArray();
        RegisteredServer server = this.getTargetServer(targetData);
        switch (message.getTarget()) {
            case ALL_WITH_PLAYERS: {
                this.sendToAllWithPlayers(dataToSend, null);
                break;
            }
            case ALL_QUEUE: {
                this.sendToAllAndQueue(dataToSend, null);
                break;
            }
            case OTHERS_WITH_PLAYERS: {
                this.sendToAllWithPlayers(dataToSend, server);
                break;
            }
            case OTHERS_QUEUE: {
                this.sendToAllAndQueue(dataToSend, server);
                break;
            }
            case SERVER: {
                if (server != null) {
                    server.sendPluginMessage(this.messageChannel, dataToSend);
                    break;
                }
                throw new UnsupportedOperationException("Could not send data to " + (Object)((Object)message.getTarget()) + " as target server wasn't found from " + targetData + "!");
            }
            default: {
                throw new UnsupportedOperationException("Sending to " + (Object)((Object)message.getTarget()) + " is not supported!");
            }
        }
    }
}

