/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.minedown.adventure;

import de.themoep.minedown.adventure.MineDown;
import de.themoep.minedown.adventure.Util;
import java.lang.invoke.CallSite;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ObjectComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.format.TextFormat;
import net.kyori.adventure.text.object.ObjectContents;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;
import net.kyori.adventure.text.object.SpriteObjectContents;

public class MineDownStringifier {
    private boolean useLegacyColors = false;
    private boolean useLegacyFormatting = false;
    private boolean preferSimpleEvents = true;
    private boolean formattingInEventDefinition = false;
    private boolean colorInEventDefinition = false;
    private char colorChar = (char)38;
    private TextColor color = null;
    private ClickEvent clickEvent = null;
    private HoverEvent hoverEvent = null;
    private Set<TextDecoration> formats = new LinkedHashSet<TextDecoration>();

    public String stringify(List<Component> components) {
        StringBuilder sb = new StringBuilder();
        for (Component component : components) {
            sb.append(this.stringify(component));
        }
        return sb.toString();
    }

    public String stringify(Component component) {
        boolean hasEvent;
        StringBuilder sb = new StringBuilder();
        if (!component.hasStyling() && component.children().isEmpty() && component instanceof TextComponent) {
            this.appendText(sb, component);
            return sb.toString();
        }
        boolean bl = hasEvent = component.style().font() != null && component.style().font() != Style.DEFAULT_FONT || component.shadowColor() != null && component.shadowColor().alpha() != 0 || component instanceof TranslatableComponent || component.insertion() != null || component instanceof ObjectComponent || component.clickEvent() != this.clickEvent || component.hoverEvent() != this.hoverEvent;
        if (hasEvent) {
            sb.append('[');
            if (!this.formattingInEventDefinition()) {
                this.appendFormat(sb, component);
            }
            if (!this.colorInEventDefinition()) {
                this.appendColor(sb, component.color());
            }
        } else if (component.color() != null) {
            this.appendFormat(sb, component);
            this.appendColor(sb, component.color());
        } else {
            this.appendFormat(sb, component);
        }
        this.appendText(sb, component);
        if (!component.children().isEmpty()) {
            sb.append(this.copy().stringify(component.children()));
        }
        if (hasEvent) {
            NamedTextColor namedColor;
            StringBuilder sbi;
            this.clickEvent = component.clickEvent();
            this.hoverEvent = component.hoverEvent();
            if (!this.formattingInEventDefinition()) {
                this.appendFormatSuffix(sb, component);
            }
            sb.append("](");
            ArrayList<Object> definitions = new ArrayList<Object>();
            if (component instanceof TranslatableComponent) {
                TranslatableComponent translatable = (TranslatableComponent)component;
                definitions.add("translate=" + translatable.key());
                if (!translatable.args().isEmpty()) {
                    definitions.add("with=" + "{" + translatable.args().stream().map(this::stringify).collect(Collectors.joining(",")) + "}");
                }
            } else if (component instanceof ObjectComponent) {
                ObjectComponent objectComponent = (ObjectComponent)component;
                ObjectContents objectContents = objectComponent.contents();
                if (objectContents instanceof PlayerHeadObjectContents) {
                    PlayerHeadObjectContents playerHeadContents = (PlayerHeadObjectContents)objectContents;
                    String defValue = null;
                    if (playerHeadContents.id() != null) {
                        defValue = playerHeadContents.id().toString();
                    } else if (playerHeadContents.name() != null) {
                        defValue = playerHeadContents.name();
                    } else if (playerHeadContents.texture() != null) {
                        defValue = playerHeadContents.texture().asMinimalString();
                    } else if (!playerHeadContents.profileProperties().isEmpty()) {
                        for (PlayerHeadObjectContents.ProfileProperty property : playerHeadContents.profileProperties()) {
                            String decoded;
                            if (!"textures".equals(property.name()) || property.signature() != null || !(decoded = new String(Base64.getDecoder().decode(property.value()))).startsWith("{\"textures\"") || !decoded.endsWith("}")) continue;
                            defValue = property.value();
                            break;
                        }
                    }
                    if (defValue == null) {
                        defValue = "Unknown";
                    }
                    definitions.add("player_head=" + defValue);
                    if (!playerHeadContents.hat()) {
                        definitions.add("hat=false");
                    }
                    if (playerHeadContents.texture() != null) {
                        definitions.add("texture=" + String.valueOf(playerHeadContents.texture()));
                    }
                    if (!playerHeadContents.profileProperties().isEmpty()) {
                        ArrayList<CallSite> profileValues = new ArrayList<CallSite>();
                        for (PlayerHeadObjectContents.ProfileProperty property : playerHeadContents.profileProperties()) {
                            if (defValue.equals(property.value())) continue;
                            String profileValue = property.name() + "=" + property.value();
                            if (property.signature() != null) {
                                profileValue = profileValue + ",signature=" + property.signature();
                            }
                            profileValues.add((CallSite)((Object)profileValue));
                        }
                        if (!profileValues.isEmpty()) {
                            definitions.add("profile={" + profileValues.stream().map(s -> {
                                if (profileValues.size() == 1) {
                                    return s;
                                }
                                return "{" + s + "}";
                            }).collect(Collectors.joining(",")) + "}");
                        }
                    }
                } else {
                    objectContents = objectComponent.contents();
                    if (objectContents instanceof SpriteObjectContents) {
                        SpriteObjectContents spriteContents = (SpriteObjectContents)objectContents;
                        definitions.add("sprite=" + spriteContents.sprite().asMinimalString());
                        if (!spriteContents.atlas().equals((Object)SpriteObjectContents.DEFAULT_ATLAS)) {
                            definitions.add("atlas=" + spriteContents.atlas().asMinimalString());
                        }
                    }
                }
            }
            if (this.colorInEventDefinition() && component.color() != null) {
                sbi = new StringBuilder();
                if (!this.preferSimpleEvents()) {
                    sbi.append("color=");
                }
                if (component.color() instanceof NamedTextColor) {
                    sbi.append(component.color());
                } else {
                    sbi.append(component.color().asHexString().toLowerCase(Locale.ROOT));
                }
                definitions.add(sbi.toString());
            }
            if (this.formattingInEventDefinition()) {
                sbi = new StringBuilder();
                if (!this.preferSimpleEvents) {
                    sbi.append("format=");
                }
                sbi.append(component.decorations().entrySet().stream().filter(e -> e.getValue() == TextDecoration.State.TRUE).map(e -> ((TextDecoration)e.getKey()).name().toLowerCase(Locale.ROOT)).collect(Collectors.joining(" ")));
                definitions.add(sbi.toString());
            }
            if (component.shadowColor() != null && component.shadowColor().alpha() != 0) {
                String hexString = component.shadowColor().asHexString().toLowerCase(Locale.ROOT);
                if (component.shadowColor().alpha() == 100) {
                    String shortHex = hexString.substring(0, 7);
                    TextColor color = TextColor.fromHexString((String)shortHex);
                    namedColor = NamedTextColor.namedColor((int)color.value());
                    if (namedColor != null) {
                        definitions.add("shadow=" + String.valueOf(namedColor));
                    } else {
                        definitions.add("shadow=" + shortHex);
                    }
                } else {
                    definitions.add("shadow=" + hexString);
                }
            }
            if (component.style().font() != null && component.style().font() != Style.DEFAULT_FONT) {
                Key font = component.style().font();
                if (font.namespace().equals("minecraft")) {
                    definitions.add("font=" + font.value());
                } else {
                    definitions.add("font=" + String.valueOf(font));
                }
            }
            if (component.insertion() != null) {
                if (component.insertion().contains(" ")) {
                    definitions.add("insert={" + component.insertion() + "}");
                } else {
                    definitions.add("insert=" + component.insertion());
                }
            }
            if (this.clickEvent != null) {
                if (this.preferSimpleEvents() && this.clickEvent.action() == ClickEvent.Action.OPEN_URL) {
                    definitions.add(((ClickEvent.Payload.Text)this.clickEvent.payload()).value());
                } else {
                    String string = this.clickEvent.action().toString().toLowerCase(Locale.ROOT);
                    ClickEvent.Payload payload = this.clickEvent.payload();
                    Objects.requireNonNull(payload);
                    namedColor = payload;
                    int n = 0;
                    definitions.add(string + "=" + (String)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClickEvent.Payload.Text.class, ClickEvent.Payload.Int.class, ClickEvent.Payload.Custom.class}, (Object)namedColor, n)) {
                        case 0 -> {
                            ClickEvent.Payload.Text text = (ClickEvent.Payload.Text)namedColor;
                            yield text.value();
                        }
                        case 1 -> {
                            ClickEvent.Payload.Int integer = (ClickEvent.Payload.Int)namedColor;
                            yield String.valueOf(integer.integer());
                        }
                        case 2 -> {
                            ClickEvent.Payload.Custom custom = (ClickEvent.Payload.Custom)namedColor;
                            yield custom.key().asMinimalString() + (String)(custom.nbt().string().isEmpty() ? "" : " payload=" + custom.nbt().string());
                        }
                        default -> "";
                    }));
                }
            }
            if (this.hoverEvent != null) {
                Object object;
                sbi = new StringBuilder();
                if (this.preferSimpleEvents()) {
                    if (this.hoverEvent.action() == HoverEvent.Action.SHOW_TEXT && (this.clickEvent == null || this.clickEvent.action() != ClickEvent.Action.OPEN_URL)) {
                        sbi.append("hover=");
                    }
                } else {
                    sbi.append(this.hoverEvent.action().toString().toLowerCase(Locale.ROOT)).append('=');
                }
                if ((object = this.hoverEvent.value()) instanceof Component) {
                    Component hoverComponent = (Component)object;
                    sbi.append(this.copy().stringify(hoverComponent));
                } else {
                    object = this.hoverEvent.value();
                    if (object instanceof HoverEvent.ShowEntity) {
                        HoverEvent.ShowEntity contentEntity = (HoverEvent.ShowEntity)object;
                        sb.append(contentEntity.id()).append(":").append(contentEntity.type());
                        if (contentEntity.name() != null) {
                            sb.append(" ").append(this.stringify(contentEntity.name()));
                        }
                    } else {
                        object = this.hoverEvent.value();
                        if (object instanceof HoverEvent.ShowItem) {
                            HoverEvent.ShowItem contentItem = (HoverEvent.ShowItem)object;
                            sb.append(contentItem.item());
                            if (contentItem.count() > 0) {
                                sb.append("*").append(contentItem.count());
                            }
                            if (contentItem.nbt() != null) {
                                sb.append(" ").append(contentItem.nbt().string());
                            }
                        }
                    }
                }
                definitions.add(sbi.toString());
            }
            sb.append(String.join((CharSequence)" ", definitions));
            sb.append(')');
        } else {
            this.appendFormatSuffix(sb, component);
        }
        return sb.toString();
    }

    private void appendText(StringBuilder sb, Component component) {
        Component component2 = component;
        Objects.requireNonNull(component2);
        Component component3 = component2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextComponent.class, TranslatableComponent.class, ObjectComponent.class}, (Object)component3, n)) {
            case 0: {
                TextComponent textComponent = (TextComponent)component3;
                sb.append(textComponent.content());
                break;
            }
            case 1: {
                TranslatableComponent translatableComponent = (TranslatableComponent)component3;
                if (translatableComponent.fallback() == null) break;
                sb.append(translatableComponent.fallback());
                break;
            }
            case 2: {
                ObjectComponent objectComponent = (ObjectComponent)component3;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot stringify " + component.getClass().getTypeName() + " yet! Only TextComponents are supported right now. Sorry. :(");
            }
        }
    }

    private void appendColor(StringBuilder sb, TextColor color) {
        if (this.color != color) {
            this.color = color;
            if (this.useLegacyColors()) {
                if (color == null) {
                    sb.append(this.colorChar()).append(Util.TextControl.RESET.getChar());
                } else {
                    try {
                        char colorChar = Util.getLegacyFormatChar((TextFormat)color);
                        sb.append(this.colorChar()).append(colorChar);
                    }
                    catch (IllegalArgumentException e) {
                        System.out.println(e.getMessage());
                    }
                }
            } else if (color instanceof NamedTextColor) {
                sb.append(this.colorChar()).append(((NamedTextColor)color).toString()).append(this.colorChar());
            } else if (color != null) {
                sb.append(this.colorChar()).append(color.asHexString()).append(this.colorChar());
            } else {
                sb.append(this.colorChar()).append(Util.TextControl.RESET.name()).append(this.colorChar());
            }
        }
    }

    private void appendFormat(StringBuilder sb, Component component) {
        Set<TextDecoration> formats = Util.getFormats(component, true);
        if (!formats.containsAll(this.formats)) {
            if (this.useLegacyFormatting()) {
                sb.append(this.colorChar()).append(Util.TextControl.RESET.getChar());
            } else {
                ArrayDeque<TextDecoration> formatDeque = new ArrayDeque<TextDecoration>(this.formats);
                while (!formatDeque.isEmpty()) {
                    TextDecoration format = (TextDecoration)formatDeque.pollLast();
                    if (formats.contains(format)) continue;
                    sb.append(MineDown.getFormatString(format));
                }
            }
        } else {
            formats.removeAll(this.formats);
        }
        for (TextDecoration format : formats) {
            if (this.useLegacyFormatting()) {
                try {
                    char colorChar = Util.getLegacyFormatChar((TextFormat)format);
                    sb.append(this.colorChar()).append(colorChar);
                }
                catch (IllegalArgumentException e) {
                    System.out.println(e.getMessage());
                }
                continue;
            }
            sb.append(MineDown.getFormatString(format));
        }
        this.formats.clear();
        this.formats.addAll(formats);
    }

    private void appendFormatSuffix(StringBuilder sb, Component component) {
        if (!this.useLegacyFormatting()) {
            Set<TextDecoration> formats = Util.getFormats(component, true);
            for (TextDecoration format : formats) {
                sb.append(MineDown.getFormatString(format));
            }
            this.formats.removeAll(formats);
        }
    }

    public MineDownStringifier copy() {
        return new MineDownStringifier().copy(this);
    }

    public MineDownStringifier copy(MineDownStringifier from) {
        this.useLegacyColors(from.useLegacyColors());
        this.useLegacyFormatting(from.useLegacyFormatting());
        this.preferSimpleEvents(from.preferSimpleEvents());
        this.formattingInEventDefinition(from.formattingInEventDefinition());
        this.colorInEventDefinition(from.colorInEventDefinition());
        this.colorChar(from.colorChar());
        return this;
    }

    public boolean useLegacyColors() {
        return this.useLegacyColors;
    }

    public MineDownStringifier useLegacyColors(boolean useLegacyColors) {
        this.useLegacyColors = useLegacyColors;
        return this;
    }

    public boolean useLegacyFormatting() {
        return this.useLegacyFormatting;
    }

    public MineDownStringifier useLegacyFormatting(boolean useLegacyFormatting) {
        this.useLegacyFormatting = useLegacyFormatting;
        return this;
    }

    public boolean preferSimpleEvents() {
        return this.preferSimpleEvents;
    }

    public MineDownStringifier preferSimpleEvents(boolean preferSimpleEvents) {
        this.preferSimpleEvents = preferSimpleEvents;
        return this;
    }

    public boolean colorInEventDefinition() {
        return this.colorInEventDefinition;
    }

    public MineDownStringifier colorInEventDefinition(boolean colorInEventDefinition) {
        this.colorInEventDefinition = colorInEventDefinition;
        return this;
    }

    public boolean formattingInEventDefinition() {
        return this.formattingInEventDefinition;
    }

    public MineDownStringifier formattingInEventDefinition(boolean formattingInEventDefinition) {
        this.formattingInEventDefinition = formattingInEventDefinition;
        return this;
    }

    public char colorChar() {
        return this.colorChar;
    }

    public MineDownStringifier colorChar(char colorChar) {
        this.colorChar = colorChar;
        return this;
    }
}

