/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.minedown;

import de.themoep.minedown.MineDownParser;
import de.themoep.minedown.MineDownStringifier;
import de.themoep.minedown.Replacer;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;

public class MineDown {
    private final String message;
    private final Replacer replacer = new Replacer();
    private final MineDownParser parser = new MineDownParser();
    private BaseComponent[] baseComponents = null;

    public MineDown(String message) {
        this.message = message;
    }

    public static BaseComponent[] parse(String message, String ... replacements) {
        return new MineDown(message).replace(replacements).toComponent();
    }

    public static String stringify(BaseComponent[] components) {
        return new MineDownStringifier().stringify(components);
    }

    public BaseComponent[] toComponent() {
        if (this.baseComponents() == null) {
            this.baseComponents = new MineDownParser().parse(this.replacer().replaceIn(this.message())).create();
        }
        return this.baseComponents();
    }

    private void reset() {
        this.baseComponents = null;
    }

    public MineDown replace(String ... replacements) {
        this.reset();
        this.replacer().replace(replacements);
        return this;
    }

    public MineDown replace(Map<String, String> replacements) {
        this.reset();
        this.replacer().replace(replacements);
        return this;
    }

    public MineDown placeholderIndicator(char placeholderIndicator) {
        this.placeholderPrefix(placeholderIndicator);
        this.placeholderSuffix(placeholderIndicator);
        return this;
    }

    public MineDown placeholderPrefix(char placeholderPrefix) {
        this.reset();
        this.replacer().placeholderPrefix(placeholderPrefix);
        return this;
    }

    public char placeholderPrefix() {
        return this.replacer().placeholderPrefix();
    }

    public MineDown placeholderSuffix(char placeholderSuffix) {
        this.reset();
        this.replacer().placeholderSuffix(placeholderSuffix);
        return this;
    }

    public char placeholderSuffix() {
        return this.replacer().placeholderSuffix();
    }

    public MineDown translateLegacyColors(boolean translateLegacyColors) {
        this.reset();
        this.parser().translateLegacyColors(translateLegacyColors);
        return this;
    }

    public MineDown colorChar(char colorChar) {
        this.reset();
        this.parser().colorChar(colorChar);
        return this;
    }

    public static String getFormatString(ChatColor format) {
        switch (format) {
            case BOLD: {
                return "**";
            }
            case ITALIC: {
                return "##";
            }
            case UNDERLINE: {
                return "__";
            }
            case STRIKETHROUGH: {
                return "~~";
            }
            case MAGIC: {
                return "??";
            }
        }
        return "";
    }

    public static ChatColor getFormatFromChar(char c) {
        switch (c) {
            case '~': {
                return ChatColor.STRIKETHROUGH;
            }
            case '_': {
                return ChatColor.UNDERLINE;
            }
            case '*': {
                return ChatColor.BOLD;
            }
            case '#': {
                return ChatColor.ITALIC;
            }
            case '?': {
                return ChatColor.MAGIC;
            }
        }
        return null;
    }

    public String message() {
        return this.message;
    }

    public Replacer replacer() {
        return this.replacer;
    }

    public MineDownParser parser() {
        return this.parser;
    }

    protected BaseComponent[] baseComponents() {
        return this.baseComponents;
    }
}

