/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.minedown;

import de.themoep.minedown.MineDown;
import de.themoep.minedown.Util;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;

public class MineDownParser {
    private ComponentBuilder builder = null;
    private boolean translateLegacyColors = true;
    private char colorChar = (char)38;
    private boolean lenient = false;
    private boolean urlDetection = true;
    public static final Pattern URL_PATTERN = Pattern.compile("^(?:(https?)://)?([-\\w_\\.]{2,}\\.[a-z]{2,4})(/\\S*)?$");
    public static final String COLOR_PREFIX = "color=";
    public static final String FORMAT_PREFIX = "format=";
    public static final String HOVER_PREFIX = "hover=";
    private StringBuilder value = new StringBuilder();
    private ChatColor color = null;
    private Set<ChatColor> format = new HashSet<ChatColor>();
    private ClickEvent clickEvent = null;
    private HoverEvent hoverEvent = null;

    public ComponentBuilder parse(String message) throws IllegalArgumentException {
        Matcher urlMatcher = this.urlDetection() ? URL_PATTERN.matcher(message) : null;
        boolean escaped = false;
        for (int i = 0; i < message.length(); ++i) {
            boolean isFormatting;
            char c = message.charAt(i);
            boolean isEscape = c == '\\' && i + 1 < message.length();
            boolean isColorCode = this.translateLegacyColors && i + 1 < message.length() && (c == '\u00a7' || c == this.colorChar);
            boolean isEvent = c == '[';
            boolean bl = isFormatting = (c == '_' || c == '*' || c == '~' || c == '?' || c == '#') && Util.isDouble(message, i);
            if (escaped) {
                escaped = false;
                if (!(isEscape || isColorCode || isEvent || isFormatting)) {
                    this.value.append('\\');
                }
            } else {
                int endIndex;
                if (isEscape) {
                    escaped = true;
                    continue;
                }
                if (isColorCode) {
                    char code;
                    if ((code = message.charAt(++i)) >= 'A' && code <= 'Z') {
                        code = (char)(code + 32);
                    }
                    ChatColor encoded = null;
                    StringBuilder colorString = new StringBuilder();
                    for (int j = i; j < message.length(); ++j) {
                        char c1 = message.charAt(j);
                        if (c1 == c) {
                            try {
                                encoded = ChatColor.valueOf((String)colorString.toString().toUpperCase());
                                i = j;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                            break;
                        }
                        if (!(c1 == '_' || c1 >= 'A' && c1 <= 'Z' || c1 >= 'a' && c1 <= 'z')) break;
                        colorString.append(c1);
                    }
                    if (encoded == null) {
                        encoded = ChatColor.getByChar((char)code);
                    }
                    if (encoded != null) {
                        if (encoded == ChatColor.RESET) {
                            this.appendValue();
                            this.color = null;
                            Util.applyFormat(this.builder, this.format);
                            this.format = new HashSet<ChatColor>();
                            continue;
                        }
                        if (!Util.isFormat(encoded)) {
                            if (this.value.length() > 0) {
                                this.appendValue();
                            }
                            this.color = encoded;
                            this.format = new HashSet<ChatColor>();
                            continue;
                        }
                        if (this.value.length() > 0) {
                            this.appendValue();
                        }
                        this.format.add(encoded);
                        continue;
                    }
                    this.value.append(c).append(code);
                    continue;
                }
                if (isEvent) {
                    int index = -1;
                    int endIndex2 = -1;
                    int j = i + 1;
                    block4: while (j + 1 < message.length() && (index = message.indexOf(93, j)) != -1) {
                        if (index + 2 < message.length() && message.charAt(index - 1) != '\\' && message.charAt(index + 1) == '(') {
                            for (int k = index + 1; k < message.length() && (endIndex2 = message.indexOf(41, k)) != -1; ++k) {
                                if (message.charAt(endIndex2 - 1) != '\\') break block4;
                            }
                        }
                        index = -1;
                        ++j;
                    }
                    if (index > i && endIndex2 > index) {
                        this.appendValue();
                        this.append(this.parseEvent(message.substring(i + 1, index), message.substring(index + 2, endIndex2)));
                        i = endIndex2;
                        continue;
                    }
                } else if (isFormatting && (endIndex = message.indexOf(String.valueOf(c) + String.valueOf(c), i + 2)) != -1) {
                    HashSet<ChatColor> formats = new HashSet<ChatColor>(this.format);
                    formats.add(MineDown.getFormatFromChar(c));
                    this.appendValue();
                    this.append(this.copy().format(formats).parse(message.substring(i + 2, endIndex)));
                    i = endIndex + 1;
                    continue;
                }
            }
            if (this.urlDetection()) {
                int urlEnd = message.indexOf(32, i);
                if (urlEnd == -1) {
                    urlEnd = message.length();
                }
                if (urlMatcher.region(i, urlEnd).find()) {
                    this.appendValue();
                    this.value = new StringBuilder(message.substring(i, urlEnd));
                    this.appendValue();
                    i = urlEnd - 1;
                    continue;
                }
            }
            this.value.append(message.charAt(i));
        }
        if (escaped) {
            this.value.append('\\');
        }
        this.appendValue();
        if (this.builder == null) {
            this.builder = new ComponentBuilder("");
        }
        return this.builder;
    }

    private void append(ComponentBuilder builder) {
        block7: {
            if (this.builder == null) {
                this.builder = new ComponentBuilder(builder);
            } else {
                BaseComponent[] components = builder.create();
                try {
                    this.builder.append(components);
                }
                catch (NoSuchMethodError e) {
                    if (components.length <= 0) break block7;
                    try {
                        Field fCurrent = this.builder.getClass().getDeclaredField("current");
                        fCurrent.setAccessible(true);
                        BaseComponent previous = (BaseComponent)fCurrent.get(this.builder);
                        Field fParts = this.builder.getClass().getDeclaredField("parts");
                        fParts.setAccessible(true);
                        List parts = (List)fParts.get(this.builder);
                        for (BaseComponent component : components) {
                            parts.add(previous);
                            fCurrent.set(this.builder, component.duplicate());
                        }
                    }
                    catch (IllegalAccessException | NoSuchFieldException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }

    private void appendValue() {
        this.appendValue(ComponentBuilder.FormatRetention.NONE);
    }

    private void appendValue(ComponentBuilder.FormatRetention retention) {
        if (this.value.length() > 0) {
            if (this.builder == null) {
                this.builder = new ComponentBuilder(this.value.toString());
            } else {
                this.builder.append(this.value.toString(), retention);
            }
            this.builder.color(this.color);
            Util.applyFormat(this.builder, this.format);
            if (URL_PATTERN.matcher(this.value).matches()) {
                this.builder.event(new ClickEvent(ClickEvent.Action.OPEN_URL, this.value.toString()));
                this.builder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Click to open url").create()));
            }
            if (this.clickEvent != null) {
                this.builder.event(this.clickEvent);
            }
            if (this.hoverEvent != null) {
                this.builder.event(this.hoverEvent);
            }
            this.value = new StringBuilder();
        }
    }

    public ComponentBuilder parseEvent(String text, String definitions) {
        ArrayList<String> defParts = new ArrayList<String>();
        if (definitions.startsWith(" ")) {
            defParts.add("");
        }
        Collections.addAll(defParts, definitions.split(" "));
        if (definitions.endsWith(" ")) {
            defParts.add("");
        }
        ChatColor color = null;
        HashSet<ChatColor> formats = new HashSet<ChatColor>();
        ClickEvent clickEvent = null;
        HoverEvent hoverEvent = null;
        int formatEnd = -1;
        for (int i = 0; i < defParts.size(); ++i) {
            String definition = (String)defParts.get(i);
            ChatColor parsed = MineDownParser.parseColor(definition, "", true);
            if (parsed != null) {
                if (Util.isFormat(parsed)) {
                    formats.add(parsed);
                } else {
                    color = parsed;
                }
                formatEnd = i;
                continue;
            }
            if (definition.toLowerCase().startsWith(COLOR_PREFIX)) {
                color = MineDownParser.parseColor(definition, COLOR_PREFIX, this.lenient());
                if (!this.lenient() && Util.isFormat(color)) {
                    throw new IllegalArgumentException(color + " is a format and not a color!");
                }
                formatEnd = i;
                continue;
            }
            if (definition.toLowerCase().startsWith(FORMAT_PREFIX)) {
                for (String formatStr : definition.substring(FORMAT_PREFIX.length()).split(",")) {
                    ChatColor format = MineDownParser.parseColor(formatStr, "", this.lenient());
                    if (!this.lenient() && !Util.isFormat(format)) {
                        throw new IllegalArgumentException(formats + " is a color and not a format!");
                    }
                    formats.add(format);
                }
                formatEnd = i;
                continue;
            }
            if (i == formatEnd + 1 && URL_PATTERN.matcher(definition).matches()) {
                clickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, definition);
                continue;
            }
            ClickEvent.Action clickAction = definition.startsWith("/") ? ClickEvent.Action.RUN_COMMAND : null;
            HoverEvent.Action hoverAction = null;
            if (definition.toLowerCase().startsWith(HOVER_PREFIX)) {
                hoverAction = HoverEvent.Action.SHOW_TEXT;
            }
            String[] parts = definition.split("=", 2);
            try {
                hoverAction = HoverEvent.Action.valueOf((String)parts[0].toUpperCase());
            }
            catch (IllegalArgumentException formatStr) {
                // empty catch block
            }
            try {
                clickAction = ClickEvent.Action.valueOf((String)parts[0].toUpperCase());
            }
            catch (IllegalArgumentException formatStr) {
                // empty catch block
            }
            boolean hasBracket = parts.length > 1 && parts[1].startsWith("{") && (clickAction != null || hoverAction != null);
            StringBuilder value = new StringBuilder();
            if (parts.length > 1 && clickAction != null || hoverAction != null) {
                if (hasBracket) {
                    value.append(parts[1].substring(1));
                } else {
                    value.append(parts[1]);
                }
            } else {
                value.append(definition);
            }
            ++i;
            while (i < defParts.size()) {
                if (!hasBracket && ((String)defParts.get(i)).indexOf(61) != -1) {
                    --i;
                    break;
                }
                value.append(" ");
                if (hasBracket && ((String)defParts.get(i)).endsWith("}")) {
                    value.append((CharSequence)defParts.get(i), 0, ((String)defParts.get(i)).length() - 1);
                    break;
                }
                value.append((String)defParts.get(i));
                ++i;
            }
            if (clickAction != null) {
                clickEvent = new ClickEvent(clickAction, value.toString());
            } else if (hoverAction == null) {
                hoverAction = HoverEvent.Action.SHOW_TEXT;
            }
            if (hoverAction == null) continue;
            hoverEvent = new HoverEvent(hoverAction, this.copy().clickEvent(null).hoverEvent(null).urlDetection(false).parse(value.toString()).create());
        }
        if (clickEvent != null && hoverEvent == null) {
            hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(clickEvent.getAction().toString().toLowerCase().replace('_', ' ')).color(ChatColor.BLUE).append(" " + clickEvent.getValue()).color(ChatColor.WHITE).create());
        }
        return this.copy().urlDetection(false).color(color).format(formats).clickEvent(clickEvent).hoverEvent(hoverEvent).parse(text);
    }

    public static ChatColor parseColor(String colorString, String prefix, boolean lenient) {
        ChatColor color;
        block5: {
            color = null;
            if (prefix.length() + 1 == colorString.length()) {
                color = ChatColor.getByChar((char)colorString.charAt(prefix.length()));
                if (color == null && !lenient) {
                    throw new IllegalArgumentException(colorString.charAt(prefix.length()) + " is not a valid " + prefix + " char!");
                }
            } else {
                try {
                    color = ChatColor.valueOf((String)colorString.substring(prefix.length()).toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    if (lenient) break block5;
                    throw e;
                }
            }
        }
        return color;
    }

    public MineDownParser copy() {
        MineDownParser copy = new MineDownParser();
        copy.lenient(this.lenient);
        copy.translateLegacyColors(this.translateLegacyColors);
        copy.colorChar(this.colorChar);
        copy.clickEvent(this.clickEvent);
        copy.hoverEvent(this.hoverEvent);
        return copy;
    }

    public ComponentBuilder builder() {
        return this.builder;
    }

    public boolean translateLegacyColors() {
        return this.translateLegacyColors;
    }

    public char colorChar() {
        return this.colorChar;
    }

    public boolean lenient() {
        return this.lenient;
    }

    public boolean urlDetection() {
        return this.urlDetection;
    }

    public StringBuilder value() {
        return this.value;
    }

    public ChatColor color() {
        return this.color;
    }

    public Set<ChatColor> format() {
        return this.format;
    }

    public ClickEvent clickEvent() {
        return this.clickEvent;
    }

    public HoverEvent hoverEvent() {
        return this.hoverEvent;
    }

    public MineDownParser builder(ComponentBuilder builder) {
        this.builder = builder;
        return this;
    }

    public MineDownParser translateLegacyColors(boolean translateLegacyColors) {
        this.translateLegacyColors = translateLegacyColors;
        return this;
    }

    public MineDownParser colorChar(char colorChar) {
        this.colorChar = colorChar;
        return this;
    }

    public MineDownParser lenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public MineDownParser urlDetection(boolean urlDetection) {
        this.urlDetection = urlDetection;
        return this;
    }

    public MineDownParser value(StringBuilder value) {
        this.value = value;
        return this;
    }

    public MineDownParser color(ChatColor color) {
        this.color = color;
        return this;
    }

    public MineDownParser format(Set<ChatColor> format) {
        this.format = format;
        return this;
    }

    public MineDownParser clickEvent(ClickEvent clickEvent) {
        this.clickEvent = clickEvent;
        return this;
    }

    public MineDownParser hoverEvent(HoverEvent hoverEvent) {
        this.hoverEvent = hoverEvent;
        return this;
    }
}

