/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.minedown;

import de.themoep.minedown.Util;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.KeybindComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;

public class Replacer {
    private final Map<String, String> replacements = new LinkedHashMap<String, String>();
    private char placeholderPrefix = (char)37;
    private char placeholderSuffix = (char)37;

    public static String replace(String message, String ... replacements) {
        return new Replacer().replace(replacements).replaceIn(message);
    }

    public static BaseComponent[] replace(BaseComponent[] message, String ... replacements) {
        return new Replacer().replace(replacements).replaceIn(message);
    }

    public Replacer replace(String ... replacements) {
        Util.validate(replacements.length % 2 == 0, "The replacement length has to be even, mapping i % 2 == 0 to the placeholder and i % 2 = 1 to the placeholder's value");
        LinkedHashMap<String, String> replacementMap = new LinkedHashMap<String, String>();
        int i = 0;
        while (i + 1 < replacements.length) {
            replacementMap.put(replacements[i], replacements[i + 1]);
            i += 2;
        }
        return this.replace(replacementMap);
    }

    public Replacer replace(Map<String, String> replacements) {
        if (replacements != null) {
            this.replacements().putAll(replacements);
        }
        return this;
    }

    public Replacer placeholderIndicator(char placeholderIndicator) {
        this.placeholderPrefix(placeholderIndicator);
        this.placeholderSuffix(placeholderIndicator);
        return this;
    }

    public BaseComponent[] replaceIn(BaseComponent[] components) {
        return this.replaceIn(Arrays.asList(components));
    }

    public BaseComponent[] replaceIn(List<BaseComponent> components) {
        BaseComponent[] returnArray = new BaseComponent[components.size()];
        for (int i = 0; i < components.size(); ++i) {
            BaseComponent component = components.get(i).duplicate();
            if (component instanceof KeybindComponent) {
                ((KeybindComponent)component).setKeybind(this.replaceIn(((KeybindComponent)component).getKeybind()));
            }
            if (component instanceof TextComponent) {
                ((TextComponent)component).setText(this.replaceIn(((TextComponent)component).getText()));
            }
            if (component instanceof TranslatableComponent) {
                ((TranslatableComponent)component).setTranslate(this.replaceIn(((TranslatableComponent)component).getTranslate()));
                ((TranslatableComponent)component).setWith(Arrays.asList(this.replaceIn(((TranslatableComponent)component).getWith())));
            }
            if (component.getClickEvent() != null) {
                component.setClickEvent(new ClickEvent(component.getClickEvent().getAction(), this.replaceIn(component.getClickEvent().getValue())));
            }
            if (component.getHoverEvent() != null) {
                component.setHoverEvent(new HoverEvent(component.getHoverEvent().getAction(), this.replaceIn(component.getHoverEvent().getValue())));
            }
            if (component.getExtra() != null) {
                component.setExtra(Arrays.asList(this.replaceIn(component.getExtra())));
            }
            returnArray[i] = component;
        }
        return returnArray;
    }

    public String replaceIn(String string) {
        for (Map.Entry<String, String> replacement : this.replacements.entrySet()) {
            string = string.replace(this.placeholderPrefix() + replacement.getKey() + this.placeholderSuffix(), replacement.getValue());
        }
        return string;
    }

    public Map<String, String> replacements() {
        return this.replacements;
    }

    public char placeholderPrefix() {
        return this.placeholderPrefix;
    }

    public char placeholderSuffix() {
        return this.placeholderSuffix;
    }

    public Replacer placeholderPrefix(char placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
        return this;
    }

    public Replacer placeholderSuffix(char placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
        return this;
    }
}

