/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.minedown.plugin.bungee;

import com.google.common.collect.ImmutableSet;
import de.themoep.minedown.MineDown;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.Title;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.TabExecutor;

public final class MineDownPlugin
extends Plugin {
    private static final Set<String> SUB_COMMANDS = ImmutableSet.of((Object)"pong", (Object)"send", (Object)"broadcast");
    private static final Map<String, Target> TARGETS = new LinkedHashMap<String, Target>();

    public void onEnable() {
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new MineDownCommand());
    }

    private boolean onCommand(CommandSender sender, String[] args) {
        Object target;
        if (args.length == 0 || !SUB_COMMANDS.contains(args[0].toLowerCase())) {
            return false;
        }
        if (!this.testPermission(sender, "minedown.command." + args[0].toLowerCase())) {
            return false;
        }
        int nextIndex = 1;
        HashSet<Object> receivers = new HashSet<Object>();
        if ("pong".equalsIgnoreCase(args[0])) {
            receivers.add(sender);
        } else if ("send".equalsIgnoreCase(args[0]) || "tell".equalsIgnoreCase(args[0])) {
            if (args.length < 2) {
                return false;
            }
            target = this.getProxy().getPlayer(args[1]);
            if (target == null) {
                sender.sendMessage("No player with the name " + args[1] + " online!");
                return false;
            }
            receivers.add(target);
            nextIndex = 2;
        } else if ("broadcast".equalsIgnoreCase(args[0])) {
            receivers.addAll(this.getProxy().getPlayers());
            receivers.add(sender);
        }
        if (args.length <= nextIndex + 1) {
            return false;
        }
        target = TARGETS.get(args[nextIndex].toLowerCase());
        if (target == null) {
            target = TARGETS.get("system");
            --nextIndex;
        }
        if (this.testPermission(sender, "minedown.command." + args[0].toLowerCase() + "." + args[nextIndex].toLowerCase())) {
            String message = Arrays.stream(args).skip(nextIndex + 1).collect(Collectors.joining(" "));
            for (CommandSender commandSender : receivers) {
                target.send(sender, commandSender, message);
            }
        }
        return true;
    }

    private boolean testPermission(CommandSender sender, String permission) {
        if (!sender.hasPermission(permission)) {
            for (String line : this.getProxy().getTranslation("no_permission", new Object[]{permission}).split("\n")) {
                sender.sendMessage(line);
            }
            return false;
        }
        return true;
    }

    static {
        TARGETS.put("chat", (sender, receiver, message) -> {
            BaseComponent[] components = MineDown.parse((String)message, (String[])new String[]{"sender", sender.getName(), "receiver", receiver.getName()});
            if (receiver instanceof ProxiedPlayer) {
                ((ProxiedPlayer)receiver).sendMessage(ChatMessageType.CHAT, components);
            } else {
                receiver.sendMessage(components);
            }
        });
        TARGETS.put("system", (sender, receiver, message) -> {
            BaseComponent[] components = MineDown.parse((String)message, (String[])new String[]{"sender", sender.getName(), "receiver", receiver.getName()});
            if (receiver instanceof ProxiedPlayer) {
                ((ProxiedPlayer)receiver).sendMessage(ChatMessageType.SYSTEM, components);
            } else {
                receiver.sendMessage(components);
            }
        });
        TARGETS.put("actionbar", (sender, receiver, message) -> {
            if (receiver instanceof ProxiedPlayer) {
                ((ProxiedPlayer)receiver).sendMessage(ChatMessageType.ACTION_BAR, MineDown.parse((String)message, (String[])new String[]{"sender", sender.getName(), "receiver", receiver.getName()}));
            } else {
                receiver.sendMessage(MineDown.parse((String)("Actionbar: " + message), (String[])new String[]{"sender", sender.getName(), "receiver", receiver.getName()}));
            }
        });
        TARGETS.put("title", (sender, receiver, message) -> {
            String subTitle = "";
            int subTitleIndex = message.indexOf("{SUBTITLE}");
            if (subTitleIndex > -1) {
                subTitle = message.substring(subTitleIndex + "{SUBTITLE}".length());
                message = message.substring(0, subTitleIndex);
            }
            if (receiver instanceof ProxiedPlayer) {
                Title title = ProxyServer.getInstance().createTitle();
                if (!message.isEmpty()) {
                    title.title(MineDown.parse((String)message, (String[])new String[]{"sender", sender.getName(), "receiver", receiver.getName()}));
                }
                if (!subTitle.isEmpty()) {
                    title.subTitle(MineDown.parse((String)subTitle, (String[])new String[]{"sender", sender.getName(), "receiver", receiver.getName()}));
                }
                title.send((ProxiedPlayer)receiver);
            } else {
                sender.sendMessage(MineDown.parse((String)("Title: " + message), (String[])new String[]{"sender", sender.getName(), "receiver", receiver.getName()}));
                sender.sendMessage(MineDown.parse((String)("Subtitle: " + subTitle), (String[])new String[]{"sender", sender.getName(), "receiver", receiver.getName()}));
            }
        });
    }

    private class MineDownCommand
    extends Command
    implements TabExecutor {
        public MineDownCommand() {
            super("minedown", "minedown.command", new String[]{"md"});
        }

        public void execute(CommandSender sender, String[] args) {
            if (!MineDownPlugin.this.onCommand(sender, args)) {
                sender.sendMessage("/" + this.getName() + " [send <player>|broadcast|pong] chat|system|actionbar|title <message>");
            }
        }

        public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
            if (args.length == 0) {
                return SUB_COMMANDS;
            }
            if ("send".equalsIgnoreCase(args[0]) && sender.hasPermission("minedown.command.send")) {
                if (args.length == 1) {
                    return MineDownPlugin.this.getProxy().getPlayers().stream().map(CommandSender::getName).collect(Collectors.toList());
                }
                if (args.length == 2) {
                    return TARGETS.keySet();
                }
            } else if (args.length == 1) {
                return TARGETS.keySet();
            }
            return new ArrayList<String>();
        }
    }

    private static interface Target {
        public void send(CommandSender var1, CommandSender var2, String var3);
    }
}

