/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bukkit.listeners;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import de.themoep.resourcepacksplugin.bukkit.WorldResourcepacks;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class ProxyPackListener
implements PluginMessageListener {
    private final WorldResourcepacks plugin;

    public ProxyPackListener(WorldResourcepacks plugin) {
        this.plugin = plugin;
    }

    public void onPluginMessageReceived(String channel, Player p, byte[] message) {
        if (!channel.equals("Resourcepack")) {
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
        String subchannel = in.readUTF();
        if (subchannel.equals("packChange")) {
            ResourcePack pack;
            Player player;
            block10: {
                String playerName = in.readUTF();
                String packName = in.readUTF();
                String packUrl = in.readUTF();
                String packHash = in.readUTF();
                player = this.plugin.getServer().getPlayer(playerName);
                if (player == null || !player.isOnline()) {
                    return;
                }
                pack = this.plugin.getPackManager().getByName(packName);
                if (pack == null) {
                    pack = new ResourcePack(packName, packUrl, packHash);
                    try {
                        this.plugin.getPackManager().addPack(pack);
                    }
                    catch (IllegalArgumentException e) {
                        pack = this.plugin.getPackManager().getByHash(packHash);
                        if (pack != null) break block10;
                        pack = this.plugin.getPackManager().getByUrl(packUrl);
                    }
                }
            }
            this.plugin.getLogger().log(this.plugin.getLogLevel(), "BungeeCord proxy send pack " + pack.getName() + " (" + pack.getUrl() + ") to player " + player.getName());
            this.plugin.getUserManager().setUserPack(player.getUniqueId(), pack);
        } else if (subchannel.equals("clearPack")) {
            String playerName = in.readUTF();
            Player player = this.plugin.getServer().getPlayer(playerName);
            if (player == null || !player.isOnline()) {
                return;
            }
            this.plugin.getLogger().log(this.plugin.getLogLevel(), "BungeeCord proxy send command to clear the pack of player " + player.getName());
            this.plugin.clearPack(player);
        } else {
            this.plugin.getLogger().log(Level.WARNING, "Unknown subchannel " + subchannel + "! Please make sure you are running a compatible plugin version on your BungeeCord!");
        }
    }
}

