/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bukkit;

import de.themoep.resourcepacksplugin.bukkit.ConfigAccessor;
import de.themoep.resourcepacksplugin.bukkit.ForwardingCommand;
import de.themoep.resourcepacksplugin.bukkit.events.ResourcePackSelectEvent;
import de.themoep.resourcepacksplugin.bukkit.events.ResourcePackSendEvent;
import de.themoep.resourcepacksplugin.bukkit.internal.InternalHelper;
import de.themoep.resourcepacksplugin.bukkit.internal.InternalHelper_fallback;
import de.themoep.resourcepacksplugin.bukkit.listeners.AuthmeLoginListener;
import de.themoep.resourcepacksplugin.bukkit.listeners.DisconnectListener;
import de.themoep.resourcepacksplugin.bukkit.listeners.ProxyPackListener;
import de.themoep.resourcepacksplugin.bukkit.listeners.WorldSwitchListener;
import de.themoep.resourcepacksplugin.core.PackAssignment;
import de.themoep.resourcepacksplugin.core.PackManager;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import de.themoep.resourcepacksplugin.core.UserManager;
import de.themoep.resourcepacksplugin.core.commands.PluginCommandExecutor;
import de.themoep.resourcepacksplugin.core.commands.ResetPackCommandExecutor;
import de.themoep.resourcepacksplugin.core.commands.ResourcepacksPluginCommandExecutor;
import de.themoep.resourcepacksplugin.core.commands.UsePackCommandExecutor;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSelectEvent;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSendEvent;
import de.themoep.utils.lang.LanguageConfig;
import de.themoep.utils.lang.bukkit.BukkitLanguageConfig;
import de.themoep.utils.lang.bukkit.LanguageManager;
import fr.xephi.authme.api.v3.AuthMeApi;
import fr.xephi.authme.events.LoginEvent;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import org.bstats.MetricsLite;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import protocolsupport.api.ProtocolSupportAPI;
import protocolsupport.api.ProtocolType;
import protocolsupport.api.ProtocolVersion;
import us.myles.ViaVersion.ViaVersionPlugin;
import us.myles.ViaVersion.api.ViaAPI;

public class WorldResourcepacks
extends JavaPlugin
implements ResourcepacksPlugin {
    private ConfigAccessor storedPacks;
    private PackManager pm = new PackManager((ResourcepacksPlugin)this);
    private UserManager um;
    private LanguageManager lm;
    private Level loglevel = Level.INFO;
    private int serverPackFormat = Integer.MAX_VALUE;
    private InternalHelper internalHelper;
    private ViaAPI viaApi;
    private boolean protocolSupportApi = false;
    private AuthMeApi authmeApi;
    private ProxyPackListener proxyPackListener;

    public void onEnable() {
        block17: {
            block15: {
                block16: {
                    Plugin protocolSupport;
                    Class internalClass;
                    boolean firstStart = !this.getDataFolder().exists();
                    this.storedPacks = new ConfigAccessor((Plugin)this, "players.yml");
                    if (!this.loadConfig()) break block15;
                    this.getServer().getPluginManager().registerEvents((Listener)new DisconnectListener(this), (Plugin)this);
                    this.getServer().getPluginManager().registerEvents((Listener)new WorldSwitchListener(this), (Plugin)this);
                    this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "rp:plugin");
                    this.proxyPackListener = new ProxyPackListener(this);
                    this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "rp:plugin", (PluginMessageListener)this.proxyPackListener);
                    this.registerCommand((PluginCommandExecutor)new ResourcepacksPluginCommandExecutor((ResourcepacksPlugin)this));
                    this.registerCommand((PluginCommandExecutor)new UsePackCommandExecutor((ResourcepacksPlugin)this));
                    this.registerCommand((PluginCommandExecutor)new ResetPackCommandExecutor((ResourcepacksPlugin)this));
                    String versionString = this.getServer().getBukkitVersion();
                    int firstPoint = versionString.indexOf(".");
                    int secondPoint = versionString.indexOf(".", firstPoint + 1);
                    int minus = versionString.indexOf("-", firstPoint + 1);
                    String versionNumberString = versionString.substring(firstPoint + 1, secondPoint < minus && secondPoint != -1 ? secondPoint : minus);
                    try {
                        int serverVersion = Integer.valueOf(versionNumberString);
                        this.serverPackFormat = serverVersion >= 13 ? 4 : (serverVersion >= 11 ? 3 : (serverVersion >= 9 ? 2 : (serverVersion >= 8 ? 1 : 0)));
                        this.getLogger().log(this.getLogLevel(), "Detected server packformat " + this.serverPackFormat + "!");
                    }
                    catch (NumberFormatException e) {
                        this.getLogger().log(Level.WARNING, "Could not get version of the server! (" + versionString + "/" + versionNumberString + ")");
                    }
                    String packageName = this.getServer().getClass().getPackage().getName();
                    String serverVersion = packageName.substring(packageName.lastIndexOf(46) + 1);
                    try {
                        internalClass = Class.forName(((Object)((Object)this)).getClass().getPackage().getName() + ".internal.InternalHelper_" + serverVersion);
                    }
                    catch (Exception e) {
                        internalClass = InternalHelper_fallback.class;
                    }
                    try {
                        if (InternalHelper.class.isAssignableFrom(internalClass)) {
                            this.internalHelper = (InternalHelper)internalClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        this.internalHelper = new InternalHelper_fallback();
                    }
                    ViaVersionPlugin viaPlugin = (ViaVersionPlugin)this.getServer().getPluginManager().getPlugin("ViaVersion");
                    if (viaPlugin != null && viaPlugin.isEnabled()) {
                        this.viaApi = viaPlugin.getApi();
                        this.getLogger().log(Level.INFO, "Detected ViaVersion " + this.viaApi.getVersion());
                    }
                    if ((protocolSupport = this.getServer().getPluginManager().getPlugin("ProtocolSupport")) != null && protocolSupport.isEnabled()) {
                        this.protocolSupportApi = true;
                        this.getLogger().log(Level.INFO, "Detected ProtocolSupport " + protocolSupport.getDescription().getVersion());
                    }
                    if (this.getConfig().getBoolean("autogeneratehashes", true)) {
                        this.getPackManager().generateHashes(null);
                    }
                    this.um = new UserManager((ResourcepacksPlugin)this);
                    if (!this.getConfig().getBoolean("disable-metrics", false)) {
                        try {
                            org.mcstats.MetricsLite metrics = new org.mcstats.MetricsLite((Plugin)this);
                            metrics.start();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        new MetricsLite((JavaPlugin)this);
                    }
                    if (firstStart) break block16;
                    Random random = new Random();
                    if (!(random.nextDouble() < 0.01)) break block17;
                }
                this.startupMessage();
                break block17;
            }
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    protected void registerCommand(PluginCommandExecutor executor) {
        this.getCommand(executor.getName()).setExecutor((CommandExecutor)new ForwardingCommand(executor));
    }

    public boolean loadConfig() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.storedPacks.reloadConfig();
        this.getLogger().log(Level.INFO, "Loading config!");
        String debugString = this.getConfig().getString("debug");
        if (debugString.equalsIgnoreCase("true")) {
            this.loglevel = Level.INFO;
        } else if (debugString.equalsIgnoreCase("false") || debugString.equalsIgnoreCase("off")) {
            this.loglevel = Level.FINE;
        } else {
            try {
                this.loglevel = Level.parse(debugString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.getLogger().log(Level.SEVERE, "Wrong config value for debug! To disable debugging just set it to \"false\"! (" + e.getMessage() + ")");
            }
        }
        this.getLogger().log(Level.INFO, "Debug level: " + this.getLogLevel().getName());
        this.lm = new LanguageManager((Plugin)this, this.getConfig().getString("default-language"), new BukkitLanguageConfig[0]);
        this.getPackManager().init();
        if (this.getConfig().isSet("packs") && this.getConfig().isConfigurationSection("packs")) {
            this.getLogger().log(this.getLogLevel(), "Loading packs:");
            ConfigurationSection packs = this.getConfig().getConfigurationSection("packs");
            for (String s : packs.getKeys(false)) {
                ConfigurationSection packSection = packs.getConfigurationSection(s);
                String packName = s.toLowerCase();
                String packUrl = packSection.getString("url", "");
                if (packUrl.isEmpty()) {
                    this.getLogger().log(Level.SEVERE, "Pack " + packName + " does not have an url defined!");
                    continue;
                }
                String packHash = packSection.getString("hash", "");
                int packFormat = packSection.getInt("format", 0);
                boolean packRestricted = packSection.getBoolean("restricted", false);
                String packPerm = packSection.getString("permission", this.getName().toLowerCase() + ".pack." + packName);
                try {
                    this.getLogger().log(Level.INFO, packName + " - " + packUrl + " - " + packHash.toLowerCase());
                    ResourcePack pack = new ResourcePack(packName, packUrl, packHash, packFormat, packRestricted, packPerm);
                    this.getPackManager().addPack(pack);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().log(Level.SEVERE, e.getMessage());
                    continue;
                }
                if (this.getServer().getPluginManager().getPermission(packPerm) != null) continue;
                Permission perm = new Permission(packPerm);
                perm.setDefault(PermissionDefault.OP);
                perm.setDescription("Permission for access to the resourcepack " + packName + " via the usepack command.");
                try {
                    this.getServer().getPluginManager().addPermission(perm);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        } else {
            this.getLogger().log(this.getLogLevel(), "No packs defined!");
        }
        if (this.getConfig().isConfigurationSection("empty")) {
            ConfigurationSection packSection = this.getConfig().getConfigurationSection("empty");
            String packName = "empty";
            String packUrl = packSection.getString("url", "");
            if (packUrl.isEmpty()) {
                this.getLogger().log(Level.SEVERE, "Empty pack does not have an url defined!");
            }
            String packHash = packSection.getString("hash", "");
            int packFormat = packSection.getInt("format", 0);
            try {
                this.getLogger().log(Level.INFO, packName + " - " + packUrl + " - " + packHash.toLowerCase());
                ResourcePack pack = new ResourcePack(packName, packUrl, packHash, packFormat, false, null);
                this.getPackManager().addPack(pack);
                this.getPackManager().setEmptyPack(pack);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().log(Level.SEVERE, e.getMessage());
            }
        } else {
            String emptypackname = this.getConfig().getString("empty", null);
            if (emptypackname != null && !emptypackname.isEmpty()) {
                ResourcePack ep = this.getPackManager().getByName(emptypackname);
                if (ep != null) {
                    this.getLogger().log(Level.INFO, "Empty pack: " + ep.getName());
                    this.getPackManager().setEmptyPack(ep);
                } else {
                    this.getLogger().log(Level.WARNING, "Cannot set empty resourcepack as there is no pack with the name " + emptypackname + " defined!");
                }
            } else {
                this.getLogger().log(Level.WARNING, "No empty pack defined!");
            }
        }
        String name = null;
        if (this.getConfig().isSet("server") && this.getConfig().isConfigurationSection("server")) {
            name = "server";
        } else if (this.getConfig().isSet("global") && this.getConfig().isConfigurationSection("global")) {
            name = "global";
        }
        if (name != null) {
            this.getLogger().log(Level.INFO, "Loading " + name + " assignment...");
            ConfigurationSection globalSection = this.getConfig().getConfigurationSection(name);
            PackAssignment globalAssignment = this.getPackManager().loadAssignment(name, this.getValues(globalSection));
            this.getPackManager().setGlobalAssignment(globalAssignment);
            this.getLogger().log(this.getLogLevel(), "Loaded " + globalAssignment.toString());
        } else {
            this.getLogger().log(this.getLogLevel(), "No global server assignment defined!");
        }
        if (this.getConfig().isSet("worlds") && this.getConfig().isConfigurationSection("worlds")) {
            this.getLogger().log(Level.INFO, "Loading world assignments...");
            ConfigurationSection worlds = this.getConfig().getConfigurationSection("worlds");
            for (String world : worlds.getKeys(false)) {
                ConfigurationSection worldSection = worlds.getConfigurationSection(world);
                if (worldSection != null) {
                    this.getLogger().log(Level.INFO, "Loading assignment for world " + world + "...");
                    PackAssignment worldAssignment = this.getPackManager().loadAssignment(world, this.getValues(worldSection));
                    this.getPackManager().addAssignment(worldAssignment);
                    this.getLogger().log(this.getLogLevel(), "Loaded " + worldAssignment.toString());
                    continue;
                }
                this.getLogger().log(Level.WARNING, "Config has entry for world " + world + " but it is not a configuration section?");
            }
        } else {
            this.getLogger().log(this.getLogLevel(), "No world assignments defined!");
        }
        if (this.getConfig().getBoolean("useauthme", true) && this.getServer().getPluginManager().getPlugin("AuthMe") != null) {
            this.authmeApi = AuthMeApi.getInstance();
            this.getLogger().log(Level.INFO, "Detected AuthMe " + this.getServer().getPluginManager().getPlugin("AuthMe").getDescription().getVersion());
            LoginEvent.getHandlerList().unregister((Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new AuthmeLoginListener(this), (Plugin)this);
        }
        return true;
    }

    private Map<String, Object> getValues(ConfigurationSection config) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String key : config.getKeys(false)) {
            if (config.get(key, null) == null) continue;
            if (config.isConfigurationSection(key)) {
                map.put(key, this.getValues(config.getConfigurationSection(key)));
                continue;
            }
            map.put(key, config.get(key));
        }
        return map;
    }

    public void reloadConfig(boolean resend) {
        this.loadConfig();
        this.getLogger().log(Level.INFO, "Reloaded config.");
        if (this.isEnabled() && resend) {
            this.getLogger().log(Level.INFO, "Resending packs for all online players!");
            this.um = new UserManager((ResourcepacksPlugin)this);
            for (Player p : this.getServer().getOnlinePlayers()) {
                this.resendPack(p);
            }
        }
    }

    public void saveConfigChanges() {
        for (ResourcePack pack : this.getPackManager().getPacks()) {
            boolean isEmptyPack = pack.equals((Object)this.getPackManager().getEmptyPack());
            String path = "packs." + pack.getName();
            if (isEmptyPack && this.getConfig().isConfigurationSection("empty")) {
                path = "empty";
            }
            this.getConfig().set(path + ".url", (Object)pack.getUrl());
            this.getConfig().set(path + ".hash", (Object)pack.getHash());
            this.getConfig().set(path + ".format", !isEmptyPack ? Integer.valueOf(pack.getFormat()) : null);
            this.getConfig().set(path + ".restricted", !isEmptyPack ? Boolean.valueOf(pack.isRestricted()) : null);
            this.getConfig().set(path + ".permission", (Object)(!isEmptyPack ? pack.getPermission() : null));
        }
        this.setConfigFlat(this.getPackManager().getGlobalAssignment().getName(), this.getPackManager().getGlobalAssignment().serialize());
        for (PackAssignment assignment : this.getPackManager().getAssignments()) {
            this.setConfigFlat("worlds." + assignment.getName(), assignment.serialize());
        }
        this.saveConfig();
    }

    private void setConfigFlat(String rootKey, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                this.setConfigFlat(rootKey + "." + entry.getKey(), (Map)entry.getValue());
                continue;
            }
            this.getConfig().set(rootKey + "." + entry.getKey(), entry.getValue());
        }
    }

    public void setStoredPack(UUID playerId, String packName) {
        this.storedPacks.getConfig().set("players." + playerId, (Object)packName);
        this.storedPacks.saveConfig();
    }

    public String getStoredPack(UUID playerId) {
        return this.storedPacks.getConfig().getString("players." + playerId);
    }

    public boolean isUsepackTemporary() {
        return this.getConfig().getBoolean("usepack-is-temporary");
    }

    public int getPermanentPackRemoveTime() {
        return this.getConfig().getInt("permanent-pack-remove-time");
    }

    public void resendPack(UUID playerId) {
        Player player = this.getServer().getPlayer(playerId);
        if (player != null) {
            this.resendPack(player);
        }
    }

    public void resendPack(Player player) {
        String worldName = "";
        if (player.getWorld() != null) {
            worldName = player.getWorld().getName();
        }
        this.getPackManager().applyPack(player.getUniqueId(), worldName);
    }

    public void setPack(UUID playerId, ResourcePack pack) {
        this.getPackManager().setPack(playerId, pack);
    }

    public void sendPack(UUID playerId, ResourcePack pack) {
        Player player = this.getServer().getPlayer(playerId);
        if (player != null) {
            this.sendPack(player, pack);
        }
    }

    public void sendPack(Player player, ResourcePack pack) {
        if (pack.getRawHash().length != 0) {
            this.internalHelper.setResourcePack(player, pack);
        } else {
            player.setResourcePack(pack.getUrl());
        }
        this.getLogger().log(this.getLogLevel(), "Send pack " + pack.getName() + " (" + pack.getUrl() + ") to " + player.getName());
    }

    public void clearPack(UUID playerId) {
        this.getUserManager().clearUserPack(playerId);
    }

    public void clearPack(Player player) {
        this.getUserManager().clearUserPack(player.getUniqueId());
    }

    public PackManager getPackManager() {
        return this.pm;
    }

    public UserManager getUserManager() {
        return this.um;
    }

    public String getMessage(ResourcepacksPlayer sender, String key, String ... replacements) {
        if (this.lm != null) {
            LanguageConfig config;
            Player player = null;
            if (sender != null) {
                player = this.getServer().getPlayer(sender.getUniqueId());
            }
            if ((config = this.lm.getConfig(player)) != null) {
                return config.get(key, replacements);
            }
            return "Missing language config! (default language: " + this.lm.getDefaultLocale() + ", key: " + key + ")";
        }
        return key;
    }

    public boolean hasMessage(ResourcepacksPlayer sender, String key) {
        if (this.lm != null) {
            Player player = null;
            if (sender != null) {
                player = this.getServer().getPlayer(sender.getUniqueId());
            }
            return this.lm.getConfig(player).contains(key);
        }
        return false;
    }

    public String getVersion() {
        return this.getDescription().getVersion();
    }

    public Level getLogLevel() {
        return this.loglevel;
    }

    public ResourcepacksPlayer getPlayer(UUID playerId) {
        Player player = this.getServer().getPlayer(playerId);
        if (player != null) {
            return new ResourcepacksPlayer(player.getName(), player.getUniqueId());
        }
        return null;
    }

    public ResourcepacksPlayer getPlayer(String playerName) {
        Player player = this.getServer().getPlayer(playerName);
        if (player != null) {
            return new ResourcepacksPlayer(player.getName(), player.getUniqueId());
        }
        return null;
    }

    public boolean sendMessage(ResourcepacksPlayer player, String key, String ... replacements) {
        return this.sendMessage(player, Level.INFO, key, replacements);
    }

    public boolean sendMessage(ResourcepacksPlayer packPlayer, Level level, String key, String ... replacements) {
        String message = this.getMessage(packPlayer, key, replacements);
        if (message.isEmpty()) {
            return false;
        }
        if (packPlayer != null) {
            Player player = this.getServer().getPlayer(packPlayer.getUniqueId());
            if (player != null) {
                player.sendMessage(message);
                return true;
            }
        } else {
            this.log(level, message);
        }
        return false;
    }

    public void log(Level level, String message) {
        this.getLogger().log(level, ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)message)));
    }

    public boolean checkPermission(ResourcepacksPlayer player, String perm) {
        if (player == null) {
            return true;
        }
        return this.checkPermission(player.getUniqueId(), perm);
    }

    public boolean checkPermission(UUID playerId, String perm) {
        Player player = this.getServer().getPlayer(playerId);
        if (player != null) {
            return player.hasPermission(perm);
        }
        return perm == null;
    }

    public int getPlayerPackFormat(UUID playerId) {
        Player player = this.getServer().getPlayer(playerId);
        if (player != null) {
            ProtocolVersion version;
            int format = this.serverPackFormat;
            if (this.viaApi != null) {
                format = this.getPackManager().getPackFormat(this.viaApi.getPlayerVersion(playerId));
            }
            if (this.protocolSupportApi && format == this.serverPackFormat && (version = ProtocolSupportAPI.getProtocolVersion((Player)player)).getProtocolType() == ProtocolType.PC) {
                format = this.getPackManager().getPackFormat(version.getId());
            }
            return format;
        }
        return -1;
    }

    public IResourcePackSelectEvent callPackSelectEvent(UUID playerId, ResourcePack pack, IResourcePackSelectEvent.Status status) {
        ResourcePackSelectEvent selectEvent = new ResourcePackSelectEvent(playerId, pack, status);
        this.getServer().getPluginManager().callEvent((Event)selectEvent);
        return selectEvent;
    }

    public IResourcePackSendEvent callPackSendEvent(UUID playerId, ResourcePack pack) {
        ResourcePackSendEvent sendEvent = new ResourcePackSendEvent(playerId, pack);
        this.getServer().getPluginManager().callEvent((Event)sendEvent);
        return sendEvent;
    }

    public boolean isAuthenticated(UUID playerId) {
        if (this.authmeApi == null) {
            return true;
        }
        Player player = this.getServer().getPlayer(playerId);
        return player != null && this.authmeApi.isAuthenticated(player);
    }

    public int runTask(Runnable runnable) {
        return this.getServer().getScheduler().runTask((Plugin)this, runnable).getTaskId();
    }

    public int runAsyncTask(Runnable runnable) {
        return this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, runnable).getTaskId();
    }

    public ProxyPackListener getProxyPackListener() {
        return this.proxyPackListener;
    }
}

