/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bukkit.listeners;

import de.themoep.resourcepacksplugin.bukkit.WorldResourcepacks;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class WorldSwitchListener
implements Listener {
    private final WorldResourcepacks plugin;

    public WorldSwitchListener(WorldResourcepacks plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onWorldSwitch(PlayerChangedWorldEvent event) {
        this.handleEvent(event.getPlayer());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.handleEvent(event.getPlayer());
    }

    private void handleEvent(Player player) {
        UUID playerId = player.getUniqueId();
        long sendDelay = -1L;
        if (player.getWorld() != null) {
            sendDelay = this.plugin.getPackManager().getAssignment(player.getWorld().getName()).getSendDelay();
        }
        if (sendDelay < 0L) {
            sendDelay = this.plugin.getPackManager().getGlobalAssignment().getSendDelay();
        }
        if (sendDelay > 0L) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.calculatePack(playerId), sendDelay);
        } else {
            this.calculatePack(playerId);
        }
    }

    private void calculatePack(UUID playerId) {
        Player player;
        if (this.plugin.isEnabled() && this.plugin.isAuthenticated(playerId) && (player = this.plugin.getServer().getPlayer(playerId)) != null) {
            String worldName = "";
            if (player.getWorld() != null) {
                worldName = player.getWorld().getName();
            }
            this.plugin.getPackManager().applyPack(player.getUniqueId(), worldName);
        }
    }
}

