/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bukkit;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.nickuc.login.api.nLoginAPI;
import com.nickuc.openlogin.bukkit.OpenLoginBukkit;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.ViaAPI;
import de.themoep.minedown.MineDown;
import de.themoep.resourcepacksplugin.bukkit.ConfigAccessor;
import de.themoep.resourcepacksplugin.bukkit.ForwardingCommand;
import de.themoep.resourcepacksplugin.bukkit.events.ResourcePackSelectEvent;
import de.themoep.resourcepacksplugin.bukkit.events.ResourcePackSendEvent;
import de.themoep.resourcepacksplugin.bukkit.internal.InternalHelper;
import de.themoep.resourcepacksplugin.bukkit.internal.InternalHelper_fallback;
import de.themoep.resourcepacksplugin.bukkit.listeners.AuthmeLoginListener;
import de.themoep.resourcepacksplugin.bukkit.listeners.ConnectListener;
import de.themoep.resourcepacksplugin.bukkit.listeners.DisconnectListener;
import de.themoep.resourcepacksplugin.bukkit.listeners.LibreLoginListener;
import de.themoep.resourcepacksplugin.bukkit.listeners.NLoginListener;
import de.themoep.resourcepacksplugin.bukkit.listeners.OpeNLoginListener;
import de.themoep.resourcepacksplugin.bukkit.listeners.ProxyPackListener;
import de.themoep.resourcepacksplugin.bukkit.listeners.WorldSwitchListener;
import de.themoep.resourcepacksplugin.core.ClientType;
import de.themoep.resourcepacksplugin.core.MinecraftVersion;
import de.themoep.resourcepacksplugin.core.PackAssignment;
import de.themoep.resourcepacksplugin.core.PackManager;
import de.themoep.resourcepacksplugin.core.PlatformType;
import de.themoep.resourcepacksplugin.core.PluginLogger;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import de.themoep.resourcepacksplugin.core.SubChannelHandler;
import de.themoep.resourcepacksplugin.core.UserManager;
import de.themoep.resourcepacksplugin.core.commands.PluginCommandExecutor;
import de.themoep.resourcepacksplugin.core.commands.ResetPackCommandExecutor;
import de.themoep.resourcepacksplugin.core.commands.ResourcepacksPluginCommandExecutor;
import de.themoep.resourcepacksplugin.core.commands.UsePackCommandExecutor;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSelectEvent;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSendEvent;
import de.themoep.utils.lang.LanguageConfig;
import de.themoep.utils.lang.bukkit.BukkitLanguageConfig;
import de.themoep.utils.lang.bukkit.LanguageManager;
import fr.xephi.authme.api.v3.AuthMeApi;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bstats.MetricsLite;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.geyser.api.GeyserApi;
import protocolsupport.api.ProtocolSupportAPI;
import protocolsupport.api.ProtocolType;
import protocolsupport.api.ProtocolVersion;
import xyz.kyngs.librelogin.api.LibreLoginPlugin;
import xyz.kyngs.librelogin.api.provider.LibreLoginProvider;

public class WorldResourcepacks
extends JavaPlugin
implements ResourcepacksPlugin {
    private ConfigAccessor storedPacks;
    private PackManager pm = new PackManager((ResourcepacksPlugin)this);
    private UserManager um;
    private LanguageManager lm;
    private Level loglevel = Level.INFO;
    private PluginLogger pluginLogger = new PluginLogger(){

        public void log(Level level, String message) {
            WorldResourcepacks.this.getLogger().log(level, message);
        }

        public void log(Level level, String message, Throwable e) {
            WorldResourcepacks.this.getLogger().log(level, message);
        }
    };
    private int serverProtocolVersion = Integer.MAX_VALUE;
    private InternalHelper internalHelper;
    protected ResourcepacksPluginCommandExecutor pluginCommand;
    private ViaAPI viaApi;
    private boolean protocolSupportApi = false;
    private GeyserApi geyser;
    private FloodgateApi floodgate;
    private AuthMeApi authmeApi = null;
    private OpenLoginBukkit openLogin = null;
    private nLoginAPI nLogin = null;
    private LibreLoginPlugin<Player, World> libreLogin = null;
    private ProxyPackListener messageChannelHandler;
    private final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat(this.getName() + " Thread - %1$d").build());

    public void onEnable() {
        block40: {
            block38: {
                block39: {
                    Plugin floodgatePlugin;
                    Plugin geyserPlugin;
                    Plugin protocolSupport;
                    Class internalClass;
                    boolean firstStart = !this.getDataFolder().exists();
                    this.storedPacks = new ConfigAccessor((Plugin)this, "players.yml");
                    File serverPropertiesFile = new File("server.properties");
                    if (serverPropertiesFile.exists() && serverPropertiesFile.isFile()) {
                        try (FileInputStream in = new FileInputStream(serverPropertiesFile);){
                            Properties properties = new Properties();
                            properties.load(in);
                            String resourcePack = properties.getProperty("resource-pack");
                            if (resourcePack != null && !resourcePack.isEmpty()) {
                                this.getLogger().log(Level.WARNING, "You seem to have defined a resource-pack in your server.properties file, if you experience issues then please remove it and configure the pack via this plugin's config directly as it works better when it can completely handle the whole sending itself.");
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    this.messageChannelHandler = new ProxyPackListener(this);
                    if (!this.loadConfig()) break block38;
                    this.getServer().getPluginManager().registerEvents((Listener)new ConnectListener(this), (Plugin)this);
                    this.getServer().getPluginManager().registerEvents((Listener)new DisconnectListener(this), (Plugin)this);
                    this.getServer().getPluginManager().registerEvents((Listener)new WorldSwitchListener(this), (Plugin)this);
                    this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "rp:plugin");
                    this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "rp:plugin", (PluginMessageListener)this.messageChannelHandler);
                    this.pluginCommand = new ResourcepacksPluginCommandExecutor((ResourcepacksPlugin)this);
                    this.registerCommand((PluginCommandExecutor)this.pluginCommand);
                    this.registerCommand((PluginCommandExecutor)new UsePackCommandExecutor((ResourcepacksPlugin)this));
                    this.registerCommand((PluginCommandExecutor)new ResetPackCommandExecutor((ResourcepacksPlugin)this));
                    String versionString = this.getServer().getBukkitVersion();
                    int minus = versionString.indexOf("-");
                    String versionNumberString = versionString.substring(0, minus > -1 ? minus : versionString.length());
                    try {
                        try {
                            Method getProtocolVersion = this.getServer().getUnsafe().getClass().getMethod("getProtocolVersion", new Class[0]);
                            this.serverProtocolVersion = (Integer)getProtocolVersion.invoke((Object)this.getServer().getUnsafe(), new Object[0]);
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ignored) {
                            this.serverProtocolVersion = MinecraftVersion.parseVersion((String)versionNumberString).getProtocolNumber();
                        }
                        this.logDebug("Detected server server protocol version " + this.serverProtocolVersion + "!");
                    }
                    catch (IllegalArgumentException e) {
                        this.logDebug("Could not get protocol number of the server! (" + versionString + "/" + versionNumberString + ")");
                    }
                    String packageName = this.getServer().getClass().getPackage().getName();
                    String serverVersion = packageName.substring(packageName.lastIndexOf(46) + 1);
                    this.logDebug("Detected internal server version " + serverVersion);
                    try {
                        internalClass = Class.forName(((Object)((Object)this)).getClass().getPackage().getName() + ".internal.InternalHelper_" + serverVersion);
                    }
                    catch (Exception e) {
                        internalClass = InternalHelper_fallback.class;
                    }
                    try {
                        this.internalHelper = InternalHelper.class.isAssignableFrom(internalClass) ? (InternalHelper)internalClass.getConstructor(WorldResourcepacks.class).newInstance(new Object[]{this}) : new InternalHelper_fallback(this);
                    }
                    catch (Exception e) {
                        this.getLogger().log(Level.WARNING, "Error while trying to create " + internalClass.getSimpleName(), e);
                        this.internalHelper = new InternalHelper_fallback(this);
                    }
                    this.logDebug("Using " + this.internalHelper.getClass().getSimpleName());
                    Plugin viaPlugin = this.getServer().getPluginManager().getPlugin("ViaVersion");
                    if (viaPlugin != null && viaPlugin.isEnabled()) {
                        this.viaApi = Via.getAPI();
                        this.getLogger().log(Level.INFO, "Detected ViaVersion " + this.viaApi.getVersion());
                    }
                    if ((protocolSupport = this.getServer().getPluginManager().getPlugin("ProtocolSupport")) != null && protocolSupport.isEnabled()) {
                        this.protocolSupportApi = true;
                        this.getLogger().log(Level.INFO, "Detected ProtocolSupport " + protocolSupport.getDescription().getVersion());
                    }
                    if ((geyserPlugin = this.getServer().getPluginManager().getPlugin("Geyser-Spigot")) != null) {
                        this.geyser = GeyserApi.api();
                        this.getLogger().log(Level.INFO, "Detected " + geyserPlugin.getName() + " " + geyserPlugin.getDescription().getVersion());
                    }
                    if ((floodgatePlugin = this.getServer().getPluginManager().getPlugin("floodgate")) != null) {
                        this.floodgate = FloodgateApi.getInstance();
                        this.getLogger().log(Level.INFO, "Detected " + floodgatePlugin.getName() + " " + floodgatePlugin.getDescription().getVersion());
                    }
                    if (this.getServer().getPluginManager().getPlugin("AuthMe") != null) {
                        this.getLogger().log(Level.INFO, "Detected AuthMe " + this.getServer().getPluginManager().getPlugin("AuthMe").getDescription().getVersion());
                        try {
                            this.authmeApi = AuthMeApi.getInstance();
                            this.getServer().getPluginManager().registerEvents((Listener)new AuthmeLoginListener(this), (Plugin)this);
                        }
                        catch (Throwable t) {
                            this.getLogger().log(Level.SEVERE, "Could not create AuthMe hook!", t);
                        }
                    }
                    if (this.getServer().getPluginManager().getPlugin("OpeNLogin") != null) {
                        try {
                            this.openLogin = (OpenLoginBukkit)this.getServer().getPluginManager().getPlugin("OpeNLogin");
                            this.getLogger().log(Level.INFO, "Detected OpeNLogin " + this.openLogin.getDescription().getVersion());
                            this.getServer().getPluginManager().registerEvents((Listener)new OpeNLoginListener(this), (Plugin)this);
                        }
                        catch (Throwable t) {
                            this.getLogger().log(Level.SEVERE, "Could not create OpeNLogin hook!", t);
                        }
                    }
                    if (this.getServer().getPluginManager().getPlugin("nLogin") != null) {
                        try {
                            this.nLogin = nLoginAPI.getApi();
                            this.getLogger().log(Level.INFO, "Detected nLogin " + this.nLogin.getVersion());
                            this.getServer().getPluginManager().registerEvents((Listener)new NLoginListener(this), (Plugin)this);
                        }
                        catch (Throwable t) {
                            this.getLogger().log(Level.SEVERE, "Could not create nLogin hook!", t);
                        }
                    }
                    if (this.getServer().getPluginManager().getPlugin("LibreLogin") != null) {
                        try {
                            this.libreLogin = ((LibreLoginProvider)this.getServer().getPluginManager().getPlugin("LibreLogin")).getLibreLogin();
                            this.getLogger().log(Level.INFO, "Detected LibreLogin " + this.libreLogin.getVersion());
                            new LibreLoginListener(this, this.libreLogin);
                        }
                        catch (Throwable t) {
                            this.getLogger().log(Level.SEVERE, "Could not create LibreLogin hook!", t);
                        }
                    }
                    if (this.getConfig().getBoolean("autogeneratehashes", true)) {
                        this.getPackManager().generateHashes(null);
                    }
                    this.um = new UserManager((ResourcepacksPlugin)this);
                    if (!this.getConfig().getBoolean("disable-metrics", false)) {
                        new MetricsLite((JavaPlugin)this);
                    }
                    if (firstStart) break block39;
                    Random random = new Random();
                    if (!(random.nextDouble() < 0.01)) break block40;
                }
                this.startupMessage();
                break block40;
            }
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.getLogger().log(Level.WARNING, "Error while trying to shut down executor service!", e);
        }
    }

    protected void registerCommand(PluginCommandExecutor executor) {
        this.getCommand(executor.getName()).setExecutor((CommandExecutor)new ForwardingCommand(executor));
    }

    public boolean loadConfig() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.storedPacks.reloadConfig();
        this.getLogger().log(Level.INFO, "Loading config!");
        String debugString = this.getConfig().getString("debug");
        if (debugString.equalsIgnoreCase("true")) {
            this.loglevel = Level.INFO;
        } else if (debugString.equalsIgnoreCase("false")) {
            this.loglevel = Level.FINE;
        } else {
            try {
                this.loglevel = Level.parse(debugString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.getLogger().log(Level.SEVERE, "Wrong config value for debug! To disable debugging just set it to \"false\"! (" + e.getMessage() + ")");
            }
        }
        this.getLogger().log(Level.INFO, "Debug level: " + this.getLogLevel().getName());
        this.messageChannelHandler.reload();
        this.lm = new LanguageManager((Plugin)this, this.getConfig().getString("default-language"), new BukkitLanguageConfig[0]);
        this.getPackManager().init();
        if (this.getConfig().isSet("packs") && this.getConfig().isConfigurationSection("packs")) {
            this.logDebug("Loading packs:");
            ConfigurationSection packs = this.getConfig().getConfigurationSection("packs");
            for (String s : packs.getKeys(false)) {
                ConfigurationSection packSection = packs.getConfigurationSection(s);
                try {
                    ResourcePack pack = this.getPackManager().loadPack(s, this.getConfigMap(packSection));
                    this.getLogger().log(Level.INFO, pack.getName() + " - " + (pack.getVariants().isEmpty() ? pack.getUrl() + " - " + pack.getHash() : pack.getVariants().size() + " variants"));
                    ResourcePack previous = this.getPackManager().addPack(pack);
                    if (previous != null) {
                        this.getLogger().log(Level.WARNING, "Multiple resource packs with name '" + previous.getName().toLowerCase() + "' found!");
                    }
                    this.logDebug(pack.serialize().toString());
                    this.registerPackPermission(pack);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().log(Level.SEVERE, "Error while loading pack " + s, e);
                }
            }
        } else {
            this.logDebug("No packs defined!");
        }
        if (this.getConfig().isConfigurationSection("empty")) {
            ConfigurationSection packSection = this.getConfig().getConfigurationSection("empty");
            try {
                ResourcePack pack = this.getPackManager().loadPack("empty", this.getConfigMap(packSection));
                this.getLogger().log(Level.INFO, "Empty pack - " + (pack.getVariants().isEmpty() ? pack.getUrl() + " - " + pack.getHash() : pack.getVariants().size() + " variants"));
                this.getPackManager().addPack(pack);
                this.getPackManager().setEmptyPack(pack);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().log(Level.SEVERE, "Error while loading empty pack", e);
            }
        } else {
            String emptypackname = this.getConfig().getString("empty", null);
            if (emptypackname != null && !emptypackname.isEmpty()) {
                ResourcePack ep = this.getPackManager().getByName(emptypackname);
                if (ep != null) {
                    this.getLogger().log(Level.INFO, "Empty pack: " + ep.getName());
                    this.getPackManager().setEmptyPack(ep);
                } else {
                    this.getLogger().log(Level.WARNING, "Cannot set empty resourcepack as there is no pack with the name " + emptypackname + " defined!");
                }
            } else {
                this.getLogger().log(Level.WARNING, "No empty pack defined!");
            }
        }
        String name = null;
        if (this.getConfig().isSet("server") && this.getConfig().isConfigurationSection("server")) {
            name = "server";
        } else if (this.getConfig().isSet("global") && this.getConfig().isConfigurationSection("global")) {
            name = "global";
        }
        if (name != null) {
            this.getLogger().log(Level.INFO, "Loading " + name + " assignment...");
            ConfigurationSection globalSection = this.getConfig().getConfigurationSection(name);
            PackAssignment globalAssignment = this.getPackManager().loadAssignment(name, this.getValues(globalSection));
            this.getPackManager().setGlobalAssignment(globalAssignment);
            this.logDebug("Loaded " + globalAssignment.toString());
        } else {
            this.logDebug("No global server assignment defined!");
        }
        if (this.getConfig().isSet("worlds") && this.getConfig().isConfigurationSection("worlds")) {
            this.getLogger().log(Level.INFO, "Loading world assignments...");
            ConfigurationSection worlds = this.getConfig().getConfigurationSection("worlds");
            for (String world : worlds.getKeys(false)) {
                ConfigurationSection worldSection = worlds.getConfigurationSection(world);
                if (worldSection != null) {
                    this.getLogger().log(Level.INFO, "Loading assignment for world " + world + "...");
                    PackAssignment worldAssignment = this.getPackManager().loadAssignment(world, this.getValues(worldSection));
                    this.getPackManager().addAssignment(worldAssignment);
                    this.logDebug("Loaded " + worldAssignment.toString());
                    continue;
                }
                this.getLogger().log(Level.WARNING, "Config has entry for world " + world + " but it is not a configuration section?");
            }
        } else {
            this.logDebug("No world assignments defined!");
        }
        this.getPackManager().setStoredPacksOverride(this.getConfig().getBoolean("stored-packs-override-assignments"));
        this.logDebug("Stored packs override assignments: " + this.getPackManager().getStoredPacksOverride());
        this.getPackManager().setAppendHashToUrl(this.getConfig().getBoolean("append-hash-to-url"));
        this.logDebug("Append hash to pack URL: " + this.getPackManager().shouldAppendHashToUrl());
        return true;
    }

    private void registerPackPermission(ResourcePack pack) {
        if (this.getServer().getPluginManager().getPermission(pack.getPermission()) == null) {
            Permission perm = new Permission(pack.getPermission());
            perm.setDefault(PermissionDefault.OP);
            perm.setDescription("Permission for access to the resourcepack " + pack.getName() + " via the usepack command and automatic sending.");
            try {
                this.getServer().getPluginManager().addPermission(perm);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        for (ResourcePack variant : pack.getVariants()) {
            this.registerPackPermission(variant);
        }
    }

    public Map<String, Object> getConfigMap(Object configuration) {
        if (configuration instanceof Map) {
            return (Map)configuration;
        }
        if (configuration instanceof ConfigurationSection) {
            return this.getValues((ConfigurationSection)configuration);
        }
        return null;
    }

    private Map<String, Object> getValues(ConfigurationSection config) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String key : config.getKeys(false)) {
            if (config.get(key, null) == null) continue;
            if (config.isConfigurationSection(key)) {
                map.put(key, this.getValues(config.getConfigurationSection(key)));
                continue;
            }
            map.put(key, config.get(key));
        }
        return map;
    }

    public void reloadConfig(boolean resend) {
        this.loadConfig();
        this.getLogger().log(Level.INFO, "Reloaded config.");
        if (this.isEnabled() && resend) {
            this.getLogger().log(Level.INFO, "Resending packs for all online players!");
            this.getUserManager().clearUserPacks();
            for (Player p : this.getServer().getOnlinePlayers()) {
                this.resendPack(p);
            }
        }
    }

    public void saveConfigChanges() {
        this.getConfig().set("packs", null);
        for (ResourcePack pack : this.getPackManager().getPacks()) {
            String path = "packs." + pack.getName();
            if (pack.equals((Object)this.getPackManager().getEmptyPack()) && this.getConfig().isConfigurationSection("empty")) {
                path = "empty";
            }
            this.setConfigFlat(path, pack.serialize());
        }
        this.setConfigFlat(this.getPackManager().getGlobalAssignment().getName(), this.getPackManager().getGlobalAssignment().serialize());
        for (PackAssignment assignment : this.getPackManager().getAssignments()) {
            this.setConfigFlat("worlds." + assignment.getName(), assignment.serialize());
        }
        this.saveConfig();
    }

    private boolean setConfigFlat(String rootKey, Map<String, Object> map) {
        boolean isEmpty = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                isEmpty &= this.setConfigFlat(rootKey + "." + entry.getKey(), (Map)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof List) {
                ((List)entry.getValue()).removeIf(e -> {
                    if (e instanceof Map) {
                        ((Map)e).entrySet().removeIf(le -> le.getValue() == null);
                        return ((Map)e).isEmpty();
                    }
                    return false;
                });
            }
            this.getConfig().set(rootKey + "." + entry.getKey(), entry.getValue());
            if (entry.getValue() == null || entry.getValue() instanceof Collection && ((Collection)entry.getValue()).isEmpty()) continue;
            isEmpty = false;
        }
        if (isEmpty) {
            this.getConfig().set(rootKey, null);
        }
        return isEmpty;
    }

    public void setStoredPack(UUID playerId, String packName) {
        this.storedPacks.getConfig().set("players." + playerId, (Object)packName);
        this.storedPacks.saveConfig();
    }

    public String getStoredPack(UUID playerId) {
        return this.storedPacks.getConfig().getString("players." + playerId, null);
    }

    public ConfigurationSection getStoredPacks() {
        return this.storedPacks.getConfig().getConfigurationSection("players");
    }

    public boolean isUsepackTemporary() {
        return this.getConfig().getBoolean("usepack-is-temporary");
    }

    public boolean areSelectedPacksRemovingExisting() {
        return this.getConfig().getBoolean("selected-packs-remove-existing");
    }

    public int getPermanentPackRemoveTime() {
        return this.getConfig().getInt("permanent-pack-remove-time");
    }

    public PlatformType getPlatformType() {
        return PlatformType.MINECRAFT_SERVER;
    }

    public void resendPack(UUID playerId) {
        Player player = this.getServer().getPlayer(playerId);
        if (player != null) {
            this.resendPack(player);
        }
    }

    public void sendPackInfo(UUID playerId) {
        Player player = this.getServer().getPlayer(playerId);
        if (player != null) {
            this.sendPackInfo(player, this.getUserManager().getUserPacks(playerId));
        }
    }

    private void sendPackInfo(Player player, List<ResourcePack> packs) {
        if (!packs.isEmpty()) {
            this.getMessageChannelHandler().sendMessage((Object)player, "packsChange", out -> {
                out.writeUTF(player.getName());
                out.writeLong(player.getUniqueId().getMostSignificantBits());
                out.writeLong(player.getUniqueId().getLeastSignificantBits());
                out.writeInt(packs.size());
                for (ResourcePack pack : packs) {
                    this.getMessageChannelHandler().writePack(out, pack);
                }
            });
        } else {
            this.getMessageChannelHandler().sendMessage((Object)player, "clearPack", out -> {
                out.writeUTF(player.getName());
                out.writeLong(player.getUniqueId().getMostSignificantBits());
                out.writeLong(player.getUniqueId().getLeastSignificantBits());
            });
        }
    }

    public void resendPack(Player player) {
        String worldName = "";
        if (player.getWorld() != null) {
            worldName = player.getWorld().getName();
        }
        this.getPackManager().applyPack(this.getPlayer(player), worldName);
    }

    public void sendPack(UUID playerId, ResourcePack pack) {
        Player player = this.getServer().getPlayer(playerId);
        if (player != null) {
            this.sendPack(player, pack);
        }
    }

    public void sendPack(Player player, ResourcePack pack) {
        int clientVersion = this.getPlayerProtocol(player.getUniqueId());
        if (clientVersion >= MinecraftVersion.MINECRAFT_1_20_3.getProtocolNumber() && (pack == null || pack == this.getPackManager().getEmptyPack())) {
            this.removePacks(player);
            return;
        }
        this.internalHelper.setResourcePack(player, pack);
        this.logDebug("Send pack " + pack.getName() + " (" + pack.getUrl() + ") to " + player.getName());
    }

    public void removePacks(UUID playerId) {
        Player player = this.getServer().getPlayer(playerId);
        if (player != null) {
            this.removePacks(player);
        }
    }

    public void removePacks(Player player) {
        if (this.supportsMultiplePacks(player.getUniqueId())) {
            try {
                this.internalHelper.removeResourcePacks(player);
                this.logDebug("Removed all packs from " + player.getName());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    public void removePack(UUID playerId, ResourcePack pack) {
        Player player = this.getServer().getPlayer(playerId);
        if (player != null) {
            this.removePack(player, pack);
        }
    }

    public void removePack(Player player, ResourcePack pack) {
        if (this.supportsMultiplePacks(player.getUniqueId())) {
            try {
                if (pack.getUuid() != null) {
                    this.internalHelper.removeResourcePack(player, pack);
                    this.logDebug("Removed pack " + pack.getName() + " (" + pack.getUuid() + ") from " + player.getName());
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    public void clearPack(UUID playerId) {
        this.getUserManager().clearUserPacks(playerId);
    }

    public void clearPack(Player player) {
        this.clearPack(player.getUniqueId());
    }

    public PackManager getPackManager() {
        return this.pm;
    }

    public UserManager getUserManager() {
        return this.um;
    }

    public String getMessage(ResourcepacksPlayer sender, String key, String ... replacements) {
        return TextComponent.toLegacyText((BaseComponent[])this.getComponents(sender, key, replacements));
    }

    public BaseComponent[] getComponents(ResourcepacksPlayer sender, String key, String ... replacements) {
        if (this.lm != null) {
            LanguageConfig config;
            Player player = null;
            if (sender != null) {
                player = this.getServer().getPlayer(sender.getUniqueId());
            }
            if ((config = this.lm.getConfig(player)) != null) {
                return MineDown.parse((String)config.get(key, replacements), (String[])new String[0]);
            }
            return TextComponent.fromLegacyText((String)("Missing language config! (default language: " + this.lm.getDefaultLocale() + ", key: " + key + ")"));
        }
        return TextComponent.fromLegacyText((String)key);
    }

    public boolean hasMessage(ResourcepacksPlayer sender, String key) {
        if (this.lm != null) {
            LanguageConfig config;
            Player player = null;
            if (sender != null) {
                player = this.getServer().getPlayer(sender.getUniqueId());
            }
            if ((config = this.lm.getConfig(player)) != null) {
                return config.contains(key, true);
            }
        }
        return false;
    }

    public String getVersion() {
        return this.getDescription().getVersion();
    }

    public PluginLogger getPluginLogger() {
        return this.pluginLogger;
    }

    public void logDebug(String message) {
        this.logDebug(message, null);
    }

    public void logDebug(String message, Throwable throwable) {
        if (this.getLogLevel() != Level.OFF) {
            this.getLogger().log(this.getLogLevel(), "[DEBUG] " + message, throwable);
        }
    }

    public Level getLogLevel() {
        return this.loglevel;
    }

    public ResourcepacksPlayer getPlayer(UUID playerId) {
        return this.getPlayer(this.getServer().getPlayer(playerId));
    }

    public ResourcepacksPlayer getPlayer(String playerName) {
        return this.getPlayer(this.getServer().getPlayerExact(playerName));
    }

    public ResourcepacksPlayer getPlayer(Player player) {
        return player != null ? new ResourcepacksPlayer(player.getName(), player.getUniqueId()) : null;
    }

    public boolean sendMessage(ResourcepacksPlayer player, String key, String ... replacements) {
        return this.sendMessage(player, Level.INFO, key, replacements);
    }

    public boolean sendMessage(ResourcepacksPlayer packPlayer, Level level, String key, String ... replacements) {
        BaseComponent[] message = this.getComponents(packPlayer, key, replacements);
        if (message.length == 0) {
            return false;
        }
        if (packPlayer != null) {
            Player player = this.getServer().getPlayer(packPlayer.getUniqueId());
            if (player != null) {
                player.spigot().sendMessage(message);
                return true;
            }
        } else {
            this.log(level, TextComponent.toLegacyText((BaseComponent[])message));
        }
        return false;
    }

    public void log(Level level, String message) {
        this.getLogger().log(level, ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)message)));
    }

    public void log(Level level, String message, Throwable throwable) {
        this.getLogger().log(level, ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)message)), throwable);
    }

    public boolean checkPermission(ResourcepacksPlayer player, String perm) {
        if (player == null) {
            return true;
        }
        return this.checkPermission(player.getUniqueId(), perm);
    }

    public boolean checkPermission(UUID playerId, String perm) {
        Player player = this.getServer().getPlayer(playerId);
        if (player != null) {
            return player.hasPermission(perm);
        }
        return perm == null;
    }

    public int getPlayerProtocol(UUID playerId) {
        Player player = this.getServer().getPlayer(playerId);
        if (player != null) {
            int protocol = this.serverProtocolVersion;
            if (this.viaApi != null) {
                protocol = this.viaApi.getPlayerVersion(playerId);
            }
            if (this.protocolSupportApi && protocol == this.serverProtocolVersion) {
                try {
                    ProtocolVersion version = ProtocolSupportAPI.getProtocolVersion((Player)player);
                    if (version.getProtocolType() == ProtocolType.PC) {
                        protocol = version.getId();
                    }
                }
                catch (IllegalStateException e) {
                    this.getLogger().warning("Unable to get version of player " + player.getName() + " using ProtocolSupport! Is it loaded correctly? (" + e.getMessage() + ")");
                    this.logDebug("Detailed ProtocolSupport error:", e);
                }
            }
            return protocol;
        }
        return -1;
    }

    public ClientType getPlayerClientType(UUID playerId) {
        if (this.geyser != null && this.geyser.isBedrockPlayer(playerId)) {
            return ClientType.BEDROCK;
        }
        if (this.floodgate != null && this.floodgate.isFloodgatePlayer(playerId)) {
            return ClientType.BEDROCK;
        }
        if (this.geyser != null || this.floodgate != null) {
            return ClientType.ORIGINAL;
        }
        return super.getPlayerClientType(playerId);
    }

    public IResourcePackSelectEvent callPackSelectEvent(UUID playerId, List<ResourcePack> packs, IResourcePackSelectEvent.Status status) {
        ResourcePackSelectEvent selectEvent = new ResourcePackSelectEvent(playerId, packs, status);
        this.getServer().getPluginManager().callEvent((Event)selectEvent);
        return selectEvent;
    }

    public IResourcePackSendEvent callPackSendEvent(UUID playerId, ResourcePack pack) {
        ResourcePackSendEvent sendEvent = new ResourcePackSendEvent(playerId, pack);
        this.getServer().getPluginManager().callEvent((Event)sendEvent);
        return sendEvent;
    }

    public boolean isAuthenticated(UUID playerId) {
        Player player = this.getServer().getPlayer(playerId);
        if (this.getConfig().getBoolean("use-auth-plugin", this.getConfig().getBoolean("useauth", false))) {
            if (this.authmeApi != null) {
                return player != null && this.authmeApi.isAuthenticated(player);
            }
            if (this.openLogin != null) {
                return player != null && this.openLogin.getLoginManagement().isAuthenticated(player.getName());
            }
            if (this.nLogin != null) {
                return player != null && this.nLogin.isAuthenticated(player.getName());
            }
            if (this.libreLogin != null) {
                return player != null && this.libreLogin.getAuthorizationProvider().isAuthorized((Object)player);
            }
        }
        return true;
    }

    public int runTask(Runnable runnable) {
        return this.getServer().getScheduler().runTask((Plugin)this, runnable).getTaskId();
    }

    public int runAsyncTask(Runnable runnable) {
        this.executor.execute(runnable);
        return 0;
    }

    public SubChannelHandler<Player> getMessageChannelHandler() {
        return this.messageChannelHandler;
    }

    protected InternalHelper getInternalHelper() {
        return this.internalHelper;
    }
}

