/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bukkit.listeners;

import com.google.common.io.ByteArrayDataInput;
import de.themoep.resourcepacksplugin.bukkit.ConfigAccessor;
import de.themoep.resourcepacksplugin.bukkit.WorldResourcepacks;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import de.themoep.resourcepacksplugin.core.SubChannelHandler;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class ProxyPackListener
extends SubChannelHandler<Player>
implements PluginMessageListener,
Listener {
    private final WorldResourcepacks plugin;
    private final ConfigAccessor keyConfig;
    private boolean playerJoined = false;

    public ProxyPackListener(WorldResourcepacks plugin) {
        super((ResourcepacksPlugin)plugin);
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.keyConfig = new ConfigAccessor((Plugin)plugin, "key.yml");
        this.registerSubChannel("removePackRequest", (p, in) -> {
            String playerName = in.readUTF();
            UUID playerUuid = new UUID(in.readLong(), in.readLong());
            ResourcePack pack = this.readPack((ByteArrayDataInput)in);
            if (pack == null) {
                plugin.logDebug("Proxy sent command to send a pack removal request for an unknown pack for player " + playerName + "?");
                return;
            }
            Player player = plugin.getServer().getPlayer(playerUuid);
            if (player == null || !player.isOnline()) {
                plugin.logDebug("Proxy sent command to send a pack removal request for pack " + pack.getName() + "/" + pack.getUuid() + " of player " + playerName + " but they aren't online?");
                return;
            }
            if (pack.equals((Object)plugin.getPackManager().getEmptyPack())) {
                plugin.logDebug("Proxy sent command to send a pack removal request for all packs for player " + playerName);
                plugin.removePacks(playerUuid);
                return;
            }
            plugin.logDebug("Proxy send command to send a pack removal request for pack " + pack.getName() + "/" + pack.getUuid() + " for player " + playerName);
            try {
                plugin.removePack(player, pack);
            }
            catch (UnsupportedOperationException unsupported) {
                plugin.logDebug("Proxy sent command to send a pack removal request for pack " + pack.getName() + "/" + pack.getUuid() + " for player " + playerName + " but the server doesn't support it?");
            }
        });
    }

    public void onPluginMessageReceived(String channel, Player p, byte[] message) {
        if (!this.plugin.isEnabled() || !channel.equals("rp:plugin")) {
            return;
        }
        this.handleMessage(p, message);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.playerJoined) {
            if (this.acceptsNewKey()) {
                this.setKey("");
            }
        } else {
            this.playerJoined = true;
        }
    }

    protected void sendPluginMessage(Player target, byte[] data) {
        try {
            target.sendPluginMessage((Plugin)this.plugin, "rp:plugin", data);
        }
        catch (Exception e) {
            this.plugin.log(Level.WARNING, "Failed to send plugin message to " + this.getTargetType() + " (via " + target.getName() + " connection)! This is most likely because the player connection timed out. " + e.getMessage());
            this.plugin.logDebug("Plugin message sending error:", e);
        }
    }

    protected void saveKey(String key) {
        this.keyConfig.getConfig().set("key", (Object)key);
        this.keyConfig.saveConfig();
    }

    protected String loadKey() {
        this.keyConfig.reloadConfig();
        return this.keyConfig.getConfig().getString("key", null);
    }

    protected String getTargetType() {
        return "proxy";
    }

    protected boolean trustsSender() {
        return false;
    }
}

