/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bungee;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import de.themoep.resourcepacksplugin.bungee.BungeeResourcepacksCommand;
import de.themoep.resourcepacksplugin.bungee.BungeeStatsLite;
import de.themoep.resourcepacksplugin.bungee.UsePackCommand;
import de.themoep.resourcepacksplugin.bungee.YamlConfig;
import de.themoep.resourcepacksplugin.bungee.events.ResourcePackSelectEvent;
import de.themoep.resourcepacksplugin.bungee.events.ResourcePackSendEvent;
import de.themoep.resourcepacksplugin.bungee.listeners.DisconnectListener;
import de.themoep.resourcepacksplugin.bungee.listeners.PluginMessageListener;
import de.themoep.resourcepacksplugin.bungee.listeners.ServerSwitchListener;
import de.themoep.resourcepacksplugin.bungee.packets.ResourcePackSendPacket;
import de.themoep.resourcepacksplugin.core.PackManager;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import de.themoep.resourcepacksplugin.core.UserManager;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSelectEvent;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSendEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.protocol.BadPacketException;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.ProtocolConstants;

public class BungeeResourcepacks
extends Plugin
implements ResourcepacksPlugin {
    private static BungeeResourcepacks instance;
    private YamlConfig config;
    private PackManager pm;
    private UserManager um;
    private Level loglevel = Level.INFO;
    private Map<UUID, Boolean> backendPackedPlayers = new ConcurrentHashMap<UUID, Boolean>();
    private Set<UUID> authenticatedPlayers = new HashSet<UUID>();
    private boolean enabled = false;
    private int bungeeVersion;

    public void onEnable() {
        instance = this;
        try {
            Method reg;
            List supportedVersions = new ArrayList();
            try {
                Field svField = Protocol.class.getField("supportedVersions");
                supportedVersions = (List)svField.get(null);
            }
            catch (Exception svField) {
                // empty catch block
            }
            if (supportedVersions.size() == 0) {
                Field svIdField = ProtocolConstants.class.getField("SUPPORTED_VERSION_IDS");
                supportedVersions = (List)svIdField.get(null);
            }
            this.bungeeVersion = (Integer)supportedVersions.get(supportedVersions.size() - 1);
            if (this.bungeeVersion == 47) {
                this.getLogger().log(Level.INFO, "BungeeCord 1.8 detected!");
                reg = Protocol.DirectionData.class.getDeclaredMethod("registerPacket", Integer.TYPE, Class.class);
                reg.setAccessible(true);
                reg.invoke((Object)Protocol.GAME.TO_CLIENT, 72, ResourcePackSendPacket.class);
            } else if (this.bungeeVersion >= 107 && this.bungeeVersion < 110) {
                this.getLogger().log(Level.INFO, "BungeeCord 1.9-1.9.3 detected!");
                reg = Protocol.DirectionData.class.getDeclaredMethod("registerPacket", Integer.TYPE, Integer.TYPE, Class.class);
                reg.setAccessible(true);
                reg.invoke((Object)Protocol.GAME.TO_CLIENT, 72, 50, ResourcePackSendPacket.class);
            } else if (this.bungeeVersion >= 110) {
                this.getLogger().log(Level.INFO, "BungeeCord 1.9.4+ detected!");
                Method map = Protocol.class.getDeclaredMethod("map", Integer.TYPE, Integer.TYPE);
                map.setAccessible(true);
                Object mapping18 = map.invoke(null, 47, 72);
                Object mapping19 = map.invoke(null, 107, 50);
                Object mappingsObject = Array.newInstance(mapping18.getClass(), 2);
                Array.set(mappingsObject, 0, mapping18);
                Array.set(mappingsObject, 1, mapping19);
                Object[] mappings = (Object[])mappingsObject;
                Method reg2 = Protocol.DirectionData.class.getDeclaredMethod("registerPacket", Class.class, mappings.getClass());
                reg2.setAccessible(true);
                reg2.invoke((Object)Protocol.GAME.TO_CLIENT, ResourcePackSendPacket.class, mappings);
            } else {
                this.getLogger().log(Level.SEVERE, "Unsupported BungeeCord version found! You need at least 1.8 for this plugin to work!");
                this.setEnabled(false);
                return;
            }
            this.getProxy().getPluginManager().registerCommand((Plugin)BungeeResourcepacks.getInstance(), (Command)new BungeeResourcepacksCommand(this, this.getDescription().getName().toLowerCase().charAt(0) + "rp", this.getDescription().getName().toLowerCase() + ".command", this.getDescription().getName().toLowerCase()));
            this.getProxy().getPluginManager().registerCommand((Plugin)BungeeResourcepacks.getInstance(), (Command)new UsePackCommand(this, "usepack", this.getDescription().getName().toLowerCase() + ".command.usepack", new String[0]));
            this.setEnabled(this.loadConfig());
            if (this.isEnabled() && this.getConfig().getBoolean("autogeneratehashes", true)) {
                this.getPackManager().generateHashes(null);
            }
            this.um = new UserManager(this);
            this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new DisconnectListener(this));
            this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new ServerSwitchListener(this));
            this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new PluginMessageListener(this));
            this.getProxy().registerChannel("Resourcepack");
            BungeeStatsLite stats = new BungeeStatsLite(this);
            stats.start();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            this.getLogger().log(Level.SEVERE, "Couldn't find the registerPacket method in the Protocol.DirectionData class! Please update this plugin or downgrade BungeeCord!");
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            this.getLogger().log(Level.SEVERE, "Couldn't find the field with the supported versions! Please update this plugin or downgrade BungeeCord!");
            e.printStackTrace();
        }
    }

    @Override
    public boolean loadConfig() {
        List<String> globalsecondary;
        String globalpackname;
        try {
            this.config = new YamlConfig(this, this.getDataFolder() + File.separator + "config.yml");
            this.getLogger().log(Level.INFO, "Loading config!");
        }
        catch (IOException e) {
            this.getLogger().severe("Unable to load configuration! " + this.getDescription().getName() + " will not be enabled!");
            e.printStackTrace();
            return false;
        }
        try {
            String debugString = this.getConfig().getString("debug", "true");
            if (debugString.equalsIgnoreCase("true")) {
                this.loglevel = Level.INFO;
            } else if (debugString.equalsIgnoreCase("false")) {
                this.loglevel = Level.OFF;
            } else {
                try {
                    this.loglevel = Level.parse(debugString.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().log(Level.SEVERE, "Wrong config value for debug!", e);
                }
            }
        }
        catch (ClassCastException e) {
            this.loglevel = this.getConfig().getBoolean("debug", true) ? Level.INFO : Level.OFF;
        }
        this.getLogger().log(Level.INFO, "Debug level: " + this.getLogLevel().getName());
        if (this.getConfig().isSet("useauth")) {
            this.getLogger().log(this.getLogLevel(), "Use backend auth: " + this.getConfig().getBoolean("useauth"));
        }
        this.pm = new PackManager(this);
        Configuration packs = this.getConfig().getSection("packs");
        this.getLogger().log(this.getLogLevel(), "Loading packs:");
        for (String s : packs.getKeys()) {
            Configuration packSection = packs.getSection(s);
            String packName = s.toLowerCase();
            String packUrl = packSection.getString("url", "");
            if (packUrl.isEmpty()) {
                this.getLogger().log(Level.SEVERE, "Pack " + (String)packName + " does not have an url defined!");
                continue;
            }
            String packHash = packSection.getString("hash", "");
            int packFormat = packSection.getInt("format", 0);
            boolean packRestricted = packSection.getBoolean("restricted", false);
            String packPerm = packSection.getString("permission", this.getName().toLowerCase() + ".pack." + (String)packName);
            ResourcePack pack = new ResourcePack(packName, packUrl, packHash, packFormat, packRestricted, packPerm);
            this.getLogger().log(this.getLogLevel(), pack.getName() + " - " + pack.getUrl() + " - " + pack.getHash());
            try {
                this.getPackManager().addPack(pack);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().log(Level.SEVERE, e.getMessage());
            }
        }
        String emptypackname = this.getConfig().getString("empty");
        if (emptypackname != null && !emptypackname.isEmpty()) {
            ResourcePack ep = this.getPackManager().getByName(emptypackname);
            if (ep != null) {
                this.getLogger().log(this.getLogLevel(), "Empty pack: " + ep.getName());
                this.getPackManager().setEmptyPack(ep);
            } else {
                this.getLogger().warning("Cannot set empty resourcepack as there is no pack with the name " + emptypackname + " defined!");
            }
        }
        if ((globalpackname = this.getConfig().getString("global.pack")) != null && !globalpackname.isEmpty()) {
            ResourcePack gp = this.getPackManager().getByName(globalpackname);
            if (gp != null) {
                this.getLogger().log(this.getLogLevel(), "Global pack: " + gp.getName() + "!");
                this.getPackManager().setGlobalPack(gp);
            } else {
                this.getLogger().warning("Cannot set global resourcepack as there is no pack with the name " + globalpackname + " defined!");
            }
        }
        if ((globalsecondary = this.getConfig().getStringList("global.secondary")) != null && globalsecondary.size() > 0) {
            this.getLogger().log(this.getLogLevel(), "Global secondary packs:");
            for (String secondarypack : globalsecondary) {
                ResourcePack sp = this.getPackManager().getByName(secondarypack);
                if (sp != null) {
                    this.getPackManager().addGlobalSecondary(sp);
                    this.getLogger().log(this.getLogLevel(), sp.getName());
                    continue;
                }
                this.getLogger().warning("Cannot add resourcepack as a global secondaray pack as there is no pack with the name " + secondarypack + " defined!");
            }
        }
        Configuration servers = this.getConfig().getSection("servers");
        for (String s : servers.getKeys()) {
            List serversecondary;
            this.getLogger().log(this.getLogLevel(), "Loading settings for server " + s + "!");
            String packname = servers.getString(s + ".pack");
            if (packname != null && !packname.isEmpty()) {
                ResourcePack sp = this.getPackManager().getByName(packname);
                if (sp != null) {
                    this.getPackManager().addServer(s, sp);
                    this.getLogger().log(this.getLogLevel(), "Pack: " + sp.getName() + "!");
                } else {
                    this.getLogger().warning("Cannot set resourcepack for " + s + " as there is no pack with the name " + packname + " defined!");
                }
            } else {
                this.getLogger().log(this.getLogLevel(), "No pack setting for " + s + "!");
            }
            if ((serversecondary = servers.getStringList(s + ".secondary")) == null || serversecondary.size() <= 0) continue;
            this.getLogger().log(this.getLogLevel(), "Secondary packs:");
            for (String secondarypack : serversecondary) {
                ResourcePack sp = this.getPackManager().getByName(secondarypack);
                if (sp != null) {
                    this.getPackManager().addServerSecondary(s, sp);
                    this.getLogger().log(this.getLogLevel(), sp.getName());
                    continue;
                }
                this.getLogger().warning("Cannot add resourcepack as a secondary pack for server " + s + " as there is no pack with the name " + secondarypack + " defined!");
            }
        }
        return true;
    }

    @Override
    public void reloadConfig(boolean resend) {
        this.loadConfig();
        this.getLogger().log(Level.INFO, "Reloaded config.");
        if (this.isEnabled() && resend) {
            this.getLogger().log(Level.INFO, "Resending packs for all online players!");
            this.um = new UserManager(this);
            for (ProxiedPlayer p : this.getProxy().getPlayers()) {
                this.resendPack(p);
            }
        }
    }

    @Override
    public void saveConfigChanges() {
        for (ResourcePack pack : this.getPackManager().getPacks()) {
            String path = "packs." + pack.getName();
            this.getConfig().set(path + ".url", pack.getUrl());
            this.getConfig().set(path + ".hash", pack.getHash());
            this.getConfig().set(path + ".format", pack.getFormat());
            this.getConfig().set(path + ".restricted", pack.isRestricted());
            this.getConfig().set(path + ".permission", pack.getPermission());
        }
        this.getConfig().save();
    }

    public static BungeeResourcepacks getInstance() {
        return instance;
    }

    public YamlConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void resendPack(ProxiedPlayer player) {
        String serverName = "";
        if (player.getServer() != null) {
            serverName = player.getServer().getInfo().getName();
        }
        this.getPackManager().applyPack(player.getUniqueId(), serverName);
    }

    @Override
    public void resendPack(UUID playerId) {
        ProxiedPlayer player = this.getProxy().getPlayer(playerId);
        if (player != null) {
            this.resendPack(player);
        }
    }

    protected void sendPack(ProxiedPlayer player, ResourcePack pack) {
        int clientVersion = player.getPendingConnection().getVersion();
        if (clientVersion >= 47) {
            try {
                ResourcePackSendPacket packet = new ResourcePackSendPacket(pack.getUrl(), pack.getHash());
                player.unsafe().sendPacket((DefinedPacket)packet);
                this.sendPackInfo(player, pack);
                this.getLogger().log(this.getLogLevel(), "Send pack " + pack.getName() + " (" + pack.getUrl() + ") to " + player.getName());
            }
            catch (BadPacketException e) {
                this.getLogger().log(Level.SEVERE, e.getMessage() + " Please check for updates!");
            }
            catch (ClassCastException e) {
                this.getLogger().log(Level.SEVERE, "Packet defined was not ResourcePackSendPacket? Please check for updates!");
            }
        } else {
            this.getLogger().log(Level.WARNING, "Cannot send the pack " + pack.getName() + " (" + pack.getUrl() + ") to " + player.getName() + " as he uses the unsupported protocol version " + clientVersion + "!");
            this.getLogger().log(Level.WARNING, "Consider blocking access to your server for clients with version under 1.8 if you want this plugin to work for everyone!");
        }
    }

    public void sendPackInfo(ProxiedPlayer player, ResourcePack pack) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        if (pack != null) {
            out.writeUTF("packChange");
            out.writeUTF(player.getName());
            out.writeUTF(pack.getName());
            out.writeUTF(pack.getUrl());
            out.writeUTF(pack.getHash());
        } else {
            out.writeUTF("clearPack");
            out.writeUTF(player.getName());
        }
        player.getServer().sendData("Resourcepack", out.toByteArray());
    }

    @Override
    public void setPack(UUID playerId, ResourcePack pack) {
        this.getPackManager().setPack(playerId, pack);
    }

    @Override
    public void sendPack(UUID playerId, ResourcePack pack) {
        ProxiedPlayer player = this.getProxy().getPlayer(playerId);
        if (player != null) {
            this.sendPack(player, pack);
        }
    }

    public void clearPack(ProxiedPlayer player) {
        this.clearPack(player.getUniqueId());
    }

    @Override
    public void clearPack(UUID playerId) {
        this.getUserManager().clearUserPack(playerId);
    }

    @Override
    public PackManager getPackManager() {
        return this.pm;
    }

    @Override
    public UserManager getUserManager() {
        return this.um;
    }

    public void setBackend(UUID playerId) {
        this.backendPackedPlayers.put(playerId, false);
    }

    public void unsetBackend(UUID playerId) {
        this.backendPackedPlayers.remove(playerId);
    }

    public boolean hasBackend(UUID playerId) {
        return this.backendPackedPlayers.containsKey(playerId);
    }

    @Override
    public String getMessage(String key) {
        String msg = this.getConfig().getString("messages." + key, this.getConfig().getDefaults().getString("messages." + key));
        if (msg == null || msg.isEmpty()) {
            msg = "&cUnknown message key: &6messages." + key;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }

    @Override
    public String getMessage(String key, Map<String, String> replacements) {
        String msg = this.getMessage(key);
        if (replacements != null) {
            for (Map.Entry<String, String> repl : replacements.entrySet()) {
                msg = msg.replace("%" + repl.getKey() + "%", repl.getValue());
            }
        }
        return msg;
    }

    @Override
    public String getName() {
        return this.getDescription().getName();
    }

    @Override
    public String getVersion() {
        return this.getDescription().getVersion();
    }

    @Override
    public Level getLogLevel() {
        return this.loglevel;
    }

    @Override
    public ResourcepacksPlayer getPlayer(UUID playerId) {
        ProxiedPlayer player = this.getProxy().getPlayer(playerId);
        if (player != null) {
            return new ResourcepacksPlayer(player.getName(), player.getUniqueId());
        }
        return null;
    }

    @Override
    public ResourcepacksPlayer getPlayer(String playerName) {
        ProxiedPlayer player = this.getProxy().getPlayer(playerName);
        if (player != null) {
            return new ResourcepacksPlayer(player.getName(), player.getUniqueId());
        }
        return null;
    }

    @Override
    public boolean sendMessage(ResourcepacksPlayer player, String message) {
        return this.sendMessage(player, Level.INFO, message);
    }

    @Override
    public boolean sendMessage(ResourcepacksPlayer player, Level level, String message) {
        if (player != null) {
            ProxiedPlayer proxyPlayer = this.getProxy().getPlayer(player.getUniqueId());
            if (proxyPlayer != null) {
                proxyPlayer.sendMessage(TextComponent.fromLegacyText((String)message));
                return true;
            }
        } else {
            this.getLogger().log(level, message);
        }
        return false;
    }

    @Override
    public boolean checkPermission(ResourcepacksPlayer player, String perm) {
        if (player == null) {
            return true;
        }
        return this.checkPermission(player.getUniqueId(), perm);
    }

    @Override
    public boolean checkPermission(UUID playerId, String perm) {
        ProxiedPlayer proxiedPlayer = this.getProxy().getPlayer(playerId);
        if (proxiedPlayer != null) {
            return proxiedPlayer.hasPermission(perm);
        }
        return false;
    }

    @Override
    public int getPlayerPackFormat(UUID playerId) {
        ProxiedPlayer proxiedPlayer = this.getProxy().getPlayer(playerId);
        if (proxiedPlayer != null) {
            return this.getPackManager().getPackFormat(proxiedPlayer.getPendingConnection().getVersion());
        }
        return -1;
    }

    @Override
    public IResourcePackSelectEvent callPackSelectEvent(UUID playerId, ResourcePack pack, IResourcePackSelectEvent.Status status) {
        ResourcePackSelectEvent selectEvent = new ResourcePackSelectEvent(playerId, pack, status);
        this.getProxy().getPluginManager().callEvent((Event)selectEvent);
        return selectEvent;
    }

    @Override
    public IResourcePackSendEvent callPackSendEvent(UUID playerId, ResourcePack pack) {
        ResourcePackSendEvent sendEvent = new ResourcePackSendEvent(playerId, pack);
        this.getProxy().getPluginManager().callEvent((Event)sendEvent);
        return sendEvent;
    }

    @Override
    public boolean isAuthenticated(UUID playerId) {
        return !this.getConfig().getBoolean("useauth", false) || this.authenticatedPlayers.contains(playerId);
    }

    @Override
    public int runAsync(Runnable runnable) {
        return this.getProxy().getScheduler().runAsync((Plugin)this, runnable).getId();
    }

    public void setAuthenticated(UUID playerId, boolean b) {
        if (b) {
            this.authenticatedPlayers.add(playerId);
        } else {
            this.authenticatedPlayers.remove(playerId);
        }
    }

    public int getBungeeVersion() {
        return this.bungeeVersion;
    }
}

