/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bungee;

import com.google.common.base.Throwables;
import de.themoep.resourcepacksplugin.bungee.BungeeConfigProvider;
import de.themoep.resourcepacksplugin.bungee.StatsLite;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;

public final class BungeeStatsLite
extends StatsLite {
    private final Plugin plugin;
    private ScheduledTask task;

    public BungeeStatsLite(Plugin plugin) {
        super(BungeeConfigProvider.INSTANCE);
        this.plugin = Objects.requireNonNull(plugin, "plugin");
    }

    @Override
    protected void register(int interval, TimeUnit unit) {
        this.task = this.plugin.getProxy().getScheduler().schedule(this.plugin, (Runnable)this, 0L, (long)interval, unit);
    }

    @Override
    protected void log(String message) {
        this.plugin.getLogger().info(message);
    }

    @Override
    protected void handleException(String message, Exception e) {
        this.plugin.getLogger().log(Level.WARNING, message, e);
    }

    @Override
    protected void handleSubmitException(Exception e) {
        this.plugin.getLogger().log(Level.FINE, "Failed to submit plugin statistics: {0}", Throwables.getRootCause((Throwable)e).toString());
    }

    @Override
    protected void cancel() {
        this.task.cancel();
        this.task = null;
    }

    @Override
    protected String getPluginName() {
        return this.plugin.getDescription().getName();
    }

    @Override
    protected String getPluginVersion() {
        return this.plugin.getDescription().getVersion();
    }

    @Override
    protected String getServerVersion() {
        return this.plugin.getProxy().getVersion() + " (MC: " + this.plugin.getProxy().getGameVersion() + ')';
    }

    @Override
    protected int getOnlinePlayerCount() {
        return this.plugin.getProxy().getOnlineCount();
    }

    @Override
    protected boolean isOnlineMode() {
        return this.plugin.getProxy().getConfig().isOnlineMode();
    }
}

