/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bungee;

import de.themoep.resourcepacksplugin.bungee.StatsLite;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;

final class SimpleConfigFileProvider
implements StatsLite.ConfigProvider {
    private final Path configFile;
    private boolean optOut;
    private String uniqueId;

    SimpleConfigFileProvider(Path configFile) {
        this.configFile = Objects.requireNonNull(configFile, "configFile");
    }

    @Override
    public void reload() throws IOException {
        if (Files.exists(this.configFile, new LinkOption[0])) {
            Properties properties = new Properties();
            try (InputStream in = Files.newInputStream(this.configFile, new OpenOption[0]);){
                properties.load(in);
            }
            this.optOut = Boolean.parseBoolean(properties.getProperty("opt-out"));
            this.uniqueId = properties.getProperty("guid");
        } else {
            Properties properties = new Properties();
            properties.put("opt-out", "false");
            properties.put("guid", UUID.randomUUID().toString());
            try (OutputStream out = Files.newOutputStream(this.configFile, StandardOpenOption.CREATE);){
                properties.store(out, "Set opt-out to true to stop submitting plugin statistics to http://mcstats.org");
            }
        }
    }

    @Override
    public boolean isOptOut() {
        return this.optOut;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }
}

