/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bungee;

import com.google.gson.stream.JsonWriter;
import de.themoep.resourcepacksplugin.bungee.SimpleConfigFileProvider;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;

public abstract class StatsLite
implements Runnable {
    public static final String VERSION = "0.2.2";
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("mcstats.debug"));
    private static final String DEFAULT_CONFIG_FILE = "mcstats.properties";
    private static final int REVISION = 7;
    private static final String BASE_URL = "http://report.mcstats.org";
    private static final String REPORT_URL = "http://report.mcstats.org/plugin/";
    private static final int PING_INTERVAL = 15;
    private static final TimeUnit PING_INTERVAL_UNIT = TimeUnit.MINUTES;
    private final ConfigProvider config;
    private boolean running;
    private boolean ping;

    protected StatsLite(ConfigProvider config) {
        this.config = Objects.requireNonNull(config, "config");
    }

    protected StatsLite(Path configDir) {
        Objects.requireNonNull(configDir, "configDir");
        this.config = new SimpleConfigFileProvider(configDir.resolve(DEFAULT_CONFIG_FILE));
    }

    protected abstract void register(int var1, TimeUnit var2);

    public final boolean start() {
        if (!this.running) {
            try {
                this.config.reload();
                if (!this.config.isOptOut()) {
                    this.running = true;
                    this.ping = false;
                    this.register(15, PING_INTERVAL_UNIT);
                    return true;
                }
            }
            catch (Exception e) {
                this.handleException("Failed to start plugin statistic client", e);
            }
        }
        return false;
    }

    @Override
    public final void run() {
        try {
            this.config.reload();
        }
        catch (IOException e) {
            this.handleException("Failed to reload mcstats configuration", e);
            this.stop();
        }
        if (this.config.isOptOut()) {
            this.stop();
            return;
        }
        try {
            this.post(this.config.getUniqueId(), this.ping);
            this.ping = true;
        }
        catch (Exception e) {
            if (DEBUG) {
                this.handleException("Failed to submit plugin statistics", e);
            }
            this.handleSubmitException(e);
        }
    }

    protected abstract void log(String var1);

    protected abstract void handleException(String var1, Exception var2);

    protected abstract void handleSubmitException(Exception var1);

    protected abstract void cancel();

    public final boolean stop() {
        if (this.running) {
            this.running = false;
            this.cancel();
            return true;
        }
        return false;
    }

    protected abstract String getPluginName();

    protected abstract String getPluginVersion();

    protected abstract String getServerVersion();

    protected abstract int getOnlinePlayerCount();

    protected abstract boolean isOnlineMode();

    private void post(String guid, boolean ping) throws IOException {
        String response;
        String pluginName = this.getPluginName();
        String pluginVersion = this.getPluginVersion();
        String serverVersion = this.getServerVersion();
        int online = this.getOnlinePlayerCount();
        boolean onlineMode = this.isOnlineMode();
        StringWriter writer = new StringWriter();
        try (Object json = new JsonWriter((Writer)writer);){
            json.beginObject();
            json.name("guid").value(guid);
            json.name("plugin_version").value(pluginVersion);
            json.name("server_version").value(serverVersion);
            json.name("players_online").value((long)online);
            json.name("auth_mode").value(onlineMode);
            json.name("osname").value(System.getProperty("os.name"));
            String osArch = System.getProperty("os.arch");
            json.name("osarch").value(osArch.equals("amd64") ? "x86_64" : osArch);
            json.name("osversion").value(System.getProperty("os.version"));
            json.name("cores").value((long)Runtime.getRuntime().availableProcessors());
            json.name("java_version").value(System.getProperty("java.version"));
            if (ping) {
                json.name("ping").value(true);
            }
            json.endObject();
        }
        json = writer.toString();
        if (DEBUG) {
            this.log("Generated json request: " + (String)json);
        }
        byte[] data = ((String)json).getBytes(StandardCharsets.UTF_8);
        byte[] gzip = null;
        try {
            gzip = StatsLite.gzip(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        URL url = new URL(REPORT_URL + URLEncoder.encode(pluginName, "UTF-8"));
        URLConnection con = url.openConnection();
        con.addRequestProperty("User-Agent", "MCStats/7");
        con.addRequestProperty("Content-Type", "application/json");
        if (gzip != null) {
            con.addRequestProperty("Content-Encoding", "gzip");
            data = gzip;
        }
        con.addRequestProperty("Content-Length", Integer.toString(data.length));
        con.addRequestProperty("Accept", "application/json");
        con.addRequestProperty("Connection", "close");
        con.setDoOutput(true);
        if (DEBUG) {
            this.log("Sending " + data.length + " bytes to " + url);
        }
        try (OutputStream out = con.getOutputStream();){
            out.write(data);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));){
            response = reader.readLine();
        }
        if (DEBUG) {
            HttpURLConnection http = (HttpURLConnection)con;
            this.log("Server replied with '" + response + "' (" + http.getResponseCode() + " - " + http.getResponseMessage() + ')');
        }
        if (response == null || response.startsWith("ERR") || response.startsWith("7")) {
            if (response == null) {
                response = "null";
            } else if (response.startsWith("7")) {
                response = response.substring(response.startsWith("7,") ? 2 : 1);
            }
            throw new IOException(response);
        }
    }

    private static byte[] gzip(byte[] data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream gout = new GZIPOutputStream(out);){
            gout.write(data);
        }
        return out.toByteArray();
    }

    public static interface ConfigProvider {
        public void reload() throws IOException;

        public boolean isOptOut();

        public String getUniqueId();
    }
}

