/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bungee.listeners;

import de.themoep.resourcepacksplugin.bungee.BungeeResourcepacks;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class ServerSwitchListener
implements Listener {
    BungeeResourcepacks plugin;

    public ServerSwitchListener(BungeeResourcepacks plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onServerSwitch(ServerSwitchEvent event) {
        if (this.plugin.isEnabled()) {
            final UUID playerId = event.getPlayer().getUniqueId();
            this.plugin.unsetBackend(playerId);
            ResourcePack pack = this.plugin.getUserManager().getUserPack(playerId);
            this.plugin.sendPackInfo(event.getPlayer(), pack);
            this.plugin.getProxy().getScheduler().schedule((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    ServerSwitchListener.this.calculatePack(playerId);
                }
            }, 1L, TimeUnit.SECONDS);
        }
    }

    private void calculatePack(UUID playerId) {
        ProxiedPlayer player;
        if (!this.plugin.hasBackend(playerId) && this.plugin.isAuthenticated(playerId) && (player = this.plugin.getProxy().getPlayer(playerId)) != null) {
            String serverName = "";
            if (player.getServer() != null) {
                serverName = player.getServer().getInfo().getName();
            }
            this.plugin.getPackManager().applyPack(playerId, serverName);
        }
    }
}

