/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bungee.packets;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import de.themoep.resourcepacksplugin.bungee.BungeeResourcepacks;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.connection.DownstreamBridge;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;

public class ResourcePackSendPacket
extends DefinedPacket {
    private String url;
    private String hash;

    public ResourcePackSendPacket() {
    }

    @ConstructorProperties(value={"url", "hash"})
    public ResourcePackSendPacket(String url, String hash) {
        this.url = url;
        this.hash = hash != null ? hash.toLowerCase() : Hashing.sha1().hashString((CharSequence)url, Charsets.UTF_8).toString().toLowerCase();
    }

    public void handle(AbstractPacketHandler handler) throws Exception {
        if (handler instanceof DownstreamBridge) {
            DownstreamBridge bridge = (DownstreamBridge)handler;
            try {
                Field con = bridge.getClass().getDeclaredField("con");
                con.setAccessible(true);
                try {
                    UserConnection usercon = (UserConnection)con.get(bridge);
                    this.relayPacket(usercon, new PacketWrapper((DefinedPacket)this, Unpooled.copiedBuffer((ByteBuffer)ByteBuffer.allocate(Integer.toString(this.getUrl().length()).length()))));
                }
                catch (IllegalAccessException e) {
                    BungeeResourcepacks.getInstance().getLogger().log(Level.WARNING, "Sorry but you are not allowed to do this.");
                    e.printStackTrace();
                }
            }
            catch (NoSuchFieldException e) {
                BungeeResourcepacks.getInstance().getLogger().log(Level.SEVERE, "Error while trying to get the UserConnection field from the DownstreamBridge object. Is the plugin up to date?");
            }
        } else {
            throw new UnsupportedOperationException("Only players can receive ResourcePackSend packets!");
        }
    }

    public void relayPacket(UserConnection usercon, PacketWrapper packet) throws Exception {
        BungeeResourcepacks plugin = BungeeResourcepacks.getInstance();
        if (plugin.isEnabled()) {
            ResourcePack pack = plugin.getPackManager().getByHash(this.getHash());
            if (pack == null) {
                pack = plugin.getPackManager().getByUrl(this.getUrl());
            }
            if (pack == null) {
                pack = new ResourcePack("backend-" + this.getUrl().substring(this.getUrl().lastIndexOf(47) + 1, this.getUrl().length()).replace(".zip", "").toLowerCase(), this.getUrl(), this.getHash());
                try {
                    plugin.getPackManager().addPack(pack);
                }
                catch (IllegalArgumentException e) {
                    pack = plugin.getPackManager().getByUrl(this.getUrl());
                }
            }
            plugin.setBackend(usercon.getUniqueId());
            plugin.getLogger().log(BungeeResourcepacks.getInstance().getLogLevel(), "Backend mc server send pack " + pack.getName() + " (" + pack.getUrl() + ") to player " + usercon.getName());
            plugin.getUserManager().setUserPack(usercon.getUniqueId(), pack);
        }
        usercon.getPendingConnection().handle(packet);
    }

    public void read(ByteBuf buf) {
        this.url = ResourcePackSendPacket.readString((ByteBuf)buf);
        this.hash = ResourcePackSendPacket.readString((ByteBuf)buf);
    }

    public void write(ByteBuf buf) {
        ResourcePackSendPacket.writeString((String)this.url, (ByteBuf)buf);
        ResourcePackSendPacket.writeString((String)this.hash, (ByteBuf)buf);
    }

    public String getUrl() {
        return this.url;
    }

    public String getHash() {
        return this.hash;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHash(String hash) {
        this.hash = hash != null ? hash.substring(0, 39).toLowerCase() : Hashing.sha1().hashString((CharSequence)this.getUrl(), Charsets.UTF_8).toString().substring(0, 39).toLowerCase();
    }

    public String toString() {
        return "ResourcePackSend(url=" + this.getUrl() + ", hash=" + this.getHash() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResourcePackSendPacket) {
            ResourcePackSendPacket other = (ResourcePackSendPacket)((Object)obj);
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null && other$url == null) {
                return true;
            }
            if (this$url == null || other$url == null) {
                return false;
            }
            if (!this$url.equals(other$url)) {
                return false;
            }
            String this$hash = this.getHash();
            String other$hash = other.getHash();
            if (this$hash == null && other$hash == null) {
                return true;
            }
            if (this$hash == null || other$hash == null) {
                return false;
            }
            return this$hash.equals(other$hash);
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 0 : $url.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 0 : $hash.hashCode());
        return result;
    }
}

