/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core;

import de.themoep.resourcepacksplugin.core.ChatColor;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSelectEvent;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSendEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.xml.bind.DatatypeConverter;

public class PackManager {
    private final ResourcepacksPlugin plugin;
    private Map<String, ResourcePack> packmap = new HashMap<String, ResourcePack>();
    private Map<String, String> hashmap = new HashMap<String, String>();
    private Map<String, String> urlmap = new HashMap<String, String>();
    private ResourcePack empty = null;
    private ResourcePack global = null;
    private List<String> globalSecondary = new ArrayList<String>();
    private Map<String, String> servermap = new HashMap<String, String>();
    private Map<String, List<String>> serversecondarymap = new HashMap<String, List<String>>();

    public PackManager(ResourcepacksPlugin plugin) {
        this.plugin = plugin;
    }

    public ResourcePack addPack(ResourcePack pack) throws IllegalArgumentException {
        ResourcePack byHash = this.getByHash(pack.getHash());
        if (byHash != null && !byHash.getName().equalsIgnoreCase(pack.getName())) {
            throw new IllegalArgumentException("Could not add pack '" + pack.getName() + "'. There is already a pack with the hash '" + pack.getHash() + "' but a different name defined! (" + byHash.getName() + ")");
        }
        ResourcePack byUrl = this.getByUrl(pack.getUrl());
        if (byUrl != null && !byUrl.getName().equalsIgnoreCase(pack.getName())) {
            throw new IllegalArgumentException("Could not add pack '" + pack.getName() + "'. There is already a pack with the url '" + pack.getUrl() + "' but a different name defined! (" + byUrl.getName() + ")");
        }
        this.hashmap.put(pack.getHash(), pack.getName().toLowerCase());
        this.urlmap.put(pack.getUrl(), pack.getName().toLowerCase());
        return this.packmap.put(pack.getName().toLowerCase(), pack);
    }

    public ResourcePack getByName(String name) {
        return this.packmap.get(name.toLowerCase());
    }

    public ResourcePack getByHash(String hash) {
        String name = this.hashmap.get(hash);
        return name == null ? null : this.getByName(name);
    }

    public ResourcePack getByUrl(String url) {
        String name = this.urlmap.get(url);
        return name == null ? null : this.getByName(name);
    }

    public ResourcePack setEmptyPack(ResourcePack pack) {
        ResourcePack rp = this.getEmptyPack();
        this.empty = pack;
        return rp;
    }

    public ResourcePack setEmptyPack(String packname) {
        return this.setEmptyPack(this.getByName(packname));
    }

    public ResourcePack getEmptyPack() {
        return this.empty;
    }

    public ResourcePack setGlobalPack(ResourcePack pack) {
        ResourcePack rp = this.getGlobalPack();
        this.global = pack;
        return rp;
    }

    public ResourcePack setGlobalPack(String packname) {
        return this.setGlobalPack(this.getByName(packname));
    }

    public ResourcePack getGlobalPack() {
        return this.global;
    }

    public boolean addGlobalSecondary(ResourcePack pack) {
        return this.addGlobalSecondary(pack.getName());
    }

    public boolean addGlobalSecondary(String packname) {
        return !this.isGlobalSecondary(packname) && this.getGlobalSecondary().add(packname.toLowerCase());
    }

    public boolean isGlobalSecondary(ResourcePack pack) {
        return pack != null && this.isGlobalSecondary(pack.getName());
    }

    public boolean isGlobalSecondary(String packname) {
        return this.getGlobalSecondary().contains(packname.toLowerCase());
    }

    public List<String> getGlobalSecondary() {
        return this.globalSecondary;
    }

    public ResourcePack getServerPack(String server) {
        String name = this.servermap.get(server.toLowerCase());
        return name == null ? null : this.getByName(name);
    }

    @Deprecated
    public ResourcePack getUserPack(UUID playerid) {
        return this.plugin.getUserManager().getUserPack(playerid);
    }

    @Deprecated
    public ResourcePack setUserPack(UUID playerid, ResourcePack pack) {
        return this.plugin.getUserManager().setUserPack(playerid, pack);
    }

    @Deprecated
    public ResourcePack clearUserPack(UUID playerid) {
        return this.plugin.getUserManager().clearUserPack(playerid);
    }

    public void addServer(String server, ResourcePack pack) {
        pack.addServer(server);
        this.servermap.put(server.toLowerCase(), pack.getName().toLowerCase());
    }

    public boolean removeServer(String server) {
        String packname = this.servermap.remove(server.toLowerCase());
        if (packname != null && this.packmap.containsKey(packname)) {
            return this.packmap.get(packname).removeServer(server);
        }
        return false;
    }

    public boolean addServerSecondary(String server, ResourcePack pack) {
        return this.addServerSecondary(server, pack.getName());
    }

    public boolean addServerSecondary(String server, String packname) {
        if (this.isServerSecondary(server, packname)) {
            return false;
        }
        List<String> serverSecondaries = this.getServerSecondary(server);
        serverSecondaries.add(packname.toLowerCase());
        this.serversecondarymap.put(server.toLowerCase(), serverSecondaries);
        return true;
    }

    public boolean isServerSecondary(String server, ResourcePack pack) {
        return pack != null && this.isServerSecondary(server, pack.getName());
    }

    public boolean isServerSecondary(String server, String packname) {
        return this.getServerSecondary(server).contains(packname.toLowerCase());
    }

    public List<String> getServerSecondary(String server) {
        return this.serversecondarymap.containsKey(server.toLowerCase()) ? this.serversecondarymap.get(server.toLowerCase()) : new ArrayList<String>();
    }

    public void setPack(UUID playerId, ResourcePack pack) {
        ResourcePack prev = this.plugin.getUserManager().getUserPack(playerId);
        if (pack != null && pack.equals(prev)) {
            return;
        }
        IResourcePackSendEvent sendEvent = this.plugin.callPackSendEvent(playerId, pack);
        if (sendEvent.isCancelled()) {
            this.plugin.getLogger().log(this.plugin.getLogLevel(), "Pack send event for " + playerId + " was cancelled!");
            return;
        }
        pack = sendEvent.getPack();
        if (pack == null && prev != null && !prev.equals(this.getEmptyPack())) {
            pack = this.getEmptyPack();
        }
        if (pack != null && !pack.equals(prev)) {
            this.plugin.getUserManager().setUserPack(playerId, pack);
            this.plugin.sendPack(playerId, pack);
        }
    }

    public void applyPack(UUID playerId, String serverName) {
        ResourcePack pack = this.getApplicablePack(playerId, serverName);
        this.setPack(playerId, pack);
    }

    public ResourcePack getApplicablePack(UUID playerId, String serverName) {
        ResourcePack secondaryPack;
        ResourcePack prev = this.plugin.getUserManager().getUserPack(playerId);
        ResourcePack pack = null;
        IResourcePackSelectEvent.Status status = IResourcePackSelectEvent.Status.UNKNOWN;
        if (this.isGlobalSecondary(prev) && this.checkPack(playerId, prev, IResourcePackSelectEvent.Status.SUCCESS) == IResourcePackSelectEvent.Status.SUCCESS) {
            return prev;
        }
        if (serverName != null && !serverName.isEmpty()) {
            if (this.isServerSecondary(serverName, prev) && this.checkPack(playerId, prev, IResourcePackSelectEvent.Status.SUCCESS) == IResourcePackSelectEvent.Status.SUCCESS) {
                return prev;
            }
            ResourcePack serverPack = this.getServerPack(serverName);
            status = this.checkPack(playerId, serverPack, status);
            if (status == IResourcePackSelectEvent.Status.SUCCESS) {
                pack = serverPack;
            } else if (prev != null || serverPack != null) {
                List<String> serverSecondary = this.getServerSecondary(serverName);
                for (String secondaryName : serverSecondary) {
                    secondaryPack = this.getByName(secondaryName);
                    status = this.checkPack(playerId, secondaryPack, status);
                    if (status != IResourcePackSelectEvent.Status.SUCCESS) continue;
                    pack = secondaryPack;
                    break;
                }
            }
        }
        if (pack == null) {
            ResourcePack globalPack = this.getGlobalPack();
            status = this.checkPack(playerId, globalPack, status);
            if (status == IResourcePackSelectEvent.Status.SUCCESS) {
                pack = globalPack;
            } else if (prev != null || globalPack != null) {
                List<String> globalSecondary = this.getGlobalSecondary();
                for (String secondaryName : globalSecondary) {
                    secondaryPack = this.getByName(secondaryName);
                    status = this.checkPack(playerId, secondaryPack, status);
                    if (status != IResourcePackSelectEvent.Status.SUCCESS) continue;
                    pack = secondaryPack;
                    break;
                }
            }
        }
        if (pack != null) {
            status = IResourcePackSelectEvent.Status.SUCCESS;
        }
        IResourcePackSelectEvent selectEvent = this.plugin.callPackSelectEvent(playerId, pack, status);
        return selectEvent.getPack();
    }

    private IResourcePackSelectEvent.Status checkPack(UUID playerId, ResourcePack pack, IResourcePackSelectEvent.Status status) {
        boolean hasPermission;
        if (pack == null) {
            return status;
        }
        boolean rightFormat = pack.getFormat() <= this.plugin.getPlayerPackFormat(playerId);
        boolean bl = hasPermission = !pack.isRestricted() || this.plugin.checkPermission(playerId, pack.getPermission());
        if (rightFormat && hasPermission) {
            return IResourcePackSelectEvent.Status.SUCCESS;
        }
        if (status != IResourcePackSelectEvent.Status.NO_PERM_AND_WRONG_VERSION) {
            if (!rightFormat) {
                status = !hasPermission || status == IResourcePackSelectEvent.Status.NO_PERMISSION ? IResourcePackSelectEvent.Status.NO_PERM_AND_WRONG_VERSION : IResourcePackSelectEvent.Status.WRONG_VERSION;
            }
            if (!hasPermission) {
                status = !rightFormat || status == IResourcePackSelectEvent.Status.WRONG_VERSION ? IResourcePackSelectEvent.Status.NO_PERM_AND_WRONG_VERSION : IResourcePackSelectEvent.Status.NO_PERMISSION;
            }
        }
        return status;
    }

    public List<ResourcePack> getPacks() {
        return new ArrayList<ResourcePack>(this.packmap.values());
    }

    public void generateHashes(final ResourcepacksPlayer sender) {
        this.plugin.runAsync(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PackManager.this.plugin.sendMessage(sender, (Object)((Object)ChatColor.YELLOW) + "Generating hashes...");
                int changed = 0;
                for (ResourcePack pack : PackManager.this.getPacks()) {
                    if (pack.getName().startsWith("backend-")) continue;
                    InputStream in = null;
                    try {
                        Path target = new File(PackManager.this.plugin.getDataFolder(), pack.getName() + "-downloaded.zip").toPath();
                        URL url = new URL(pack.getUrl());
                        PackManager.this.plugin.sendMessage(sender, (Object)((Object)ChatColor.YELLOW) + "Downloading " + (Object)((Object)ChatColor.WHITE) + pack.getName() + "...");
                        in = url.openStream();
                        Files.copy(in, target, StandardCopyOption.REPLACE_EXISTING);
                        MessageDigest md = MessageDigest.getInstance("SHA-1");
                        md.update(Files.readAllBytes(target));
                        String sha1 = DatatypeConverter.printHexBinary((byte[])md.digest()).toLowerCase();
                        PackManager.this.plugin.sendMessage(sender, (Object)((Object)ChatColor.YELLOW) + "SHA 1 hash of " + (Object)((Object)ChatColor.WHITE) + pack.getName() + (Object)((Object)ChatColor.YELLOW) + ": " + (Object)((Object)ChatColor.WHITE) + sha1);
                        if (!pack.getHash().equalsIgnoreCase(sha1)) {
                            PackManager.this.hashmap.remove(pack.getHash());
                            pack.setHash(sha1);
                            PackManager.this.hashmap.put(pack.getHash(), pack.getName().toLowerCase());
                            ++changed;
                        }
                        Files.deleteIfExists(target);
                    }
                    catch (MalformedURLException e) {
                        PackManager.this.plugin.sendMessage(sender, Level.SEVERE, (Object)((Object)ChatColor.YELLOW) + pack.getUrl() + (Object)((Object)ChatColor.RED) + " is not a valid url!");
                    }
                    catch (IOException e) {
                        PackManager.this.plugin.sendMessage(sender, Level.SEVERE, (Object)((Object)ChatColor.RED) + "Could not load " + pack.getName() + "! " + e.getMessage());
                    }
                    catch (NoSuchAlgorithmException e) {
                        PackManager.this.plugin.sendMessage(sender, Level.SEVERE, (Object)((Object)ChatColor.RED) + "Could not find SHA-1?");
                        e.printStackTrace();
                        break;
                    }
                    finally {
                        if (in == null) continue;
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            PackManager.this.plugin.sendMessage(sender, Level.SEVERE, (Object)((Object)ChatColor.RED) + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                }
                if (changed > 0) {
                    PackManager.this.plugin.sendMessage(sender, (Object)((Object)ChatColor.GREEN) + "Hashes of " + changed + " packs changed! Saving to config.");
                    PackManager.this.plugin.saveConfigChanges();
                } else {
                    PackManager.this.plugin.sendMessage(sender, (Object)((Object)ChatColor.GREEN) + "No hash changed!");
                }
            }
        });
    }

    public int getPackFormat(int version) {
        if (version < 0) {
            return -1;
        }
        if (version < 47) {
            return 0;
        }
        if (version < 49) {
            return 1;
        }
        if (version < 210) {
            return 2;
        }
        return 3;
    }
}

