/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core;

import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class UserManager {
    private final ResourcepacksPlugin plugin;
    private final Map<UUID, String> userPackMap = new ConcurrentHashMap<UUID, String>();

    public UserManager(ResourcepacksPlugin plugin) {
        this.plugin = plugin;
    }

    public ResourcePack getUserPack(UUID playerid) {
        String name = this.userPackMap.get(playerid);
        return name == null ? null : this.plugin.getPackManager().getByName(name);
    }

    public ResourcePack setUserPack(UUID playerid, ResourcePack pack) {
        String previous = this.userPackMap.put(playerid, pack.getName());
        return previous == null ? null : this.plugin.getPackManager().getByName(previous);
    }

    public ResourcePack clearUserPack(UUID playerid) {
        String previous = this.userPackMap.remove(playerid);
        return previous == null ? null : this.plugin.getPackManager().getByName(previous);
    }
}

