/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core.commands;

import com.google.common.collect.ImmutableMap;
import de.themoep.resourcepacksplugin.core.ChatColor;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import de.themoep.resourcepacksplugin.core.commands.PluginCommandExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UsePackCommandExecutor
extends PluginCommandExecutor {
    public UsePackCommandExecutor(ResourcepacksPlugin plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(ResourcepacksPlayer sender, String[] args) {
        if (args.length > 0) {
            ResourcePack pack = this.plugin.getPackManager().getByName(args[0]);
            if (pack != null) {
                if (this.plugin.checkPermission(sender, pack.getPermission())) {
                    ResourcePack prev;
                    ResourcepacksPlayer player = null;
                    if (args.length > 1 && this.plugin.checkPermission(sender, this.plugin.getName().toLowerCase() + ".command.usepack.others")) {
                        player = this.plugin.getPlayer(args[1]);
                        if (player == null) {
                            this.plugin.sendMessage(sender, (Object)((Object)ChatColor.RED) + "The player " + args[1] + " is not online!");
                            return true;
                        }
                    } else if (sender != null) {
                        player = sender;
                    } else {
                        this.plugin.getLogger().warning("You have to specify a player if you want to run this command from the console! /usepack <packname> <playername>");
                        return true;
                    }
                    if (!pack.equals(prev = this.plugin.getUserManager().getUserPack(player.getUniqueId()))) {
                        this.plugin.getPackManager().setPack(player.getUniqueId(), pack);
                        if (!player.equals(sender)) {
                            this.plugin.sendMessage(sender, args[1] + " now uses the pack '" + pack.getName() + "'!");
                        }
                        this.plugin.sendMessage(player, (Object)((Object)ChatColor.GREEN) + this.plugin.getMessage("usepack", (Map<String, String>)ImmutableMap.of((Object)"pack", (Object)pack.getName())));
                        String senderName = sender != null ? sender.getName() : "CONSOLE";
                        this.plugin.getLogger().log(this.plugin.getLogLevel(), senderName + " set the pack of " + player.getName() + " to '" + pack.getName() + "'!");
                    } else {
                        this.plugin.sendMessage(sender, (Object)((Object)ChatColor.RED) + player.getName() + " already uses the pack '" + pack.getName() + "'!");
                    }
                } else {
                    this.plugin.sendMessage(sender, (Object)((Object)ChatColor.RED) + "You don't have the permission " + pack.getPermission() + " to set the pack '" + pack.getName() + "'!");
                }
            } else {
                this.plugin.sendMessage(sender, (Object)((Object)ChatColor.RED) + "Error: There is no pack with the name '" + args[0] + "'!");
            }
        } else {
            this.plugin.sendMessage(sender, (Object)((Object)ChatColor.GREEN) + this.plugin.getMessage("packlisthead"));
            List<ResourcePack> packs = this.plugin.getPackManager().getPacks();
            if (packs.size() > 0) {
                ResourcePack userPack = this.plugin.getUserManager().getUserPack(sender.getUniqueId());
                ArrayList<ResourcePack> applicablePacks = new ArrayList<ResourcePack>();
                for (ResourcePack pack : packs) {
                    if (pack.getFormat() > this.plugin.getPlayerPackFormat(sender.getUniqueId()) || !this.plugin.checkPermission(sender, pack.getPermission())) continue;
                    applicablePacks.add(pack);
                }
                if (applicablePacks.size() > 0) {
                    for (ResourcePack pack : applicablePacks) {
                        String msg = pack.getName();
                        msg = userPack != null && userPack.equals(pack) ? ">" + msg : " " + msg;
                        if (pack.getFormat() > 0) {
                            msg = msg + (Object)((Object)ChatColor.GRAY) + " (Format: " + pack.getFormat() + ")";
                        }
                        this.plugin.sendMessage(sender, (Object)((Object)ChatColor.YELLOW) + msg);
                    }
                    return false;
                }
            }
            this.plugin.sendMessage(sender, (Object)((Object)ChatColor.RED) + " " + this.plugin.getMessage("nopacks"));
        }
        return true;
    }
}

