/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bungee.libs.lang.bungee;

import de.themoep.resourcepacksplugin.bungee.libs.lang.LangLogger;
import de.themoep.resourcepacksplugin.bungee.libs.lang.LanguageManagerCore;
import de.themoep.resourcepacksplugin.bungee.libs.lang.bungee.BungeeLanguageConfig;
import java.io.File;
import java.util.logging.Level;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;

public class LanguageManager
extends LanguageManagerCore<CommandSender, Configuration> {
    private final Plugin plugin;

    public LanguageManager(Plugin plugin, String defaultLocale, BungeeLanguageConfig ... configs) {
        this(plugin, "languages", defaultLocale, configs);
    }

    public LanguageManager(Plugin plugin, String defaultLocale, boolean saveFiles, BungeeLanguageConfig ... configs) {
        this(plugin, "languages", "languages", defaultLocale, saveFiles, configs);
    }

    public LanguageManager(Plugin plugin, String folder, String defaultLocale, BungeeLanguageConfig ... configs) {
        this(plugin, folder, folder, defaultLocale, configs);
    }

    public LanguageManager(Plugin plugin, String resourceFolder, String folder, String defaultLocale, BungeeLanguageConfig ... configs) {
        this(plugin, resourceFolder, folder, defaultLocale, true, configs);
    }

    public LanguageManager(Plugin plugin, String resourceFolder, String folder, String defaultLocale, boolean saveFiles, BungeeLanguageConfig ... configs) {
        super(defaultLocale, resourceFolder, new File(plugin.getDataFolder(), folder), (S sender) -> {
            if (sender instanceof ProxiedPlayer && ((ProxiedPlayer)sender).getLocale() != null) {
                return ((ProxiedPlayer)sender).getLocale().getLanguage().replace('-', '_');
            }
            return null;
        }, "lang.", ".yml", saveFiles, configs);
        this.plugin = plugin;
        this.loadConfigs();
    }

    @Override
    public void loadConfigs() {
        this.loadConfigs(this.plugin.getClass(), new LangLogger(){

            @Override
            public void log(Level level, String message) {
                LanguageManager.this.plugin.getLogger().log(level, message);
            }

            @Override
            public void log(Level level, String message, Throwable e) {
                LanguageManager.this.plugin.getLogger().log(level, message, e);
            }
        }, locale -> new BungeeLanguageConfig(this.plugin, this.getResourceFolder(), new File(this.getFolder(), this.filePrefix + locale + this.fileSuffix), (String)locale, this.saveFiles));
    }
}

