/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bungee.packets;

import de.themoep.resourcepacksplugin.bungee.BungeeResourcepacks;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.connection.DownstreamBridge;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.ProtocolConstants;

public class ResourcePackRemovePacket
extends DefinedPacket {
    private Optional<UUID> uuid = Optional.empty();
    private static Field conField = null;

    public ResourcePackRemovePacket() {
    }

    @ConstructorProperties(value={"uuid"})
    public ResourcePackRemovePacket(UUID uuid) {
        this.uuid = Optional.of(uuid);
    }

    public void handle(AbstractPacketHandler handler) throws Exception {
        if (handler instanceof DownstreamBridge) {
            if (conField != null) {
                DownstreamBridge bridge = (DownstreamBridge)handler;
                try {
                    UserConnection userConnection = (UserConnection)conField.get(bridge);
                    this.updatePlayer(userConnection);
                    PacketWrapper packetWrapper = new PacketWrapper((DefinedPacket)this, Unpooled.copiedBuffer((ByteBuffer)ByteBuffer.allocate(Short.MAX_VALUE)), userConnection.getCh().getEncodeProtocol());
                    userConnection.getPendingConnection().handle(packetWrapper);
                }
                catch (IllegalAccessException e) {
                    BungeeResourcepacks.getInstance().getLogger().log(Level.WARNING, "Sorry but you are not allowed to do this.", e);
                }
            }
        } else {
            BungeeResourcepacks.getInstance().logDebug("Sending ResourcePackSend packets to " + handler.getClass().getName() + " is not properly supported by this plugin! (Only players) Trying to handle anyways...");
            if (handler instanceof PacketHandler) {
                ((PacketHandler)handler).handle(new PacketWrapper((DefinedPacket)this, Unpooled.copiedBuffer((ByteBuffer)ByteBuffer.allocate(Short.MAX_VALUE)), Protocol.GAME));
            } else if (BungeeResourcepacks.getInstance().getLogLevel().intValue() >= Level.INFO.intValue()) {
                new UnsupportedOperationException("Unsupported handler type " + handler.getClass().getName()).fillInStackTrace().printStackTrace();
            }
        }
    }

    private void updatePlayer(UserConnection usercon) {
        BungeeResourcepacks plugin = BungeeResourcepacks.getInstance();
        if (plugin.isEnabled()) {
            if (this.uuid.isPresent()) {
                ResourcePack pack = plugin.getPackManager().getByUuid(this.uuid.get());
                if (pack != null) {
                    plugin.getUserManager().removeUserPack(usercon.getUniqueId(), pack);
                    plugin.logDebug("Backend mc server removed pack " + pack.getName() + " (" + pack.getUrl() + ") from player " + usercon.getName());
                } else {
                    plugin.logDebug("Backend mc server removed pack " + this.uuid.get() + " that we don't know about from player " + usercon.getName());
                }
            } else {
                plugin.getUserManager().clearUserPacks(usercon.getUniqueId());
            }
        }
    }

    public void read(ByteBuf buf) {
        boolean hasUuid = buf.readBoolean();
        if (hasUuid) {
            this.uuid = Optional.of(ResourcePackRemovePacket.readUUID((ByteBuf)buf));
        }
    }

    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.read(buf);
    }

    public void write(ByteBuf buf) {
        buf.writeBoolean(this.uuid.isPresent());
        this.uuid.ifPresent(u -> ResourcePackRemovePacket.writeUUID((UUID)u, (ByteBuf)buf));
    }

    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.write(buf);
    }

    public UUID getUuid() {
        return this.uuid.orElse(null);
    }

    public String toString() {
        return "ResourcePackRemovePacket{uuid=" + this.uuid + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ResourcePackRemovePacket that = (ResourcePackRemovePacket)((Object)o);
        return Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    static {
        try {
            conField = DownstreamBridge.class.getDeclaredField("con");
            conField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            BungeeResourcepacks.getInstance().getLogger().log(Level.SEVERE, "Error while trying to get the UserConnection field from the DownstreamBridge object. Is the plugin up to date?");
        }
    }
}

