/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bungee.libs.lang.bungee;

import de.themoep.resourcepacksplugin.bungee.libs.lang.LanguageConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class BungeeLanguageConfig
extends LanguageConfig<Configuration> {
    protected static final ConfigurationProvider yml = ConfigurationProvider.getProvider(YamlConfiguration.class);
    private final Plugin plugin;

    public BungeeLanguageConfig(Plugin plugin, String resourceFolder, File configFile, String locale) {
        this(plugin, resourceFolder, configFile, locale, true);
    }

    public BungeeLanguageConfig(Plugin plugin, String resourceFolder, File configFile, String locale, boolean saveFile) {
        super(resourceFolder, configFile, locale, saveFile);
        this.plugin = plugin;
        this.saveConfigResource();
        this.loadConfig();
    }

    @Override
    public void loadConfig() {
        if (this.configFile != null && this.configFile.exists()) {
            try {
                this.config = yml.load(this.configFile, (Configuration)this.defaultConfig);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean saveConfigResource() {
        block15: {
            try (InputStream in = this.plugin.getResourceAsStream(this.resourcePath);){
                if (in == null) {
                    if (Boolean.getBoolean("de.themoep.resourcepacksplugin.bungee.libs.lang.debug")) {
                        this.plugin.getLogger().log(Level.WARNING, "No default config '" + this.resourcePath + "' found in " + this.plugin.getFile().getName() + "!");
                    }
                    boolean bl = false;
                    return bl;
                }
                this.defaultConfig = this.config = yml.load(in);
                if (!this.saveFile || this.configFile.exists()) break block15;
                File parent = this.configFile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                try {
                    yml.save((Configuration)this.config, this.configFile);
                    boolean bl = true;
                    return bl;
                }
                catch (IOException ex) {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not save " + this.configFile.getName() + " to " + this.configFile, ex);
                }
            }
            catch (IOException ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not load default config from " + this.resourcePath, ex);
            }
        }
        return false;
    }

    @Override
    public boolean contains(String key) {
        return this.contains(key, false);
    }

    @Override
    public boolean contains(String key, boolean checkDefault) {
        return ((Configuration)this.config).contains(key) || checkDefault && this.defaultConfig != null && ((Configuration)this.defaultConfig).contains(key);
    }

    @Override
    public String get(String key) {
        List stringList;
        Object o = ((Configuration)this.config).get(key);
        String string = null;
        if (o instanceof String) {
            string = (String)o;
        } else if (o instanceof List && (stringList = (List)o) != null) {
            string = String.join((CharSequence)"\n", stringList);
        }
        if (string == null) {
            return ChatColor.RED + "Missing language key " + ChatColor.YELLOW + key + ChatColor.RED + " for locale " + ChatColor.YELLOW + this.getLocale();
        }
        return string;
    }

    @Override
    public Configuration getRawConfig() {
        return (Configuration)this.config;
    }
}

