/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bungee.listeners;

import de.themoep.resourcepacksplugin.bungee.BungeeResourcepacks;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;

public class AuthHandler {
    protected final BungeeResourcepacks plugin;

    public AuthHandler(BungeeResourcepacks plugin) {
        this.plugin = plugin;
    }

    public void onAuth(ProxiedPlayer player) {
        if (!this.plugin.isEnabled() || player == null) {
            return;
        }
        this.plugin.setAuthenticated(player.getUniqueId(), true);
        if (!this.plugin.hasBackend(player.getUniqueId()) && this.plugin.getConfig().getBoolean("use-auth-plugin", this.plugin.getConfig().getBoolean("useauth", false))) {
            long sendDelay;
            String serverName = "";
            if (player.getServer() != null) {
                serverName = player.getServer().getInfo().getName();
            }
            if ((sendDelay = this.plugin.getPackManager().getAssignment(serverName).getSendDelay()) < 0L) {
                sendDelay = this.plugin.getPackManager().getGlobalAssignment().getSendDelay();
            }
            this.plugin.logDebug(player.getName() + " authenticated on the backend server " + serverName + "! Sending pack in " + sendDelay + " ticks...");
            ResourcepacksPlayer rpPlayer = this.plugin.getPlayer(player);
            if (sendDelay > 0L) {
                String finalServerName = serverName;
                this.plugin.getProxy().getScheduler().schedule((Plugin)this.plugin, () -> this.plugin.getPackManager().applyPack(rpPlayer, finalServerName), sendDelay * 20L, TimeUnit.MILLISECONDS);
            } else {
                this.plugin.getPackManager().applyPack(rpPlayer, serverName);
            }
        }
    }
}

