/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bungee.listeners;

import de.themoep.resourcepacksplugin.bungee.BungeeResourcepacks;
import de.themoep.resourcepacksplugin.bungee.FileConfiguration;
import de.themoep.resourcepacksplugin.bungee.listeners.AuthHandler;
import de.themoep.resourcepacksplugin.core.SubChannelHandler;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.Level;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class PluginMessageListener
extends SubChannelHandler<Server>
implements Listener {
    private final BungeeResourcepacks plugin;
    private FileConfiguration keyConfig;
    private final AuthHandler authHandler;

    public PluginMessageListener(BungeeResourcepacks plugin) {
        super(plugin);
        this.plugin = plugin;
        File keyFile = new File(plugin.getDataFolder(), "key.yml");
        try {
            this.keyConfig = new FileConfiguration((Plugin)plugin, keyFile);
        }
        catch (IOException e) {
            plugin.log(Level.SEVERE, "Unable to create key.yml! " + e.getMessage());
        }
        this.authHandler = new AuthHandler(plugin);
        this.registerSubChannel("authLogin", (s, in) -> {
            String playerName = in.readUTF();
            UUID playerId = UUID.fromString(in.readUTF());
            ProxiedPlayer player = plugin.getProxy().getPlayer(playerId);
            if (player != null && !plugin.isAuthenticated(playerId)) {
                this.authHandler.onAuth(player);
            }
        });
    }

    @EventHandler
    public void pluginMessageReceived(PluginMessageEvent event) {
        if (!this.plugin.isEnabled() || !event.getTag().equals("rp:plugin")) {
            return;
        }
        event.setCancelled(true);
        if (event.getSender() instanceof Server) {
            this.handleMessage((Server)event.getSender(), event.getData());
        } else {
            this.plugin.logDebug("Received plugin message from " + event.getSender() + " which is not a ServerConnection!");
        }
    }

    @EventHandler(priority=-64)
    public void onServerSwitch(ServerConnectedEvent event) {
        if (this.plugin.isEnabled()) {
            this.sendKey(event.getServer());
        }
    }

    @Override
    protected void sendPluginMessage(Server target, byte[] data) {
        try {
            target.sendData("rp:plugin", data);
        }
        catch (Exception e) {
            this.plugin.log(Level.WARNING, "Failed to send plugin message to server " + target.getInfo().getName() + "! This is most likely because the player connection timed out. " + e.getMessage());
            this.plugin.logDebug("Plugin message sending error:", e);
        }
    }

    @Override
    protected void saveKey(String key) {
        if (this.keyConfig != null) {
            this.keyConfig.set("key", key);
            this.keyConfig.saveConfig();
        }
    }

    @Override
    protected String loadKey() {
        String key = null;
        if (this.keyConfig != null) {
            try {
                if (this.keyConfig.loadConfig()) {
                    key = this.keyConfig.getString("key", null);
                }
            }
            catch (IOException e) {
                this.plugin.log(Level.SEVERE, "Error while loading key.yml! " + e.getMessage());
            }
            if (key == null) {
                key = this.generateKey();
                this.saveKey(key);
            }
        }
        return key;
    }

    @Override
    protected String getTargetType() {
        return "Minecraft server";
    }
}

