/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bungee.listeners;

import de.themoep.resourcepacksplugin.bungee.BungeeResourcepacks;
import de.themoep.resourcepacksplugin.core.MinecraftVersion;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class ServerSwitchListener
implements Listener {
    private final BungeeResourcepacks plugin;

    public ServerSwitchListener(BungeeResourcepacks plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onServerSwitch(ServerSwitchEvent event) {
        if (this.plugin.isEnabled()) {
            UUID playerId = event.getPlayer().getUniqueId();
            this.plugin.unsetBackend(playerId);
            this.plugin.sendPackInfo(playerId);
            if (this.plugin.getPlayerProtocol(playerId) == MinecraftVersion.MINECRAFT_1_20_2.getProtocolNumber()) {
                this.plugin.getUserManager().clearUserPacks(playerId);
            }
            long sendDelay = -1L;
            if (event.getPlayer().getServer() != null) {
                sendDelay = this.plugin.getPackManager().getAssignment(event.getPlayer().getServer().getInfo().getName()).getSendDelay();
            }
            if (sendDelay < 0L) {
                sendDelay = this.plugin.getPackManager().getGlobalAssignment().getSendDelay();
            }
            if (sendDelay > 0L) {
                this.plugin.getProxy().getScheduler().schedule((Plugin)this.plugin, () -> this.calculatePack(playerId), sendDelay * 50L, TimeUnit.MILLISECONDS);
            } else {
                this.calculatePack(playerId);
            }
        }
    }

    private void calculatePack(UUID playerId) {
        if (this.plugin.hasBackend(playerId)) {
            this.plugin.logDebug("Player " + playerId + " has backend pack, not attempting to send a new one.");
            return;
        }
        if (!this.plugin.isAuthenticated(playerId)) {
            this.plugin.logDebug("Player " + playerId + " is not authenticated, not attempting to send a pack yet.");
            return;
        }
        ProxiedPlayer player = this.plugin.getProxy().getPlayer(playerId);
        if (player != null) {
            String serverName = "";
            if (player.getServer() != null) {
                serverName = player.getServer().getInfo().getName();
            }
            this.plugin.getPackManager().applyPack(this.plugin.getPlayer(player), serverName);
        }
    }
}

