/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core;

import de.themoep.resourcepacksplugin.core.ChatColor;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.core.commands.PluginCommandExecutor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PackAssignment {
    private LinkedHashSet<String> packs = new LinkedHashSet();
    private LinkedHashSet<String> optionalPacks = new LinkedHashSet();
    private long sendDelay = -1L;
    private Pattern regex = null;
    private final String name;

    public PackAssignment(String name) {
        this.name = name;
    }

    public PackAssignment(PackAssignment assignment) {
        this(assignment.getName());
        this.packs.addAll(assignment.getPacks());
        this.optionalPacks.addAll(assignment.getOptionalPacks());
        this.sendDelay = assignment.getSendDelay();
        this.regex = assignment.getRegex();
    }

    @Deprecated
    public boolean setPack(ResourcePack pack) {
        if (pack == null) {
            return this.setPack((String)null);
        }
        return this.setPack(pack.getName());
    }

    @Deprecated
    public boolean setPack(String pack) {
        if (pack == null) {
            if (this.packs.isEmpty()) {
                return false;
            }
            this.packs.clear();
            return true;
        }
        if (this.packs.size() == 1 && this.packs.contains(pack.toLowerCase(Locale.ROOT))) {
            return false;
        }
        this.packs.clear();
        this.addPack(pack);
        return true;
    }

    @Deprecated
    public String getPack() {
        return this.packs.stream().findFirst().orElse(null);
    }

    public LinkedHashSet<String> getPacks() {
        return this.packs;
    }

    public boolean isPack(String pack) {
        return this.packs.contains(pack.toLowerCase(Locale.ROOT));
    }

    public boolean isPack(ResourcePack pack) {
        return pack != null && this.isPack(pack.getName());
    }

    public boolean addPack(ResourcePack pack) {
        return this.addPack(pack.getName());
    }

    public boolean addPack(String pack) {
        return this.packs.add(pack.toLowerCase(Locale.ROOT));
    }

    public boolean removePack(ResourcePack pack) {
        return this.removePack(pack.getName());
    }

    public boolean removePack(String pack) {
        return this.packs.remove(pack.toLowerCase(Locale.ROOT));
    }

    public LinkedHashSet<String> getOptionalPacks() {
        return this.optionalPacks;
    }

    public boolean isOptionalPack(String pack) {
        return this.optionalPacks.contains(pack.toLowerCase(Locale.ROOT));
    }

    public boolean isOptionalPack(ResourcePack pack) {
        return pack != null && this.isOptionalPack(pack.getName());
    }

    public boolean addOptionalPack(ResourcePack pack) {
        return this.addOptionalPack(pack.getName());
    }

    public boolean addOptionalPack(String pack) {
        return this.optionalPacks.add(pack.toLowerCase(Locale.ROOT));
    }

    public boolean removeOptionalPack(ResourcePack pack) {
        return this.removeOptionalPack(pack.getName());
    }

    public boolean removeOptionalPack(String pack) {
        return this.optionalPacks.remove(pack.toLowerCase(Locale.ROOT));
    }

    @Deprecated
    public LinkedHashSet<String> getSecondaries() {
        return this.getOptionalPacks();
    }

    @Deprecated
    public boolean isSecondary(String pack) {
        return this.isOptionalPack(pack);
    }

    @Deprecated
    public boolean isSecondary(ResourcePack pack) {
        return this.isOptionalPack(pack);
    }

    @Deprecated
    public boolean addSecondary(ResourcePack pack) {
        return this.addOptionalPack(pack);
    }

    @Deprecated
    public boolean addSecondary(String pack) {
        return this.addOptionalPack(pack);
    }

    @Deprecated
    public boolean removeSecondary(ResourcePack pack) {
        return this.removeOptionalPack(pack);
    }

    @Deprecated
    public boolean removeSecondary(String pack) {
        return this.removeOptionalPack(pack);
    }

    public boolean isEmpty() {
        return this.packs.isEmpty() && this.optionalPacks.isEmpty() && this.sendDelay == -1L;
    }

    public boolean setSendDelay(long sendDelay) {
        if (this.sendDelay != sendDelay) {
            this.sendDelay = sendDelay;
            return true;
        }
        return false;
    }

    public long getSendDelay() {
        return this.sendDelay;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.getClass().getSimpleName()).append("{").append("name=").append(this.getName()).append(", packs=[").append(String.join((CharSequence)", ", this.getPacks())).append("], optional-packs=[").append(String.join((CharSequence)", ", this.getOptionalPacks())).append("], sendDelay=").append(this.getSendDelay());
        if (this.getRegex() != null) {
            s.append(", regex=").append(this.getRegex().toString());
        }
        return s.append("}").toString();
    }

    public boolean setRegex(Pattern regex) {
        if ((this.regex == null || regex == null || !this.regex.toString().equals(regex.toString())) && (this.regex == null && regex != null || this.regex != null && regex == null)) {
            this.regex = regex;
            return true;
        }
        return false;
    }

    public Pattern getRegex() {
        return this.regex;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.packs.size() > 1) {
            map.put("packs", new ArrayList<String>(this.packs));
            map.put("pack", null);
        } else if (this.packs.isEmpty()) {
            map.put("packs", null);
            map.put("pack", null);
        } else {
            map.put("packs", null);
            map.put("pack", this.packs.iterator().next());
        }
        map.put("optional-packs", this.optionalPacks.isEmpty() ? null : new ArrayList<String>(this.optionalPacks));
        map.put("send-delay", this.sendDelay > 0L ? Long.valueOf(this.sendDelay) : null);
        map.put("regex", this.regex != null ? this.regex.toString() : null);
        return map;
    }

    public String[] getReplacements() {
        return new String[]{"name", this.getName(), "pack", this.getPack() != null ? this.getPack() : "none", "packs", this.getPacks().isEmpty() ? "none" : String.join((CharSequence)", ", this.getPacks()), "secondaries", String.join((CharSequence)", ", this.getOptionalPacks()), "optional-packs", String.join((CharSequence)", ", this.getOptionalPacks()), "regex", this.getRegex() != null ? this.getRegex().toString() : "none", "send-delay", String.valueOf(this.getSendDelay())};
    }

    protected String[] getUpdateActions() {
        return new String[]{"info", "addpack", "removepack", "addoptionalpack", "removeoptionalpack", "regex", "senddelay"};
    }

    public boolean update(PluginCommandExecutor command, ResourcepacksPlayer sender, String[] args) {
        boolean save;
        if (args.length == 0) {
            command.sendMessage(sender, "info", this.getReplacements());
            command.sendMessage(sender, "usage", "command", command.getPath(), "name", this.getName(), "usage", command.getUsage() + " " + ChatColor.usage(String.join((CharSequence)" | ", this.getUpdateActions())), "permission", command.getPermission(), "subcommands", String.join((CharSequence)"|", this.getUpdateActions()));
            return true;
        }
        if ("info".equalsIgnoreCase(args[0])) {
            command.sendMessage(sender, "info", this.getReplacements());
            return true;
        }
        if ("addpack".equalsIgnoreCase(args[0])) {
            ResourcePack pack = null;
            if (args.length > 1 && (pack = command.getPlugin().getPackManager().getByName(args[1])) == null) {
                command.sendMessage(sender, "unknown-pack", "input", args[1]);
                return true;
            }
            save = this.addPack(pack);
            command.sendMessage(sender, "updated", "assignment", this.getName(), "type", "added pack", "value", pack.getName());
        } else if ("removepack".equalsIgnoreCase(args[0])) {
            ResourcePack pack = null;
            if (args.length > 1 && (pack = command.getPlugin().getPackManager().getByName(args[1])) == null) {
                command.sendMessage(sender, "unknown-pack", "input", args[1]);
                return true;
            }
            save = this.removePack(pack);
            command.sendMessage(sender, "updated", "assignment", this.getName(), "type", "removed pack", "value", pack.getName());
        } else if ("regex".equalsIgnoreCase(args[0])) {
            Pattern regex = null;
            if (args.length > 1) {
                try {
                    regex = Pattern.compile(args[1]);
                }
                catch (PatternSyntaxException e) {
                    command.sendMessage(sender, "invalid-input", "expected", "regex", "input", args[1] + " (" + e.getMessage() + ")");
                    return true;
                }
            }
            save = this.setRegex(regex);
            command.sendMessage(sender, "updated", "assignment", this.getName(), "type", "regex", "value", regex != null ? regex.toString() : "none");
        } else if ("senddelay".equalsIgnoreCase(args[0])) {
            long sendDelay = -1L;
            if (args.length > 1) {
                try {
                    sendDelay = Long.parseLong(args[1]);
                }
                catch (NumberFormatException e) {
                    command.sendMessage(sender, "invalid-input", "expected", "long", "input", args[1]);
                    return true;
                }
            }
            save = this.setSendDelay(sendDelay);
            command.sendMessage(sender, "updated", "assignment", this.getName(), "type", "send delay", "value", sendDelay > -1L ? String.valueOf(sendDelay) : "none");
        } else {
            if (args.length < 2) {
                return false;
            }
            if ("addoptionalpack".equalsIgnoreCase(args[0]) || "addoptional".equalsIgnoreCase(args[0]) || "addsecondary".equalsIgnoreCase(args[0])) {
                ResourcePack pack = command.getPlugin().getPackManager().getByName(args[1]);
                if (pack == null) {
                    command.sendMessage(sender, "unknown-pack", "input", args[1]);
                    return true;
                }
                save = this.addOptionalPack(pack);
                if (save) {
                    command.sendMessage(sender, "optional-pack.added", "assignment", this.getName(), "pack", pack.getName());
                } else {
                    command.sendMessage(sender, "optional-pack.already-added", "assignment", this.getName(), "pack", pack.getName());
                }
            } else if ("removeoptionalpack".equalsIgnoreCase(args[0]) || "removeoptional".equalsIgnoreCase(args[0]) || "removesecondary".equalsIgnoreCase(args[0])) {
                if (command.getPlugin().getPackManager().getByName(args[1]) == null) {
                    command.sendMessage(sender, "unknown-pack", "input", args[1]);
                }
                if (save = this.removeOptionalPack(args[1])) {
                    command.sendMessage(sender, "optional-pack.removed", "assignment", this.getName(), "pack", args[1]);
                } else {
                    command.sendMessage(sender, "optional-pack.not-added", "assignment", this.getName(), "pack", args[1]);
                }
            } else {
                return false;
            }
        }
        if (save) {
            command.getPlugin().getPackManager().setDirty(true);
        }
        return true;
    }
}

