/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core;

import de.themoep.resourcepacksplugin.core.ResourcePack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackManager {
    private Map<String, ResourcePack> packmap = new HashMap<String, ResourcePack>();
    private Map<String, String> hashmap = new HashMap<String, String>();
    private Map<String, String> urlmap = new HashMap<String, String>();
    private Map<UUID, String> usermap = new ConcurrentHashMap<UUID, String>();
    private ResourcePack empty = null;
    private ResourcePack global = null;
    private List<String> globalSecondary = new ArrayList<String>();
    private Map<String, String> servermap = new HashMap<String, String>();
    private Map<String, List<String>> serversecondarymap = new HashMap<String, List<String>>();

    public ResourcePack addPack(ResourcePack pack) {
        this.hashmap.put(pack.getHash(), pack.getName().toLowerCase());
        this.urlmap.put(pack.getUrl(), pack.getName().toLowerCase());
        return this.packmap.put(pack.getName().toLowerCase(), pack);
    }

    public ResourcePack getByName(String name) {
        return this.packmap.get(name.toLowerCase());
    }

    public ResourcePack getByHash(String hash) {
        String name = this.hashmap.get(hash);
        return name == null ? null : this.getByName(name);
    }

    public ResourcePack getByUrl(String url) {
        String name = this.urlmap.get(url);
        return name == null ? null : this.getByName(name);
    }

    public ResourcePack setEmptyPack(ResourcePack pack) {
        ResourcePack rp = this.getEmptyPack();
        this.empty = pack;
        return rp;
    }

    public ResourcePack setEmptyPack(String packname) {
        return this.setEmptyPack(this.getByName(packname));
    }

    public ResourcePack getEmptyPack() {
        return this.empty;
    }

    public ResourcePack setGlobalPack(ResourcePack pack) {
        ResourcePack rp = this.getGlobalPack();
        this.global = pack;
        return rp;
    }

    public ResourcePack setGlobalPack(String packname) {
        return this.setGlobalPack(this.getByName(packname));
    }

    public ResourcePack getGlobalPack() {
        return this.global;
    }

    public boolean addGlobalSecondary(ResourcePack pack) {
        return this.addGlobalSecondary(pack.getName());
    }

    public boolean addGlobalSecondary(String packname) {
        return !this.isGlobalSecondary(packname) && this.getGlobalSecondary().add(packname.toLowerCase());
    }

    public boolean isGlobalSecondary(ResourcePack pack) {
        return pack != null && this.isGlobalSecondary(pack.getName());
    }

    public boolean isGlobalSecondary(String packname) {
        return this.getGlobalSecondary().contains(packname.toLowerCase());
    }

    public List<String> getGlobalSecondary() {
        return this.globalSecondary;
    }

    public ResourcePack getServerPack(String server) {
        String name = this.servermap.get(server.toLowerCase());
        return name == null ? null : this.getByName(name);
    }

    public ResourcePack getUserPack(UUID playerid) {
        String name = this.usermap.get(playerid);
        return name == null ? null : this.getByName(name);
    }

    public ResourcePack setUserPack(UUID playerid, ResourcePack pack) {
        String previous = this.usermap.put(playerid, pack.getName());
        return previous == null ? null : this.getByName(previous);
    }

    public ResourcePack clearUserPack(UUID playerid) {
        String previous = this.usermap.remove(playerid);
        return previous == null ? null : this.getByName(previous);
    }

    public void addServer(String server, ResourcePack pack) {
        pack.addServer(server);
        this.servermap.put(server.toLowerCase(), pack.getName().toLowerCase());
    }

    public boolean removeServer(String server) {
        String packname = this.servermap.remove(server.toLowerCase());
        if (packname != null && this.packmap.containsKey(packname)) {
            return this.packmap.get(packname).removeServer(server);
        }
        return false;
    }

    public boolean addServerSecondary(String server, ResourcePack pack) {
        return this.addServerSecondary(server, pack.getName());
    }

    public boolean addServerSecondary(String server, String packname) {
        if (this.isServerSecondary(server, packname)) {
            return false;
        }
        List<String> serverSecondaries = this.getServerSecondary(server);
        serverSecondaries.add(packname.toLowerCase());
        this.serversecondarymap.put(server.toLowerCase(), serverSecondaries);
        return true;
    }

    public boolean isServerSecondary(String server, ResourcePack pack) {
        return pack != null && this.isServerSecondary(server, pack.getName());
    }

    public boolean isServerSecondary(String server, String packname) {
        return this.getServerSecondary(server).contains(packname.toLowerCase());
    }

    public List<String> getServerSecondary(String server) {
        return this.serversecondarymap.containsKey(server.toLowerCase()) ? this.serversecondarymap.get(server.toLowerCase()) : new ArrayList<String>();
    }

    public ResourcePack getApplicablePack(UUID playerId, String serverName) {
        ResourcePack prev = this.getUserPack(playerId);
        ResourcePack pack = null;
        if (this.isGlobalSecondary(prev)) {
            return null;
        }
        if (serverName != null && !serverName.isEmpty()) {
            if (this.isServerSecondary(serverName, prev)) {
                return null;
            }
            pack = this.getServerPack(serverName);
        }
        if (pack == null) {
            pack = this.getGlobalPack();
        }
        if (pack == null && prev != null && !prev.equals(this.getEmptyPack())) {
            List<String> globalsecondary;
            List<String> serversecondary;
            if (serverName != null && !serverName.isEmpty() && (serversecondary = this.getServerSecondary(serverName)).size() > 0) {
                pack = this.getByName(serversecondary.get(0));
            }
            if (pack == null && (globalsecondary = this.getGlobalSecondary()).size() > 0) {
                pack = this.getByName(globalsecondary.get(0));
            }
            if (pack == null) {
                pack = this.getEmptyPack();
            }
        }
        if (pack != null && !pack.equals(prev)) {
            return pack;
        }
        return null;
    }
}

