/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.List;

public class ResourcePack {
    private String name;
    private String url;
    private String hash;
    private List<String> servers = new ArrayList<String>();

    public ResourcePack(String name, String url, String hash) {
        this.name = name;
        this.url = url;
        this.hash = hash != null && hash.length() == 40 ? hash : Hashing.sha1().hashString((CharSequence)url, Charsets.UTF_8).toString().substring(0, 39).toLowerCase();
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHash() {
        return this.hash;
    }

    void addServer(String name) {
        if (!this.servers.contains(name.toLowerCase())) {
            this.servers.add(name.toLowerCase());
        }
    }

    boolean removeServer(String server) {
        return this.servers.remove(server.toLowerCase());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourcePack)) {
            return false;
        }
        ResourcePack other = (ResourcePack)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        return !(this$hash == null ? other$hash != null : !this$hash.equals(other$hash));
    }
}

