/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core.commands;

import com.google.common.collect.ImmutableMap;
import de.themoep.resourcepacksplugin.core.ChatColor;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import de.themoep.resourcepacksplugin.core.commands.PluginCommandExecutor;
import java.util.Map;

public class UsePackCommandExecutor
extends PluginCommandExecutor {
    public UsePackCommandExecutor(ResourcepacksPlugin plugin) {
        super(plugin);
    }

    public boolean execute(ResourcepacksPlayer sender, String[] args) {
        if (args.length > 0) {
            ResourcePack pack = this.plugin.getPackManager().getByName(args[0]);
            if (pack != null) {
                if (this.plugin.checkPermission(sender, this.plugin.getName().toLowerCase() + ".pack." + pack.getName().toLowerCase())) {
                    ResourcePack prev;
                    ResourcepacksPlayer player = null;
                    if (args.length > 1 && this.plugin.checkPermission(sender, this.plugin.getName().toLowerCase() + ".command.usepack.others")) {
                        player = this.plugin.getPlayer(args[1]);
                        if (player == null) {
                            this.plugin.sendMessage(sender, (Object)((Object)ChatColor.RED) + "The player " + args[1] + " is not online!");
                            return true;
                        }
                    } else if (sender != null) {
                        player = sender;
                    } else {
                        this.plugin.getLogger().warning("You have to specify a player if you want to run this command from the console! /usepack <packname> <playername>");
                        return true;
                    }
                    if (!pack.equals(prev = this.plugin.getPackManager().getUserPack(player.getUniqueId()))) {
                        this.plugin.setPack(player.getUniqueId(), pack);
                        if (!player.equals(sender)) {
                            this.plugin.sendMessage(sender, args[1] + " now uses the pack '" + pack.getName() + "'!");
                        }
                        this.plugin.sendMessage(player, (Object)((Object)ChatColor.GREEN) + this.plugin.getMessage("usepack", (Map<String, String>)ImmutableMap.of((Object)"pack", (Object)pack.getName())));
                        this.plugin.getLogger().log(this.plugin.getLogLevel(), sender.getName() + " set the pack of " + player.getName() + " to '" + pack.getName() + "'!");
                    } else {
                        this.plugin.sendMessage(sender, (Object)((Object)ChatColor.RED) + player.getName() + " already uses the pack '" + pack.getName() + "'!");
                    }
                } else {
                    this.plugin.sendMessage(sender, (Object)((Object)ChatColor.RED) + "You don't have the permission to set the pack '" + pack.getName() + "'!");
                }
            } else {
                this.plugin.sendMessage(sender, (Object)((Object)ChatColor.RED) + "Error: There is no pack with the name '" + args[0] + "'!");
            }
            return true;
        }
        return false;
    }
}

