/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core;

import de.themoep.resourcepacksplugin.core.ChatColor;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.core.commands.PluginCommandExecutor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;

public class PackAssignment {
    private String pack = null;
    private LinkedHashSet<String> secondaries = new LinkedHashSet();
    private long sendDelay = -1L;
    private Pattern regex = null;
    private final String name;

    public PackAssignment(String name) {
        this.name = name;
    }

    public PackAssignment(PackAssignment assignment) {
        this(assignment.getName());
        this.pack = assignment.getPack();
        this.secondaries = assignment.getSecondaries();
        this.sendDelay = assignment.getSendDelay();
        this.regex = assignment.getRegex();
    }

    public boolean setPack(ResourcePack pack) {
        if (pack == null) {
            return this.setPack((String)null);
        }
        return this.setPack(pack.getName());
    }

    public boolean setPack(String pack) {
        if (this.pack == null && pack != null) {
            this.pack = pack.toLowerCase();
            return true;
        }
        if (this.pack != null && !this.pack.equalsIgnoreCase(pack)) {
            this.pack = pack != null ? pack.toLowerCase() : null;
            return true;
        }
        return false;
    }

    public String getPack() {
        return this.pack;
    }

    public LinkedHashSet<String> getSecondaries() {
        return this.secondaries;
    }

    public boolean isSecondary(String pack) {
        return this.secondaries.contains(pack.toLowerCase());
    }

    public boolean isSecondary(ResourcePack pack) {
        return pack != null && this.isSecondary(pack.getName());
    }

    public boolean addSecondary(ResourcePack pack) {
        return this.addSecondary(pack.getName());
    }

    public boolean addSecondary(String pack) {
        return this.secondaries.add(pack.toLowerCase());
    }

    public boolean removeSecondary(ResourcePack pack) {
        return this.removeSecondary(pack.getName());
    }

    public boolean removeSecondary(String pack) {
        return this.secondaries.remove(pack.toLowerCase());
    }

    public boolean isEmpty() {
        return this.pack == null && this.secondaries.isEmpty() && this.sendDelay == -1L;
    }

    public boolean setSendDelay(long sendDelay) {
        if (this.sendDelay != sendDelay) {
            this.sendDelay = sendDelay;
            return true;
        }
        return false;
    }

    public long getSendDelay() {
        return this.sendDelay;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.getClass().getSimpleName()).append("{").append("name=").append(this.getName()).append(", pack=").append(this.getPack()).append(", secondaries=[").append(this.getSecondaries().stream().collect(Collectors.joining(", "))).append("], sendDelay=").append(this.getSendDelay());
        if (this.getRegex() != null) {
            s.append(", regex=").append(this.getRegex().toString());
        }
        return s.append("}").toString();
    }

    public boolean setRegex(Pattern regex) {
        if ((this.regex == null || regex == null || !this.regex.toString().equals(regex.toString())) && (this.regex == null && regex != null || this.regex != null && regex == null)) {
            this.regex = regex;
            return true;
        }
        return false;
    }

    public Pattern getRegex() {
        return this.regex;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("pack", this.pack);
        map.put("secondary", this.secondaries.isEmpty() ? null : new ArrayList<String>(this.secondaries));
        map.put("send-delay", this.sendDelay > 0L ? Long.valueOf(this.sendDelay) : null);
        map.put("regex", this.regex != null ? this.regex.toString() : null);
        return map;
    }

    public String[] getReplacements() {
        return new String[]{"name", this.getName(), "pack", this.getPack() != null ? this.getPack() : "none", "secondaries", String.join((CharSequence)", ", this.getSecondaries()), "regex", this.getRegex() != null ? this.getRegex().toString() : "none", "send-delay", String.valueOf(this.getSendDelay())};
    }

    protected String[] getUpdateActions() {
        return new String[]{"info", "pack", "addsecondary", "removesecondary", "regex", "senddelay"};
    }

    public boolean update(PluginCommandExecutor command, ResourcepacksPlayer sender, String[] args) {
        boolean save;
        if (args.length == 0) {
            command.sendMessage(sender, "info", this.getReplacements());
            command.sendMessage(sender, "usage", "command", command.getPath(), "name", this.getName(), "usage", command.getUsage() + " " + ChatColor.usage(String.join((CharSequence)" | ", this.getUpdateActions())), "permission", command.getPermission(), "subcommands", String.join((CharSequence)"|", this.getUpdateActions()));
            return true;
        }
        if ("info".equalsIgnoreCase(args[0])) {
            command.sendMessage(sender, "info", this.getReplacements());
            return true;
        }
        if ("pack".equalsIgnoreCase(args[0])) {
            ResourcePack pack = null;
            if (args.length > 1 && (pack = command.getPlugin().getPackManager().getByName(args[1])) == null) {
                command.sendMessage(sender, "unknown-pack", "input", args[1]);
                return true;
            }
            save = this.setPack(pack);
            command.sendMessage(sender, "updated", "assignment", this.getName(), "type", "pack", "value", pack != null ? pack.getName() : "none");
        } else if ("regex".equalsIgnoreCase(args[0])) {
            Pattern regex = null;
            if (args.length > 1) {
                try {
                    regex = Pattern.compile(args[1]);
                }
                catch (PatternSyntaxException e) {
                    command.sendMessage(sender, "invalid-input", "expected", "regex", "input", args[1] + " (" + e.getMessage() + ")");
                    return true;
                }
            }
            save = this.setRegex(regex);
            command.sendMessage(sender, "updated", "assignment", this.getName(), "type", "regex", "value", regex != null ? regex.toString() : "none");
        } else if ("senddelay".equalsIgnoreCase(args[0])) {
            long sendDelay = -1L;
            if (args.length > 1) {
                try {
                    sendDelay = Long.parseLong(args[1]);
                }
                catch (NumberFormatException e) {
                    command.sendMessage(sender, "invalid-input", "expected", "long", "input", args[1]);
                    return true;
                }
            }
            save = this.setSendDelay(sendDelay);
            command.sendMessage(sender, "updated", "assignment", this.getName(), "type", "send delay", "value", sendDelay > -1L ? String.valueOf(sendDelay) : "none");
        } else {
            if (args.length < 2) {
                return false;
            }
            if ("addsecondary".equalsIgnoreCase(args[0])) {
                ResourcePack pack = command.getPlugin().getPackManager().getByName(args[1]);
                if (pack == null) {
                    command.sendMessage(sender, "unknown-pack", "input", args[1]);
                    return true;
                }
                save = this.addSecondary(pack);
                if (save) {
                    command.sendMessage(sender, "secondary.added", "assignment", this.getName(), "pack", pack.getName());
                } else {
                    command.sendMessage(sender, "secondary.already-added", "assignment", this.getName(), "pack", pack.getName());
                }
            } else if ("removesecondary".equalsIgnoreCase(args[0])) {
                if (command.getPlugin().getPackManager().getByName(args[1]) == null) {
                    command.sendMessage(sender, "unknown-pack", "input", args[1]);
                }
                if (save = this.removeSecondary(args[1])) {
                    command.sendMessage(sender, "secondary.removed", "assignment", this.getName(), "pack", args[1]);
                } else {
                    command.sendMessage(sender, "secondary.not-added", "assignment", this.getName(), "pack", args[1]);
                }
            } else {
                return false;
            }
        }
        if (save) {
            command.getPlugin().getPackManager().setDirty(true);
        }
        return true;
    }
}

