/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core;

import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import de.themoep.resourcepacksplugin.core.PackAssignment;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSelectEvent;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSendEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PackManager {
    public static final String EMPTY_IDENTIFIER = "empty";
    private final ResourcepacksPlugin plugin;
    private Map<String, ResourcePack> packNames;
    private Map<String, ResourcePack> packHashes;
    private Map<String, ResourcePack> packUrls;
    private ResourcePack empty = null;
    private PackAssignment global = new PackAssignment("global");
    private Map<String, PackAssignment> literalAssignments;
    private Map<String, PackAssignment> regexAssignments;
    private boolean dirty = false;
    private boolean storedPacksOverride;

    public PackManager(ResourcepacksPlugin plugin) {
        this.plugin = plugin;
    }

    public void init() {
        this.packNames = new LinkedHashMap<String, ResourcePack>();
        this.packHashes = new HashMap<String, ResourcePack>();
        this.packUrls = new HashMap<String, ResourcePack>();
        this.empty = null;
        this.global = new PackAssignment("global");
        this.literalAssignments = new LinkedHashMap<String, PackAssignment>();
        this.regexAssignments = new LinkedHashMap<String, PackAssignment>();
    }

    public ResourcePack addPack(ResourcePack pack) throws IllegalArgumentException {
        ResourcePack byHash = this.getByHash(pack.getHash());
        if (byHash != null && !byHash.getName().equalsIgnoreCase(pack.getName())) {
            throw new IllegalArgumentException("Could not add pack '" + pack.getName() + "'. There is already a pack with the hash '" + pack.getHash() + "' but a different name defined! (" + byHash.getName() + ")");
        }
        ResourcePack byUrl = this.getByUrl(pack.getUrl());
        if (byUrl != null && !byUrl.getName().equalsIgnoreCase(pack.getName())) {
            throw new IllegalArgumentException("Could not add pack '" + pack.getName() + "'. There is already a pack with the url '" + pack.getUrl() + "' but a different name defined! (" + byUrl.getName() + ")");
        }
        this.packHashes.put(pack.getHash(), pack);
        this.packUrls.put(pack.getUrl(), pack);
        return this.packNames.put(pack.getName().toLowerCase(), pack);
    }

    public boolean setPackHash(ResourcePack pack, String hash) {
        if (pack.getHash().equals(hash)) {
            return false;
        }
        this.packHashes.remove(pack.getHash());
        pack.setHash(hash);
        this.packHashes.put(pack.getHash(), pack);
        return true;
    }

    public boolean setPackUrl(ResourcePack pack, String url) {
        if (pack.getUrl().equals(url)) {
            return false;
        }
        this.packUrls.remove(pack.getUrl());
        pack.setUrl(url);
        this.packUrls.put(pack.getUrl(), pack);
        return true;
    }

    public ResourcePack getByName(String name) {
        return name != null ? this.packNames.get(name.toLowerCase()) : null;
    }

    public ResourcePack getByHash(String hash) {
        return this.packHashes.get(hash);
    }

    public ResourcePack getByHash(byte[] hash) {
        return this.packHashes.get(BaseEncoding.base16().lowerCase().encode(hash));
    }

    public ResourcePack getByUrl(String url) {
        return this.packUrls.get(url);
    }

    public ResourcePack setEmptyPack(ResourcePack pack) {
        ResourcePack rp = this.getEmptyPack();
        this.empty = pack;
        return rp;
    }

    public ResourcePack setEmptyPack(String packname) {
        return this.setEmptyPack(this.getByName(packname));
    }

    public ResourcePack getEmptyPack() {
        return this.empty;
    }

    public void setStoredPacksOverride(boolean playerPacksOverride) {
        this.storedPacksOverride = playerPacksOverride;
    }

    public boolean getStoredPacksOverride() {
        return this.storedPacksOverride;
    }

    @Deprecated
    public ResourcePack setGlobalPack(ResourcePack pack) {
        ResourcePack rp = this.getGlobalPack();
        this.getGlobalAssignment().setPack(pack);
        return rp;
    }

    @Deprecated
    public ResourcePack setGlobalPack(String packname) {
        return this.setGlobalPack(this.getByName(packname));
    }

    @Deprecated
    public ResourcePack getGlobalPack() {
        return this.getByName(this.getGlobalAssignment().getPack());
    }

    @Deprecated
    public boolean addGlobalSecondary(ResourcePack pack) {
        return this.getGlobalAssignment().addSecondary(pack);
    }

    @Deprecated
    public boolean addGlobalSecondary(String packname) {
        return this.getGlobalAssignment().addSecondary(packname);
    }

    @Deprecated
    public boolean isGlobalSecondary(ResourcePack pack) {
        return this.getGlobalAssignment().isSecondary(pack);
    }

    @Deprecated
    public boolean isGlobalSecondary(String packname) {
        return this.getGlobalAssignment().isSecondary(packname);
    }

    @Deprecated
    public List<String> getGlobalSecondary() {
        return new ArrayList<String>(this.global.getSecondaries());
    }

    @Deprecated
    public ResourcePack getServerPack(String server) {
        return this.getByName(this.getAssignment(server).getPack());
    }

    @Deprecated
    public ResourcePack getUserPack(UUID playerid) {
        return this.plugin.getUserManager().getUserPack(playerid);
    }

    @Deprecated
    public ResourcePack setUserPack(UUID playerid, ResourcePack pack) {
        return this.plugin.getUserManager().setUserPack(playerid, pack);
    }

    @Deprecated
    public ResourcePack clearUserPack(UUID playerid) {
        return this.plugin.getUserManager().clearUserPack(playerid);
    }

    @Deprecated
    public void addServer(String server, ResourcePack pack) {
        this.getAssignment(server).setPack(pack);
    }

    public PackAssignment getGlobalAssignment() {
        return this.global;
    }

    public void setGlobalAssignment(PackAssignment assignment) {
        this.global = assignment;
    }

    public PackAssignment addAssignment(PackAssignment assignment) {
        PackAssignment previous = assignment.getRegex() != null ? this.regexAssignments.put(assignment.getName().toLowerCase(), assignment) : this.literalAssignments.put(assignment.getName().toLowerCase(), assignment);
        this.checkDirty();
        return previous;
    }

    public PackAssignment getAssignment(String server) {
        PackAssignment assignment = this.literalAssignments.get(server.toLowerCase());
        if (assignment != null) {
            return assignment;
        }
        for (PackAssignment regexAssignment : this.regexAssignments.values()) {
            if (!regexAssignment.getRegex().matcher(server).matches()) continue;
            return regexAssignment;
        }
        return new PackAssignment(EMPTY_IDENTIFIER);
    }

    public PackAssignment getAssignmentByName(String name) {
        PackAssignment assignment = this.literalAssignments.get(name.toLowerCase());
        if (assignment == null) {
            assignment = this.regexAssignments.get(name.toLowerCase());
        }
        return assignment;
    }

    public Collection<? extends PackAssignment> getAssignments() {
        ArrayList<PackAssignment> assignments = new ArrayList<PackAssignment>(this.literalAssignments.values());
        assignments.addAll(this.regexAssignments.values());
        return assignments;
    }

    public PackAssignment loadAssignment(String name, Map<String, Object> config) {
        PackAssignment assignment = new PackAssignment(name);
        if (config.get("regex") != null) {
            if (!(config.get("regex") instanceof String)) {
                this.plugin.getLogger().log(Level.WARNING, "'regex' option has to be a String!");
            } else {
                try {
                    assignment.setRegex(Pattern.compile((String)config.get("regex")));
                    this.plugin.getLogger().log(this.plugin.getLogLevel(), "Regex: " + assignment.getRegex().toString());
                }
                catch (PatternSyntaxException e) {
                    this.plugin.getLogger().log(Level.WARNING, "The assignment's regex '" + config.get("regex") + "' isn't valid! Using the key name literally! (" + e.getMessage() + ")");
                }
            }
        }
        if (config.get("pack") != null) {
            if (!(config.get("pack") instanceof String)) {
                this.plugin.getLogger().log(Level.WARNING, "'pack' option has to be a String!");
            } else if (!((String)config.get("pack")).isEmpty()) {
                ResourcePack pack = this.getByName((String)config.get("pack"));
                if (pack != null) {
                    assignment.setPack(pack);
                    this.plugin.getLogger().log(this.plugin.getLogLevel(), "Pack: " + pack.getName());
                } else {
                    this.plugin.getLogger().log(Level.WARNING, "No pack with the name " + config.get("pack") + " defined?");
                }
            }
        }
        if (config.get("secondary") != null) {
            if (!(config.get("secondary") instanceof List) || !((List)config.get("secondary")).isEmpty() && !(((List)config.get("secondary")).get(0) instanceof String)) {
                this.plugin.getLogger().log(Level.WARNING, "'secondary' option has to be a String List!");
            } else {
                this.plugin.getLogger().log(this.plugin.getLogLevel(), "Secondary packs:");
                List secondary = (List)config.get("secondary");
                for (String secondaryPack : secondary) {
                    ResourcePack pack = this.getByName(secondaryPack);
                    if (pack != null) {
                        assignment.addSecondary(pack);
                        this.plugin.getLogger().log(this.plugin.getLogLevel(), "- " + pack.getName());
                        continue;
                    }
                    this.plugin.getLogger().log(Level.WARNING, "No pack with the name " + config.get("pack") + " defined?");
                }
            }
        }
        if (config.get("send-delay") != null) {
            if (!(config.get("send-delay") instanceof Number)) {
                this.plugin.getLogger().log(Level.WARNING, "'send-delay' option has to be a number!");
            } else {
                assignment.setSendDelay(((Number)config.get("send-delay")).longValue());
                this.plugin.getLogger().log(this.plugin.getLogLevel(), "Send delay: " + assignment.getSendDelay());
            }
        }
        return assignment;
    }

    @Deprecated
    public boolean removeServer(String server) {
        return this.removeAssignment(server);
    }

    public boolean removeAssignment(String key) {
        if (this.literalAssignments.remove(key.toLowerCase()) != null) {
            this.regexAssignments.remove(key.toLowerCase());
            this.checkDirty();
            return true;
        }
        return false;
    }

    public boolean removeAssignment(PackAssignment assignment) {
        boolean removed = assignment.getRegex() != null ? this.regexAssignments.remove(assignment.getName().toLowerCase()) != null : this.literalAssignments.remove(assignment.getName().toLowerCase()) != null;
        this.checkDirty();
        return removed;
    }

    @Deprecated
    public boolean addServerSecondary(String server, ResourcePack pack) {
        return this.getAssignment(server).addSecondary(pack);
    }

    @Deprecated
    public boolean addServerSecondary(String server, String packname) {
        return this.getAssignment(server).addSecondary(packname);
    }

    @Deprecated
    public boolean isServerSecondary(String server, ResourcePack pack) {
        return this.getAssignment(server).isSecondary(pack);
    }

    @Deprecated
    public boolean isServerSecondary(String server, String packname) {
        return this.getAssignment(server).isSecondary(packname);
    }

    @Deprecated
    public List<String> getServerSecondary(String server) {
        return new ArrayList<String>(this.getAssignment(server).getSecondaries());
    }

    public boolean setPack(UUID playerId, ResourcePack pack) {
        return this.setPack(playerId, pack, true);
    }

    public boolean setPack(UUID playerId, ResourcePack pack, boolean temporary) {
        ResourcePack prev = this.plugin.getUserManager().getUserPack(playerId);
        if (!temporary) {
            if (pack == null) {
                this.plugin.setStoredPack(playerId, null);
            } else {
                this.plugin.setStoredPack(playerId, pack.getName());
                this.plugin.getUserManager().updatePackTime(playerId);
            }
        }
        if (pack == null && (pack = this.getByName(this.plugin.getStoredPack(playerId))) != null) {
            this.plugin.getLogger().log(this.plugin.getLogLevel(), playerId + " has the pack " + pack.getName() + " stored!");
        }
        if (pack != null && pack.equals(prev)) {
            return false;
        }
        if (prev == null && (pack == null || pack.equals(this.getEmptyPack()))) {
            return false;
        }
        IResourcePackSendEvent sendEvent = this.plugin.callPackSendEvent(playerId, pack);
        if (sendEvent.isCancelled()) {
            this.plugin.getLogger().log(this.plugin.getLogLevel(), "Pack send event for " + playerId + " was cancelled!");
            return false;
        }
        pack = sendEvent.getPack();
        if (pack == null && prev != null) {
            pack = this.getEmptyPack();
        }
        if (pack != null && !pack.equals(prev)) {
            this.plugin.getUserManager().setUserPack(playerId, pack);
            this.plugin.sendPack(playerId, pack);
            return true;
        }
        return false;
    }

    public void applyPack(UUID playerId, String serverName) {
        ResourcePack pack = this.getApplicablePack(playerId, serverName);
        this.setPack(playerId, pack);
    }

    public ResourcePack getApplicablePack(UUID playerId, String serverName) {
        ResourcePack prev = this.plugin.getUserManager().getUserPack(playerId);
        ResourcePack pack = null;
        ResourcePack stored = this.getByName(this.plugin.getStoredPack(playerId));
        ResourcepacksPlayer player = this.plugin.getPlayer(playerId);
        if (player == null) {
            player = new ResourcepacksPlayer("uuid:" + playerId, playerId);
        }
        if (this.getStoredPacksOverride() && stored != null && this.checkPack(playerId, stored, IResourcePackSelectEvent.Status.SUCCESS) == IResourcePackSelectEvent.Status.SUCCESS) {
            if (stored.equals(prev)) {
                this.plugin.getLogger().log(this.plugin.getLogLevel(), player.getName() + " already uses the stored pack " + stored.getName());
            } else {
                this.plugin.getLogger().log(this.plugin.getLogLevel(), player.getName() + " had the pack " + stored.getName() + " stored, using that");
            }
            return stored;
        }
        if (this.getGlobalAssignment().isSecondary(prev) && this.checkPack(playerId, prev, IResourcePackSelectEvent.Status.SUCCESS) == IResourcePackSelectEvent.Status.SUCCESS) {
            this.plugin.getLogger().log(this.plugin.getLogLevel(), player.getName() + " matched global assignment");
            return prev;
        }
        IResourcePackSelectEvent.Status status = IResourcePackSelectEvent.Status.UNKNOWN;
        if (serverName != null && !serverName.isEmpty()) {
            PackAssignment assignment = this.getAssignment(serverName);
            if (assignment.isSecondary(prev) && this.checkPack(playerId, prev, IResourcePackSelectEvent.Status.SUCCESS) == IResourcePackSelectEvent.Status.SUCCESS) {
                this.plugin.getLogger().log(this.plugin.getLogLevel(), player.getName() + " matched assignment " + assignment.getName());
                return prev;
            }
            ResourcePack serverPack = this.getByName(assignment.getPack());
            status = this.checkPack(playerId, serverPack, status);
            if (status == IResourcePackSelectEvent.Status.SUCCESS) {
                pack = serverPack;
                this.plugin.getLogger().log(this.plugin.getLogLevel(), player.getName() + " matched assignment " + assignment.getName());
            } else if (prev != null || serverPack != null) {
                for (String secondaryName : assignment.getSecondaries()) {
                    ResourcePack secondaryPack = this.getByName(secondaryName);
                    status = this.checkPack(playerId, secondaryPack, status);
                    if (status != IResourcePackSelectEvent.Status.SUCCESS) continue;
                    pack = secondaryPack;
                    this.plugin.getLogger().log(this.plugin.getLogLevel(), player.getName() + " matched assignment " + assignment.getName());
                    break;
                }
            }
        }
        if (pack == null) {
            ResourcePack globalPack = this.getByName(this.getGlobalAssignment().getPack());
            status = this.checkPack(playerId, globalPack, status);
            if (status == IResourcePackSelectEvent.Status.SUCCESS) {
                pack = globalPack;
                this.plugin.getLogger().log(this.plugin.getLogLevel(), player.getName() + " matched global assignment");
            } else if (prev != null || globalPack != null) {
                for (String secondaryName : this.getGlobalAssignment().getSecondaries()) {
                    ResourcePack secondaryPack = this.getByName(secondaryName);
                    status = this.checkPack(playerId, secondaryPack, status);
                    if (status != IResourcePackSelectEvent.Status.SUCCESS) continue;
                    this.plugin.getLogger().log(this.plugin.getLogLevel(), player.getName() + " matched global assignment");
                    pack = secondaryPack;
                    break;
                }
            }
        }
        if (pack != null) {
            status = IResourcePackSelectEvent.Status.SUCCESS;
        }
        IResourcePackSelectEvent selectEvent = this.plugin.callPackSelectEvent(playerId, pack, status);
        return selectEvent.getPack();
    }

    protected IResourcePackSelectEvent.Status checkPack(UUID playerId, ResourcePack pack, IResourcePackSelectEvent.Status status) {
        boolean hasPermission;
        if (pack == null) {
            return status;
        }
        boolean rightFormat = pack.getFormat() <= this.plugin.getPlayerPackFormat(playerId);
        boolean bl = hasPermission = !pack.isRestricted() || this.plugin.checkPermission(playerId, pack.getPermission());
        if (rightFormat && hasPermission) {
            return IResourcePackSelectEvent.Status.SUCCESS;
        }
        if (status != IResourcePackSelectEvent.Status.NO_PERM_AND_WRONG_VERSION) {
            if (!rightFormat) {
                status = !hasPermission || status == IResourcePackSelectEvent.Status.NO_PERMISSION ? IResourcePackSelectEvent.Status.NO_PERM_AND_WRONG_VERSION : IResourcePackSelectEvent.Status.WRONG_VERSION;
            }
            if (!hasPermission) {
                status = !rightFormat || status == IResourcePackSelectEvent.Status.WRONG_VERSION ? IResourcePackSelectEvent.Status.NO_PERM_AND_WRONG_VERSION : IResourcePackSelectEvent.Status.NO_PERMISSION;
            }
        }
        return status;
    }

    public List<ResourcePack> getPacks() {
        return new ArrayList<ResourcePack>(this.packNames.values());
    }

    public void generateHashes(ResourcepacksPlayer sender) {
        this.plugin.runAsyncTask(() -> {
            this.plugin.sendMessage(sender, "generate-hashes.generating", new String[0]);
            int changed = 0;
            for (ResourcePack pack : this.getPacks()) {
                if (pack.getName().startsWith("backend-")) continue;
                Path target = new File(this.plugin.getDataFolder(), pack.getName().replaceAll("[^a-zA-Z0-9\\.\\-]", "_") + "-downloaded.zip").toPath();
                InputStream in = null;
                URL url = new URL(pack.getUrl());
                this.plugin.sendMessage(sender, "generate-hashes.downloading", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash());
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setRequestProperty("User-Agent", this.plugin.getName() + "/" + this.plugin.getVersion());
                in = con.getInputStream();
                Files.copy(in, target, StandardCopyOption.REPLACE_EXISTING);
                byte[] hash = Hashing.sha1().hashBytes(Files.readAllBytes(target)).asBytes();
                if (!Arrays.equals(pack.getRawHash(), hash)) {
                    this.packHashes.remove(pack.getHash());
                    pack.setRawHash(hash);
                    this.packHashes.put(pack.getHash(), pack);
                    ++changed;
                }
                this.plugin.sendMessage(sender, "generate-hashes.hash-sum", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash());
                Files.deleteIfExists(target);
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.plugin.sendMessage(sender, Level.SEVERE, "generate-hashes.failed-to-load-pack", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash(), "error", e.getMessage());
                    e.printStackTrace();
                }
                continue;
                catch (MalformedURLException e) {
                    this.plugin.sendMessage(sender, Level.SEVERE, "generate-hashes.invalid-url", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash(), "error", e.getMessage());
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        this.plugin.sendMessage(sender, Level.SEVERE, "generate-hashes.failed-to-load-pack", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash(), "error", e2.getMessage());
                        e2.printStackTrace();
                    }
                    continue;
                }
                catch (IOException e2) {
                    this.plugin.sendMessage(sender, Level.SEVERE, "generate-hashes.failed-to-load-pack", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash(), "error", e2.getMessage());
                    if (in == null) continue;
                    {
                        catch (Throwable throwable) {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e3) {
                                    this.plugin.sendMessage(sender, Level.SEVERE, "generate-hashes.failed-to-load-pack", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash(), "error", e3.getMessage());
                                    e3.printStackTrace();
                                }
                            }
                            throw throwable;
                        }
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e4) {
                        this.plugin.sendMessage(sender, Level.SEVERE, "generate-hashes.failed-to-load-pack", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash(), "error", e4.getMessage());
                        e4.printStackTrace();
                    }
                }
            }
            if (changed > 0) {
                this.plugin.sendMessage(sender, "generate-hashes.changed", "amount", String.valueOf(changed));
                this.plugin.runTask(this.plugin::saveConfigChanges);
            } else {
                this.plugin.sendMessage(sender, "generate-hashes.none-changed", new String[0]);
            }
        });
    }

    public int getPackFormat(int version) {
        if (version >= 565) {
            return 5;
        }
        if (version >= 348) {
            return 4;
        }
        if (version >= 210) {
            return 3;
        }
        if (version >= 49) {
            return 2;
        }
        if (version >= 47) {
            return 1;
        }
        if (version >= 0) {
            return 0;
        }
        return -1;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void checkDirty() {
        if (this.dirty) {
            this.dirty = false;
            this.plugin.saveConfigChanges();
        }
    }
}

