/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.util.Arrays;

public class ResourcePack {
    private String name;
    private String url;
    private byte[] hash;
    private int format;
    private boolean restricted;
    private String permission;

    public ResourcePack(String name, String url, String hash) {
        this(name, url, hash, 0);
    }

    public ResourcePack(String name, String url, String hash, int format) {
        this(name, url, hash, format, false);
    }

    public ResourcePack(String name, String url, String hash, boolean restricted) {
        this(name, url, hash, 0, restricted);
    }

    public ResourcePack(String name, String url, String hash, int format, boolean restricted) {
        this(name, url, hash, format, restricted, "resourcepacksplugin.pack." + name);
    }

    public ResourcePack(String name, String url, String hash, int format, boolean restricted, String permission) {
        this.name = name;
        this.url = url;
        if (hash != null && hash.length() == 40) {
            this.setHash(hash);
        } else {
            this.hash = Hashing.sha1().hashString((CharSequence)url, Charsets.UTF_8).asBytes();
        }
        this.format = format;
        this.restricted = restricted;
        this.permission = permission;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    void setUrl(String url) {
        this.url = url;
    }

    public String getHash() {
        return BaseEncoding.base16().lowerCase().encode(this.hash);
    }

    void setHash(String hash) {
        this.hash = BaseEncoding.base16().lowerCase().decode((CharSequence)hash.toLowerCase());
    }

    public byte[] getRawHash() {
        return this.hash;
    }

    public void setRawHash(byte[] hash) {
        this.hash = hash;
    }

    public int getFormat() {
        return this.format;
    }

    public boolean setFormat(int format) {
        if (this.format == format) {
            return false;
        }
        this.format = format;
        return true;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public boolean setRestricted(boolean restricted) {
        if (this.restricted == restricted) {
            return false;
        }
        this.restricted = restricted;
        return true;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean setPermission(String permission) {
        if (this.permission.equals(permission)) {
            return false;
        }
        this.permission = permission;
        return true;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourcePack)) {
            return false;
        }
        ResourcePack other = (ResourcePack)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        byte[] this$hash = this.getRawHash();
        byte[] other$hash = other.getRawHash();
        return !(this$hash == null ? other$hash != null : !Arrays.equals(this$hash, other$hash));
    }

    public String[] getReplacements() {
        return new String[]{"name", this.getName(), "url", this.getUrl(), "hash", this.getHash(), "format", String.valueOf(this.getFormat()), "restricted", String.valueOf(this.isRestricted()), "permission", this.getPermission()};
    }
}

