/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core;

import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class UserManager {
    private final ResourcepacksPlugin plugin;
    private final Map<UUID, String> userPackMap = new ConcurrentHashMap<UUID, String>();
    private Map<UUID, Long> userPackTime = new ConcurrentHashMap<UUID, Long>();

    public UserManager(ResourcepacksPlugin plugin) {
        this.plugin = plugin;
    }

    public ResourcePack getUserPack(UUID playerid) {
        String name = this.userPackMap.get(playerid);
        return name == null ? null : this.plugin.getPackManager().getByName(name);
    }

    public ResourcePack setUserPack(UUID playerid, ResourcePack pack) {
        String previous = this.userPackMap.put(playerid, pack.getName());
        return previous == null ? null : this.plugin.getPackManager().getByName(previous);
    }

    public Map<UUID, String> getUserPacks() {
        return this.userPackMap;
    }

    public ResourcePack clearUserPack(UUID playerid) {
        String previous = this.userPackMap.remove(playerid);
        return previous == null ? null : this.plugin.getPackManager().getByName(previous);
    }

    public void onDisconnect(UUID playerId) {
        if (this.checkStoredPack(playerId)) {
            this.plugin.getLogger().log(this.plugin.getLogLevel(), "Removed stored pack from " + playerId + " as he logged out in under " + this.plugin.getPermanentPackRemoveTime() + " seconds after it got applied!");
        }
        this.userPackTime.remove(playerId);
        this.plugin.clearPack(playerId);
    }

    public void updatePackTime(UUID playerId) {
        this.userPackTime.put(playerId, System.currentTimeMillis());
    }

    private boolean checkStoredPack(UUID playerId) {
        int packRemoveTime = this.plugin.getPermanentPackRemoveTime();
        if (packRemoveTime <= 0) {
            return false;
        }
        Long packSet = this.userPackTime.get(playerId);
        if (packSet == null) {
            return false;
        }
        if (packSet + (long)(packRemoveTime * 1000) < System.currentTimeMillis()) {
            return false;
        }
        String storedPackName = this.plugin.getStoredPack(playerId);
        if (storedPackName == null) {
            return false;
        }
        String currentPack = this.userPackMap.get(playerId);
        if (!storedPackName.equalsIgnoreCase(currentPack)) {
            return false;
        }
        this.plugin.setStoredPack(playerId, null);
        return true;
    }
}

