/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core.commands;

import de.themoep.resourcepacksplugin.core.ChatColor;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class PluginCommandExecutor {
    protected final ResourcepacksPlugin plugin;
    private String name;
    private List<String> aliases = new ArrayList<String>();
    protected String permission;
    private String usage;
    private PluginCommandExecutor parent = null;
    protected Map<String, PluginCommandExecutor> subCommands = new LinkedHashMap<String, PluginCommandExecutor>();
    protected Map<String, PluginCommandExecutor> subCommandAliases = new LinkedHashMap<String, PluginCommandExecutor>();

    public PluginCommandExecutor(ResourcepacksPlugin plugin, String usage) {
        this(plugin, usage, null);
    }

    public PluginCommandExecutor(ResourcepacksPlugin plugin, String usage, String permission) {
        this(plugin, null, usage, permission);
    }

    public PluginCommandExecutor(ResourcepacksPlugin plugin, PluginCommandExecutor parent, String usage) {
        this(plugin, parent, usage, null);
    }

    public PluginCommandExecutor(ResourcepacksPlugin plugin, PluginCommandExecutor parent, String usage, String permission) {
        this(plugin, parent, usage, permission, new String[0]);
    }

    public PluginCommandExecutor(ResourcepacksPlugin plugin, PluginCommandExecutor parent, String usage, String permission, String ... aliases) {
        this.plugin = plugin;
        this.parent = parent;
        if (usage == null) {
            usage = "";
        }
        if (usage.isEmpty() && parent != null) {
            throw new IllegalArgumentException("You have to set a command name/usage!");
        }
        this.name = usage.contains(" ") ? usage.substring(0, usage.indexOf(32)).toLowerCase() : usage.toLowerCase();
        this.usage = usage.contains(" ") ? usage.substring(usage.indexOf(32) + 1) : "";
        this.permission = permission;
        if (permission == null) {
            this.permission = parent != null ? parent.permission + "." + this.name : plugin.getName().toLowerCase() + ".command." + this.getPath().replace(' ', '.');
        }
        Collections.addAll(this.aliases, aliases);
    }

    public abstract boolean run(ResourcepacksPlayer var1, String[] var2);

    public boolean execute(ResourcepacksPlayer sender, String[] args) {
        PluginCommandExecutor subCommand;
        if (this.permission != null && !this.permission.isEmpty() && !this.plugin.checkPermission(sender, this.permission)) {
            this.plugin.sendMessage(sender, "command.no-permission", "command", this.getPath(), "name", this.getName(), "usage", this.getUsage(), "permission", this.permission, "subcommands", String.join((CharSequence)"|", this.subCommands.keySet()));
            return false;
        }
        if (args.length > 0 && (subCommand = this.getSubCommand(args[0])) != null) {
            return subCommand.execute(sender, Arrays.copyOfRange(args, 1, args.length));
        }
        if (!this.run(sender, args)) {
            this.sendMessage(sender, "usage", "command", this.getPath(), "name", this.getName(), "usage", this.getUsage(), "permission", this.permission, "subcommands", String.join((CharSequence)"|", this.subCommands.keySet()));
            return false;
        }
        return true;
    }

    public PluginCommandExecutor getSubCommand(String name) {
        PluginCommandExecutor subCommand = this.subCommands.get(name.toLowerCase());
        if (subCommand == null) {
            subCommand = this.subCommandAliases.get(name.toLowerCase());
        }
        return subCommand;
    }

    public void sendMessage(ResourcepacksPlayer sender, String key, String ... replacements) {
        this.plugin.sendMessage(sender, this.getMessageKey(sender, key), replacements);
    }

    protected String getMessage(ResourcepacksPlayer sender, String key, String ... replacements) {
        return this.plugin.getMessage(sender, this.getMessageKey(sender, key), replacements);
    }

    private String getMessageKey(ResourcepacksPlayer sender, String key) {
        String resultKey = this.getKey() + "." + key;
        while (!this.plugin.hasMessage(sender, "command." + resultKey)) {
            if (!resultKey.contains(".")) {
                return "command." + this.getKey() + "." + key;
            }
            resultKey = resultKey.substring(resultKey.indexOf(46) + 1);
        }
        return "command." + resultKey;
    }

    public String getPath() {
        String parentPath = this.parent != null ? this.parent.getPath() : "";
        return parentPath.isEmpty() ? this.getName() : parentPath + " " + this.getName();
    }

    public String getKey() {
        String parentKey;
        String string = parentKey = this.parent != null ? this.parent.getKey() : "";
        return parentKey.isEmpty() ? this.name : parentKey + (this.name.isEmpty() ? "" : "." + this.name);
    }

    public void registerSubCommands(PluginCommandExecutor ... subCommands) {
        for (PluginCommandExecutor subCommand : subCommands) {
            this.subCommands.put(subCommand.name, subCommand);
            for (String alias : subCommand.aliases) {
                this.subCommandAliases.putIfAbsent(alias.toLowerCase(), subCommand);
            }
        }
    }

    public String getName() {
        if (this.name.isEmpty() && this.parent == null) {
            return this.plugin.getName().charAt(0) + "rp";
        }
        return this.name;
    }

    public String getUsage() {
        String usage = this.usage;
        if (usage.isEmpty() && !this.subCommands.isEmpty()) {
            usage = "[" + String.join((CharSequence)" | ", this.subCommands.keySet()) + "]";
        }
        return ChatColor.usage(usage);
    }

    public ResourcepacksPlugin getPlugin() {
        return this.plugin;
    }

    public String getPermission() {
        return this.permission;
    }

    public String[] getAliases() {
        return this.aliases.toArray(new String[0]);
    }
}

