/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core.commands;

import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import de.themoep.resourcepacksplugin.core.commands.PluginCommandExecutor;

public class ResetPackCommandExecutor
extends PluginCommandExecutor {
    public ResetPackCommandExecutor(ResourcepacksPlugin plugin) {
        super(plugin, "resetpack [<playername>] [<temp>]");
    }

    @Override
    public boolean run(ResourcepacksPlayer sender, String[] args) {
        String tempStr = null;
        if (args.length > 0 && this.plugin.checkPermission(sender, this.permission + ".temporary")) {
            tempStr = args[args.length - 1];
        }
        boolean temp = this.plugin.isUsepackTemporary();
        if ("false".equalsIgnoreCase(tempStr)) {
            temp = false;
        } else if ("true".equalsIgnoreCase(tempStr)) {
            temp = true;
        } else {
            if (tempStr != null && args.length > 1) {
                this.sendMessage(sender, "invalid-temporary", "input", tempStr);
                return true;
            }
            tempStr = null;
        }
        ResourcepacksPlayer player = null;
        if ((args.length > 1 || tempStr == null && args.length > 0) && this.plugin.checkPermission(sender, this.permission + ".others")) {
            player = this.plugin.getPlayer(args[0]);
            if (player == null) {
                this.sendMessage(sender, "player-not-online", "input", args[0]);
                return true;
            }
        } else if (sender != null) {
            player = sender;
        } else {
            this.plugin.getLogger().warning("You have to specify a player if you want to run this command from the console! /resetpack <playername> [<temp>]");
            return true;
        }
        if (!temp) {
            String storedPack = this.plugin.getStoredPack(player.getUniqueId());
            if (storedPack == null) {
                this.sendMessage(sender, "no-pack-stored", new String[0]);
            } else {
                this.sendMessage(sender, "had-stored-pack", "pack", storedPack);
            }
        }
        if (this.plugin.getPackManager().setPack(player.getUniqueId(), null, temp)) {
            if (!player.equals(sender)) {
                this.sendMessage(sender, "success-other", "player", player.getName());
            }
            this.sendMessage(player, "success", new String[0]);
            String senderName = sender != null ? sender.getName() : "CONSOLE";
            this.plugin.getLogger().log(this.plugin.getLogLevel(), senderName + " reset the pack of " + player.getName());
        } else if (player.equals(sender)) {
            this.sendMessage(sender, "no-pack", new String[0]);
        } else {
            this.sendMessage(sender, "no-pack-other", "player", player.getName());
        }
        return true;
    }
}

