/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core;

import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import de.themoep.resourcepacksplugin.core.ClientType;
import de.themoep.resourcepacksplugin.core.MinecraftVersion;
import de.themoep.resourcepacksplugin.core.PackAssignment;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSelectEvent;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSendEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PackManager {
    public static final String EMPTY_IDENTIFIER = "empty";
    public static final String HASH_KEY = "#hash=";
    private final ResourcepacksPlugin plugin;
    private Map<String, ResourcePack> packNames;
    private Map<String, ResourcePack> packHashes;
    private Map<String, ResourcePack> packUrls;
    private ResourcePack empty = null;
    private PackAssignment global = new PackAssignment("global");
    private Map<String, PackAssignment> literalAssignments;
    private Map<String, PackAssignment> regexAssignments;
    private boolean dirty = false;
    private boolean storedPacksOverride;

    public PackManager(ResourcepacksPlugin plugin) {
        this.plugin = plugin;
    }

    public void init() {
        this.packNames = new LinkedHashMap<String, ResourcePack>();
        this.packHashes = new HashMap<String, ResourcePack>();
        this.packUrls = new HashMap<String, ResourcePack>();
        this.empty = null;
        this.global = new PackAssignment("global");
        this.literalAssignments = new LinkedHashMap<String, PackAssignment>();
        this.regexAssignments = new LinkedHashMap<String, PackAssignment>();
    }

    public ResourcePack loadPack(String name, Map<String, Object> config) throws IllegalArgumentException {
        if (config == null) {
            throw new IllegalArgumentException("Pack " + name + " had a null config?");
        }
        String url = PackManager.get(config, "url", "");
        List variantsList = PackManager.get(config, "variants", new ArrayList());
        if (url.isEmpty() && variantsList.isEmpty()) {
            throw new IllegalArgumentException("Pack " + name + " does not have an url defined!");
        }
        String hash = PackManager.get(config, "hash", "");
        int format = PackManager.get(config, "format", 0);
        int mcVersion = MinecraftVersion.parseVersion(PackManager.get(config, "version", String.valueOf(PackManager.get(config, "version", 0)))).getProtocolNumber();
        boolean restricted = PackManager.get(config, "restricted", false);
        String perm = PackManager.get(config, "permission", this.plugin.getName().toLowerCase(Locale.ROOT) + ".pack." + name);
        ClientType type = ClientType.valueOf(PackManager.get(config, "type", "original").toUpperCase(Locale.ROOT));
        ResourcePack pack = new ResourcePack(name, url, hash, format, mcVersion, restricted, perm, type);
        for (int i = 0; i < variantsList.size(); ++i) {
            pack.getVariants().add(this.loadPack(name + "-variant-" + (i + 1), this.plugin.getConfigMap(variantsList.get(i))));
        }
        return pack;
    }

    private static <T> T get(Map<String, Object> config, String path, T def) {
        Object o = config.getOrDefault(path, def);
        if (o != null && def != null && def.getClass().isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        return def;
    }

    public ResourcePack addPack(ResourcePack pack) throws IllegalArgumentException {
        if (pack.getVariants().isEmpty()) {
            ResourcePack byHash = this.getByHash(pack.getHash());
            if (byHash != null && !byHash.getName().equalsIgnoreCase(pack.getName())) {
                throw new IllegalArgumentException("Could not add pack '" + pack.getName() + "'. There is already a pack with the hash '" + pack.getHash() + "' but a different name defined! (" + byHash.getName() + ")");
            }
            if (pack.getUrl() != null && !pack.getUrl().isEmpty()) {
                ResourcePack byUrl = this.getByUrl(pack.getUrl());
                if (byUrl != null && !byUrl.getName().equalsIgnoreCase(pack.getName())) {
                    throw new IllegalArgumentException("Could not add pack '" + pack.getName() + "'. There is already a pack with the url '" + pack.getUrl() + "' but a different name defined! (" + byUrl.getName() + ")");
                }
                this.packUrls.put(pack.getUrl(), pack);
            }
            if (pack.getHash().length() > 0) {
                this.packHashes.put(pack.getHash(), pack);
            }
        } else {
            for (ResourcePack variant : pack.getVariants()) {
                this.cacheVariant(variant, pack);
            }
        }
        return this.packNames.put(pack.getName().toLowerCase(Locale.ROOT), pack);
    }

    public boolean removePack(ResourcePack pack) {
        boolean known = false;
        if (pack.getVariants().isEmpty()) {
            if (pack.getUrl() != null && pack.getUrl().isEmpty()) {
                known |= this.packUrls.remove(pack.getUrl(), pack);
            }
            if (pack.getHash().length() > 0) {
                known |= this.packHashes.remove(pack.getHash(), pack);
            }
        } else {
            for (ResourcePack variant : pack.getVariants()) {
                known |= this.uncacheVariant(variant, pack);
            }
        }
        return this.packNames.remove(pack.getName().toLowerCase(Locale.ROOT), pack) || known;
    }

    private void cacheVariant(ResourcePack variant, ResourcePack pack) {
        if (variant.getVariants().isEmpty()) {
            this.packUrls.putIfAbsent(variant.getUrl(), pack);
            this.packHashes.putIfAbsent(variant.getHash(), pack);
        } else {
            for (ResourcePack variantVariant : variant.getVariants()) {
                this.cacheVariant(variantVariant, pack);
            }
        }
    }

    private boolean uncacheVariant(ResourcePack variant, ResourcePack pack) {
        boolean known = false;
        if (variant.getVariants().isEmpty()) {
            known |= this.packUrls.remove(variant.getUrl(), pack);
            known |= this.packHashes.remove(variant.getHash(), pack);
        } else {
            for (ResourcePack variantVariant : variant.getVariants()) {
                known |= this.uncacheVariant(variantVariant, pack);
            }
        }
        return known;
    }

    public boolean setPackHash(ResourcePack pack, String hash) {
        if (pack.getHash().equals(hash)) {
            return false;
        }
        this.packHashes.remove(pack.getHash());
        pack.setHash(hash);
        this.packHashes.put(pack.getHash(), pack);
        return true;
    }

    public boolean setPackUrl(ResourcePack pack, String url) {
        if (pack.getUrl().equals(url)) {
            return false;
        }
        this.packUrls.remove(pack.getUrl());
        pack.setUrl(url);
        this.packUrls.put(pack.getUrl(), pack);
        return true;
    }

    public ResourcePack getByName(String name) {
        return name != null ? this.packNames.get(name.toLowerCase(Locale.ROOT)) : null;
    }

    public ResourcePack getByHash(String hash) {
        return this.packHashes.get(hash);
    }

    public ResourcePack getByHash(byte[] hash) {
        return this.packHashes.get(BaseEncoding.base16().lowerCase().encode(hash));
    }

    public ResourcePack getByUrl(String url) {
        if (url.contains(HASH_KEY)) {
            url = url.substring(0, url.lastIndexOf(HASH_KEY));
        }
        return this.packUrls.get(url);
    }

    public ResourcePack setEmptyPack(ResourcePack pack) {
        ResourcePack rp = this.getEmptyPack();
        this.empty = pack;
        return rp;
    }

    public ResourcePack setEmptyPack(String packname) {
        return this.setEmptyPack(this.getByName(packname));
    }

    public ResourcePack getEmptyPack() {
        return this.empty;
    }

    public void setStoredPacksOverride(boolean playerPacksOverride) {
        this.storedPacksOverride = playerPacksOverride;
    }

    public boolean getStoredPacksOverride() {
        return this.storedPacksOverride;
    }

    @Deprecated
    public ResourcePack setGlobalPack(ResourcePack pack) {
        ResourcePack rp = this.getGlobalPack();
        this.getGlobalAssignment().setPack(pack);
        return rp;
    }

    @Deprecated
    public ResourcePack setGlobalPack(String packname) {
        return this.setGlobalPack(this.getByName(packname));
    }

    @Deprecated
    public ResourcePack getGlobalPack() {
        return this.getByName(this.getGlobalAssignment().getPack());
    }

    @Deprecated
    public boolean addGlobalSecondary(ResourcePack pack) {
        return this.getGlobalAssignment().addSecondary(pack);
    }

    @Deprecated
    public boolean addGlobalSecondary(String packname) {
        return this.getGlobalAssignment().addSecondary(packname);
    }

    @Deprecated
    public boolean isGlobalSecondary(ResourcePack pack) {
        return this.getGlobalAssignment().isSecondary(pack);
    }

    @Deprecated
    public boolean isGlobalSecondary(String packname) {
        return this.getGlobalAssignment().isSecondary(packname);
    }

    @Deprecated
    public List<String> getGlobalSecondary() {
        return new ArrayList<String>(this.global.getSecondaries());
    }

    @Deprecated
    public ResourcePack getServerPack(String server) {
        return this.getByName(this.getAssignment(server).getPack());
    }

    @Deprecated
    public ResourcePack getUserPack(UUID playerid) {
        return this.plugin.getUserManager().getUserPack(playerid);
    }

    @Deprecated
    public ResourcePack setUserPack(UUID playerid, ResourcePack pack) {
        return this.plugin.getUserManager().setUserPack(playerid, pack);
    }

    @Deprecated
    public ResourcePack clearUserPack(UUID playerid) {
        return this.plugin.getUserManager().clearUserPack(playerid);
    }

    @Deprecated
    public void addServer(String server, ResourcePack pack) {
        this.getAssignment(server).setPack(pack);
    }

    public PackAssignment getGlobalAssignment() {
        return this.global;
    }

    public void setGlobalAssignment(PackAssignment assignment) {
        this.global = assignment;
    }

    public PackAssignment addAssignment(PackAssignment assignment) {
        PackAssignment previous = assignment.getRegex() != null ? this.regexAssignments.put(assignment.getName().toLowerCase(Locale.ROOT), assignment) : this.literalAssignments.put(assignment.getName().toLowerCase(Locale.ROOT), assignment);
        this.checkDirty();
        return previous;
    }

    public PackAssignment getAssignment(String server) {
        PackAssignment assignment = this.literalAssignments.get(server.toLowerCase(Locale.ROOT));
        if (assignment != null) {
            return assignment;
        }
        for (PackAssignment regexAssignment : this.regexAssignments.values()) {
            if (!regexAssignment.getRegex().matcher(server).matches()) continue;
            return regexAssignment;
        }
        return new PackAssignment(EMPTY_IDENTIFIER);
    }

    public PackAssignment getAssignmentByName(String name) {
        PackAssignment assignment = this.literalAssignments.get(name.toLowerCase(Locale.ROOT));
        if (assignment == null) {
            assignment = this.regexAssignments.get(name.toLowerCase(Locale.ROOT));
        }
        return assignment;
    }

    public Collection<? extends PackAssignment> getAssignments() {
        ArrayList<PackAssignment> assignments = new ArrayList<PackAssignment>(this.literalAssignments.values());
        assignments.addAll(this.regexAssignments.values());
        return assignments;
    }

    public PackAssignment loadAssignment(String name, Map<String, Object> config) {
        PackAssignment assignment = new PackAssignment(name);
        if (config.get("regex") != null) {
            if (!(config.get("regex") instanceof String)) {
                this.plugin.log(Level.WARNING, "'regex' option has to be a String!");
            } else {
                try {
                    assignment.setRegex(Pattern.compile((String)config.get("regex")));
                    this.plugin.logDebug("Regex: " + assignment.getRegex().toString());
                }
                catch (PatternSyntaxException e) {
                    this.plugin.log(Level.WARNING, "The assignment's regex '" + config.get("regex") + "' isn't valid! Using the key name literally! (" + e.getMessage() + ")");
                }
            }
        }
        if (config.get("pack") != null) {
            if (!(config.get("pack") instanceof String)) {
                this.plugin.log(Level.WARNING, "'pack' option has to be a String!");
            } else if (!((String)config.get("pack")).isEmpty()) {
                ResourcePack pack = this.getByName((String)config.get("pack"));
                if (pack != null) {
                    assignment.setPack(pack);
                    this.plugin.logDebug("Pack: " + pack.getName());
                } else {
                    this.plugin.log(Level.WARNING, "No pack with the name " + config.get("pack") + " defined?");
                }
            }
        }
        if (config.get("secondary") != null) {
            if (!(config.get("secondary") instanceof List) || !((List)config.get("secondary")).isEmpty() && !(((List)config.get("secondary")).get(0) instanceof String)) {
                this.plugin.log(Level.WARNING, "'secondary' option has to be a String List!");
            } else {
                this.plugin.logDebug("Secondary packs:");
                List secondary = (List)config.get("secondary");
                for (String secondaryPack : secondary) {
                    ResourcePack pack = this.getByName(secondaryPack);
                    if (pack != null) {
                        assignment.addSecondary(pack);
                        this.plugin.logDebug("- " + pack.getName());
                        continue;
                    }
                    this.plugin.log(Level.WARNING, "No pack with the name " + config.get("pack") + " defined?");
                }
            }
        }
        if (config.get("send-delay") != null) {
            if (!(config.get("send-delay") instanceof Number)) {
                this.plugin.log(Level.WARNING, "'send-delay' option has to be a number!");
            } else {
                assignment.setSendDelay(((Number)config.get("send-delay")).longValue());
                this.plugin.logDebug("Send delay: " + assignment.getSendDelay());
            }
        }
        return assignment;
    }

    @Deprecated
    public boolean removeServer(String server) {
        return this.removeAssignment(server);
    }

    public boolean removeAssignment(String key) {
        if (this.literalAssignments.remove(key.toLowerCase(Locale.ROOT)) != null) {
            this.regexAssignments.remove(key.toLowerCase(Locale.ROOT));
            this.checkDirty();
            return true;
        }
        return false;
    }

    public boolean removeAssignment(PackAssignment assignment) {
        boolean removed = assignment.getRegex() != null ? this.regexAssignments.remove(assignment.getName().toLowerCase(Locale.ROOT)) != null : this.literalAssignments.remove(assignment.getName().toLowerCase(Locale.ROOT)) != null;
        this.checkDirty();
        return removed;
    }

    @Deprecated
    public boolean addServerSecondary(String server, ResourcePack pack) {
        return this.getAssignment(server).addSecondary(pack);
    }

    @Deprecated
    public boolean addServerSecondary(String server, String packname) {
        return this.getAssignment(server).addSecondary(packname);
    }

    @Deprecated
    public boolean isServerSecondary(String server, ResourcePack pack) {
        return this.getAssignment(server).isSecondary(pack);
    }

    @Deprecated
    public boolean isServerSecondary(String server, String packname) {
        return this.getAssignment(server).isSecondary(packname);
    }

    @Deprecated
    public List<String> getServerSecondary(String server) {
        return new ArrayList<String>(this.getAssignment(server).getSecondaries());
    }

    public boolean setPack(UUID playerId, ResourcePack pack) {
        return this.setPack(playerId, pack, true) == IResourcePackSelectEvent.Status.SUCCESS;
    }

    public IResourcePackSelectEvent.Status setPack(UUID playerId, ResourcePack pack, boolean temporary) {
        ResourcePack stored;
        ResourcePack prev = this.plugin.getUserManager().getUserPack(playerId);
        if (!temporary) {
            if (pack == null) {
                this.plugin.setStoredPack(playerId, null);
            } else {
                this.plugin.setStoredPack(playerId, pack.getName());
                this.plugin.getUserManager().updatePackTime(playerId);
            }
        }
        if (pack == null && (stored = this.getByName(this.plugin.getStoredPack(playerId))) != null && this.checkPack(playerId, stored, IResourcePackSelectEvent.Status.SUCCESS) == IResourcePackSelectEvent.Status.SUCCESS) {
            pack = stored;
            this.plugin.logDebug(playerId + " has the pack " + stored.getName() + " stored!");
        }
        if (pack != null && pack.equals(prev)) {
            return IResourcePackSelectEvent.Status.UNKNOWN;
        }
        if (prev == null && (pack == null || pack.equals(this.getEmptyPack()))) {
            return IResourcePackSelectEvent.Status.UNKNOWN;
        }
        if (pack != null && pack.getType() == ClientType.BEDROCK) {
            return IResourcePackSelectEvent.Status.UNKNOWN;
        }
        IResourcePackSendEvent sendEvent = this.plugin.callPackSendEvent(playerId, pack);
        if (sendEvent.isCancelled()) {
            this.plugin.logDebug("Pack send event for " + playerId + " was cancelled!");
            return IResourcePackSelectEvent.Status.UNKNOWN;
        }
        pack = sendEvent.getPack();
        if (pack == null && prev != null) {
            pack = this.getEmptyPack();
        }
        if (pack != null && !pack.equals(prev)) {
            this.plugin.getUserManager().setUserPack(playerId, pack);
            if (pack.getVariants().isEmpty()) {
                this.plugin.sendPack(playerId, pack);
                return IResourcePackSelectEvent.Status.SUCCESS;
            }
            IResourcePackSelectEvent.Status status = IResourcePackSelectEvent.Status.SUCCESS;
            for (ResourcePack variant : pack.getVariants()) {
                IResourcePackSelectEvent.Status varStatus = this.checkPack(playerId, variant, IResourcePackSelectEvent.Status.UNKNOWN);
                if (varStatus == IResourcePackSelectEvent.Status.SUCCESS) {
                    this.plugin.sendPack(playerId, variant);
                    return IResourcePackSelectEvent.Status.SUCCESS;
                }
                if (varStatus.ordinal() <= status.ordinal()) continue;
                status = varStatus;
            }
            return status;
        }
        return IResourcePackSelectEvent.Status.UNKNOWN;
    }

    public void applyPack(UUID playerId, String serverName) {
        ResourcePack pack = this.getApplicablePack(playerId, serverName);
        this.setPack(playerId, pack);
    }

    public ResourcePack getApplicablePack(UUID playerId, String serverName) {
        ResourcePack prev = this.plugin.getUserManager().getUserPack(playerId);
        Object pack = null;
        ResourcePack stored = this.getByName(this.plugin.getStoredPack(playerId));
        ResourcepacksPlayer player = this.plugin.getPlayer(playerId);
        if (player == null) {
            player = new ResourcepacksPlayer("uuid:" + playerId, playerId);
        }
        if (this.getStoredPacksOverride() && stored != null && this.checkPack(playerId, stored, IResourcePackSelectEvent.Status.SUCCESS) == IResourcePackSelectEvent.Status.SUCCESS) {
            if (stored.equals(prev)) {
                this.plugin.logDebug(player.getName() + " already uses the stored pack " + stored.getName());
            } else {
                this.plugin.logDebug(player.getName() + " had the pack " + stored.getName() + " stored, using that");
            }
            return stored;
        }
        if (this.getGlobalAssignment().isSecondary(prev) && this.checkPack(playerId, prev, IResourcePackSelectEvent.Status.SUCCESS) == IResourcePackSelectEvent.Status.SUCCESS) {
            this.plugin.logDebug(player.getName() + " matched global assignment");
            return prev;
        }
        String matchReason = " due to ";
        IResourcePackSelectEvent.Status status = IResourcePackSelectEvent.Status.UNKNOWN;
        if (serverName != null && !serverName.isEmpty()) {
            PackAssignment assignment = this.getAssignment(serverName);
            if (assignment.isSecondary(prev) && this.checkPack(playerId, prev, IResourcePackSelectEvent.Status.SUCCESS) == IResourcePackSelectEvent.Status.SUCCESS) {
                this.plugin.logDebug(player.getName() + " matched assignment " + assignment.getName());
                return prev;
            }
            ResourcePack serverPack = this.getByName(assignment.getPack());
            status = this.checkPack(playerId, serverPack, status);
            matchReason = assignment.getName() + matchReason;
            if (status == IResourcePackSelectEvent.Status.SUCCESS) {
                pack = serverPack;
                matchReason = matchReason + "main pack";
            } else if (prev != null || serverPack != null) {
                for (String secondaryName : assignment.getSecondaries()) {
                    ResourcePack secondaryPack = this.getByName(secondaryName);
                    status = this.checkPack(playerId, secondaryPack, status);
                    if (status != IResourcePackSelectEvent.Status.SUCCESS) continue;
                    pack = secondaryPack;
                    matchReason = matchReason + "secondary pack";
                    break;
                }
            }
        }
        if (pack == null) {
            ResourcePack globalPack = this.getByName(this.getGlobalAssignment().getPack());
            status = this.checkPack(playerId, globalPack, status);
            matchReason = "global due to ";
            if (status == IResourcePackSelectEvent.Status.SUCCESS) {
                pack = globalPack;
                matchReason = matchReason + "main pack";
            } else if (prev != null || globalPack != null) {
                for (String secondaryName : this.getGlobalAssignment().getSecondaries()) {
                    ResourcePack secondaryPack = this.getByName(secondaryName);
                    status = this.checkPack(playerId, secondaryPack, status);
                    if (status != IResourcePackSelectEvent.Status.SUCCESS) continue;
                    pack = secondaryPack;
                    matchReason = matchReason + "secondary pack";
                    break;
                }
            }
        }
        if (status == IResourcePackSelectEvent.Status.SUCCESS) {
            if (pack != null && !((ResourcePack)pack).getVariants().isEmpty()) {
                status = IResourcePackSelectEvent.Status.UNKNOWN;
                for (ResourcePack variant : ((ResourcePack)pack).getVariants()) {
                    status = this.checkPack(playerId, variant, status);
                    if (status != IResourcePackSelectEvent.Status.SUCCESS) continue;
                    matchReason = matchReason + " variant";
                    break;
                }
            }
            if (status == IResourcePackSelectEvent.Status.SUCCESS) {
                this.plugin.logDebug(player.getName() + " matched assignment " + matchReason);
            }
        }
        if (pack != null && !((ResourcePack)pack).getUrl().isEmpty() && ((ResourcePack)pack).getRawHash().length > 0) {
            status = IResourcePackSelectEvent.Status.SUCCESS;
        }
        IResourcePackSelectEvent selectEvent = this.plugin.callPackSelectEvent(playerId, (ResourcePack)pack, status);
        return selectEvent.getPack();
    }

    protected IResourcePackSelectEvent.Status checkPack(UUID playerId, ResourcePack pack, IResourcePackSelectEvent.Status status) {
        boolean hasPermission;
        if (pack == null) {
            return status;
        }
        boolean rightFormat = pack.getFormat() <= this.plugin.getPlayerPackFormat(playerId) && pack.getVersion() <= this.plugin.getPlayerProtocol(playerId) && pack.getType() == this.plugin.getPlayerClientType(playerId);
        boolean bl = hasPermission = !pack.isRestricted() || this.plugin.checkPermission(playerId, pack.getPermission());
        if (rightFormat && hasPermission) {
            return IResourcePackSelectEvent.Status.SUCCESS;
        }
        if (status != IResourcePackSelectEvent.Status.NO_PERM_AND_WRONG_VERSION) {
            if (!rightFormat) {
                status = !hasPermission || status == IResourcePackSelectEvent.Status.NO_PERMISSION ? IResourcePackSelectEvent.Status.NO_PERM_AND_WRONG_VERSION : IResourcePackSelectEvent.Status.WRONG_VERSION;
            }
            if (!hasPermission) {
                status = !rightFormat || status == IResourcePackSelectEvent.Status.WRONG_VERSION ? IResourcePackSelectEvent.Status.NO_PERM_AND_WRONG_VERSION : IResourcePackSelectEvent.Status.NO_PERMISSION;
            }
        }
        return status;
    }

    public List<ResourcePack> getPacks() {
        return new ArrayList<ResourcePack>(this.packNames.values());
    }

    public void generateHashes(ResourcepacksPlayer sender) {
        this.plugin.runAsyncTask(() -> {
            this.plugin.sendMessage(sender, "generate-hashes.generating", new String[0]);
            int changed = 0;
            for (ResourcePack pack : this.getPacks()) {
                if (pack.getName().startsWith("backend-")) continue;
                if (pack.getVariants().isEmpty()) {
                    if (!this.generateHash(sender, pack, pack)) continue;
                    ++changed;
                    continue;
                }
                for (ResourcePack packVariant : pack.getVariants()) {
                    if (!this.generateHash(sender, packVariant, pack)) continue;
                    ++changed;
                }
            }
            if (changed > 0) {
                this.plugin.sendMessage(sender, "generate-hashes.changed", "amount", String.valueOf(changed));
                this.plugin.runTask(this.plugin::saveConfigChanges);
            } else {
                this.plugin.sendMessage(sender, "generate-hashes.none-changed", new String[0]);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean generateHash(ResourcepacksPlayer sender, ResourcePack pack, ResourcePack packToCache) {
        boolean changed = false;
        Path target = new File(this.plugin.getDataFolder(), pack.getName().replaceAll("[^a-zA-Z0-9\\.\\-]", "_") + "-downloaded.zip").toPath();
        InputStream in = null;
        URL url = new URL(pack.getUrl());
        this.plugin.sendMessage(sender, "generate-hashes.downloading", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash());
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestProperty("User-Agent", this.plugin.getName() + "/" + this.plugin.getVersion());
        in = con.getInputStream();
        Files.copy(in, target, StandardCopyOption.REPLACE_EXISTING);
        byte[] hash = Hashing.sha1().hashBytes(Files.readAllBytes(target)).asBytes();
        if (!Arrays.equals(pack.getRawHash(), hash)) {
            this.packHashes.remove(pack.getHash());
            pack.setRawHash(hash);
            this.packHashes.put(pack.getHash(), packToCache);
            changed = true;
        }
        this.plugin.sendMessage(sender, "generate-hashes.hash-sum", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash());
        Files.deleteIfExists(target);
        if (in == null) return changed;
        try {
            in.close();
            return changed;
        }
        catch (IOException e) {
            this.plugin.sendMessage(sender, Level.SEVERE, "generate-hashes.failed-to-load-pack", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash(), "error", e.getMessage());
            e.printStackTrace();
        }
        return changed;
        catch (MalformedURLException e) {
            this.plugin.sendMessage(sender, Level.SEVERE, "generate-hashes.invalid-url", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash(), "error", e.getMessage());
            if (in == null) return changed;
            try {
                in.close();
                return changed;
            }
            catch (IOException e2) {
                this.plugin.sendMessage(sender, Level.SEVERE, "generate-hashes.failed-to-load-pack", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash(), "error", e2.getMessage());
                e2.printStackTrace();
            }
            return changed;
        }
        catch (IOException e2) {
            this.plugin.sendMessage(sender, Level.SEVERE, "generate-hashes.failed-to-load-pack", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash(), "error", e2.getMessage());
            if (in == null) return changed;
            {
                catch (Throwable throwable) {
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException e3) {
                        this.plugin.sendMessage(sender, Level.SEVERE, "generate-hashes.failed-to-load-pack", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash(), "error", e3.getMessage());
                        e3.printStackTrace();
                    }
                    throw throwable;
                }
            }
            try {
                in.close();
                return changed;
            }
            catch (IOException e4) {
                this.plugin.sendMessage(sender, Level.SEVERE, "generate-hashes.failed-to-load-pack", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash(), "error", e4.getMessage());
                e4.printStackTrace();
            }
            return changed;
        }
    }

    public int getPackFormat(int version) {
        if (version >= MinecraftVersion.MINECRAFT_1_17.getProtocolNumber()) {
            return 7;
        }
        if (version >= 749) {
            return 6;
        }
        if (version >= 565) {
            return 5;
        }
        if (version >= 348) {
            return 4;
        }
        if (version >= 210) {
            return 3;
        }
        if (version >= 49) {
            return 2;
        }
        if (version >= 47) {
            return 1;
        }
        if (version >= 0) {
            return 0;
        }
        return -1;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void checkDirty() {
        if (this.dirty) {
            this.dirty = false;
            this.plugin.saveConfigChanges();
        }
    }
}

