/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import de.themoep.resourcepacksplugin.core.ClientType;
import de.themoep.resourcepacksplugin.core.MinecraftVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ResourcePack {
    private String name;
    private String url;
    private byte[] hash = new byte[0];
    private int format;
    private int version;
    private boolean restricted;
    private String permission;
    private ClientType type;
    private List<ResourcePack> variants = new ArrayList<ResourcePack>();

    public ResourcePack(String name, String url, String hash) {
        this(name, url, hash, 0);
    }

    public ResourcePack(String name, String url, String hash, int format) {
        this(name, url, hash, format, false);
    }

    public ResourcePack(String name, String url, String hash, boolean restricted) {
        this(name, url, hash, 0, restricted);
    }

    public ResourcePack(String name, String url, String hash, int format, boolean restricted) {
        this(name, url, hash, format, restricted, "resourcepacksplugin.pack." + name.toLowerCase(Locale.ROOT));
    }

    public ResourcePack(String name, String url, String hash, int format, boolean restricted, String permission) {
        this(name, url, hash, format, 0, restricted, permission);
    }

    public ResourcePack(String name, String url, String hash, int format, int version, boolean restricted, String permission) {
        this(name, url, hash, format, version, restricted, permission, ClientType.ORIGINAL);
    }

    public ResourcePack(String name, String url, String hash, int format, int version, boolean restricted, String permission, ClientType type) {
        this.name = name;
        this.url = url;
        if (hash != null && !hash.isEmpty()) {
            if (hash.length() == 40) {
                this.setHash(hash);
            } else {
                this.hash = Hashing.sha1().hashString((CharSequence)url, Charsets.UTF_8).asBytes();
            }
        }
        this.format = format;
        this.version = version;
        this.restricted = restricted;
        this.permission = permission;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    void setUrl(String url) {
        this.url = url;
    }

    public String getHash() {
        return BaseEncoding.base16().lowerCase().encode(this.hash);
    }

    void setHash(String hash) {
        this.hash = BaseEncoding.base16().lowerCase().decode((CharSequence)hash.toLowerCase(Locale.ROOT));
    }

    public byte[] getRawHash() {
        return this.hash;
    }

    public void setRawHash(byte[] hash) {
        this.hash = hash;
    }

    public int getFormat() {
        return this.format;
    }

    public boolean setFormat(int format) {
        if (this.format == format) {
            return false;
        }
        this.format = format;
        return true;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean setVersion(int version) {
        if (this.version == version) {
            return false;
        }
        this.version = version;
        return true;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public boolean setRestricted(boolean restricted) {
        if (this.restricted == restricted) {
            return false;
        }
        this.restricted = restricted;
        return true;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean setPermission(String permission) {
        if (this.permission.equals(permission)) {
            return false;
        }
        this.permission = permission;
        return true;
    }

    public ClientType getType() {
        return this.type;
    }

    public boolean setType(ClientType type) {
        if (this.type == type) {
            return false;
        }
        this.type = type;
        return true;
    }

    public List<ResourcePack> getVariants() {
        return this.variants;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourcePack)) {
            return false;
        }
        ResourcePack other = (ResourcePack)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        byte[] this$hash = this.getRawHash();
        byte[] other$hash = other.getRawHash();
        if (this$hash == null ? other$hash != null : !Arrays.equals(this$hash, other$hash)) {
            return false;
        }
        return this.getType() == other.getType();
    }

    public String[] getReplacements() {
        return new String[]{"name", this.getName(), "url", this.getUrl(), "hash", this.getHash(), "format", String.valueOf(this.getFormat()), "version", String.valueOf(this.getVersion()), "restricted", String.valueOf(this.isRestricted()), "permission", this.getPermission(), "type", this.getType().humanName(), "variants", String.valueOf(this.getVariants().size())};
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("url", this.url.isEmpty() ? null : this.url);
        map.put("hash", this.hash.length == 0 ? null : this.getHash());
        if (this.name.equalsIgnoreCase("empty")) {
            map.put("format", null);
            map.put("version", null);
            map.put("restricted", null);
            map.put("permission", null);
        } else {
            map.put("format", this.format > 0 ? Integer.valueOf(this.format) : null);
            if (this.version > 0) {
                MinecraftVersion mcVersion = MinecraftVersion.getExactVersion(this.version);
                map.put("version", mcVersion != null ? mcVersion.toConfigString() : Integer.valueOf(this.version));
            } else {
                map.put("version", null);
            }
            map.put("restricted", this.restricted);
            map.put("permission", this.permission);
            if (this.type == ClientType.ORIGINAL) {
                map.put("type", null);
            } else {
                map.put("type", this.type.name().toLowerCase(Locale.ROOT));
            }
        }
        if (this.variants.isEmpty()) {
            map.put("variants", null);
        } else {
            ArrayList<Map<String, Object>> variantsList = new ArrayList<Map<String, Object>>();
            for (ResourcePack packVariant : this.variants) {
                variantsList.add(packVariant.serialize());
            }
            map.put("variants", variantsList);
        }
        return map;
    }
}

