/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core.commands;

import de.themoep.resourcepacksplugin.core.ClientType;
import de.themoep.resourcepacksplugin.core.MinecraftVersion;
import de.themoep.resourcepacksplugin.core.PackAssignment;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import de.themoep.resourcepacksplugin.core.commands.PluginCommandExecutor;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;

public class ResourcepacksPluginCommandExecutor
extends PluginCommandExecutor {
    public ResourcepacksPluginCommandExecutor(ResourcepacksPlugin plugin) {
        super(plugin, null, plugin.getName().toLowerCase(Locale.ROOT).charAt(0) + "rp", plugin.getName().toLowerCase(Locale.ROOT) + ".command", plugin.getName().toLowerCase(Locale.ROOT));
        this.registerSubCommands(new PluginCommandExecutor(plugin, this, "reload"){

            @Override
            public boolean run(ResourcepacksPlayer sender, String[] args) {
                if (this.plugin.isEnabled()) {
                    boolean resend = args.length > 0 && "resend".equalsIgnoreCase(args[0]);
                    this.plugin.reloadConfig(resend);
                    this.plugin.sendMessage(sender, "command.reloaded", "plugin", this.plugin.getName(), "optional-resend", resend ? this.plugin.getMessage(sender, "command.optional-resend", new String[0]) : "");
                } else {
                    this.plugin.sendMessage(sender, "command.not-enabled", "plugin", this.plugin.getName());
                }
                return true;
            }
        }, new PluginCommandExecutor(plugin, this, "version"){

            @Override
            public boolean run(ResourcepacksPlayer sender, String[] args) {
                this.plugin.sendMessage(sender, "command.version", "plugin", this.plugin.getName(), "version", this.plugin.getVersion());
                return true;
            }
        }, new PluginCommandExecutor(plugin, this, "generatehashes"){

            @Override
            public boolean run(ResourcepacksPlayer sender, String[] args) {
                this.plugin.getPackManager().generateHashes(sender);
                return true;
            }
        }, new PluginCommandExecutor(plugin, this, "addpack <name> <url>"){

            @Override
            public boolean run(ResourcepacksPlayer sender, String[] args) {
                if (args.length < 2) {
                    return false;
                }
                if (this.plugin.getPackManager().getByName(args[0]) != null) {
                    this.sendMessage(sender, "name-already-used", "name", args[0]);
                    return true;
                }
                ResourcePack urlPack = this.plugin.getPackManager().getByUrl(args[1]);
                if (urlPack != null) {
                    this.sendMessage(sender, "url-already-used", "name", urlPack.getName(), "url", urlPack.getUrl());
                    return true;
                }
                ResourcePack pack = new ResourcePack(args[0], args[1], null);
                this.plugin.getPackManager().addPack(pack);
                this.plugin.saveConfigChanges();
                this.sendMessage(sender, "added", pack.getReplacements());
                return true;
            }
        }, new PluginCommandExecutor(plugin, this, "removepack <name>"){

            @Override
            public boolean run(ResourcepacksPlayer sender, String[] args) {
                if (args.length < 1) {
                    return false;
                }
                ResourcePack pack = this.plugin.getPackManager().getByName(args[0]);
                if (pack == null) {
                    this.sendMessage(sender, "unknown-pack", "input", args[0]);
                    return true;
                }
                this.plugin.getPackManager().removePack(pack);
                this.plugin.saveConfigChanges();
                this.sendMessage(sender, "removed", pack.getReplacements());
                return true;
            }
        }, new PluginCommandExecutor(plugin, this, "pack <pack> [url|hash|format|restricted|permission|type]"){

            @Override
            public boolean run(ResourcepacksPlayer sender, String[] args) {
                if (args.length == 0) {
                    return false;
                }
                ResourcePack pack = this.plugin.getPackManager().getByName(args[0]);
                if (pack == null) {
                    this.sendMessage(sender, "unknown-pack", "input", args[0]);
                    return true;
                }
                boolean save = false;
                if (args.length == 1) {
                    this.sendPackInfo(sender, pack);
                    return false;
                }
                if (args.length == 2) {
                    return false;
                }
                if ("url".equalsIgnoreCase(args[1])) {
                    save = this.plugin.getPackManager().setPackUrl(pack, args[2]);
                    this.sendMessage(sender, "updated", "pack", pack.getName(), "type", "url", "value", pack.getUrl());
                } else if ("hash".equalsIgnoreCase(args[1])) {
                    save = this.plugin.getPackManager().setPackHash(pack, args[2]);
                    this.sendMessage(sender, "updated", "pack", pack.getName(), "type", "hash", "value", pack.getHash());
                } else if ("permission".equalsIgnoreCase(args[1])) {
                    save = pack.setPermission(args[2]);
                    this.sendMessage(sender, "updated", "pack", pack.getName(), "type", "permission", "value", pack.getPermission());
                } else if ("type".equalsIgnoreCase(args[1])) {
                    try {
                        save = pack.setType(ClientType.valueOf(args[2].toUpperCase(Locale.ROOT)));
                        this.sendMessage(sender, "updated", "pack", pack.getName(), "type", "type", "value", pack.getType().humanName());
                    }
                    catch (IllegalArgumentException e) {
                        this.sendMessage(sender, "invalid-input", "expected", "number", "type (" + Arrays.stream(ClientType.values()).map(ClientType::humanName).collect(Collectors.joining(", ")) + ")", args[2]);
                    }
                } else if ("format".equalsIgnoreCase(args[1])) {
                    try {
                        save = pack.setFormat(Integer.parseInt(args[2]));
                        this.sendMessage(sender, "updated", "pack", pack.getName(), "type", "format", "value", String.valueOf(pack.getFormat()));
                    }
                    catch (NumberFormatException e) {
                        this.sendMessage(sender, "invalid-input", "expected", "number", "input", args[2]);
                    }
                } else if ("version".equalsIgnoreCase(args[1])) {
                    try {
                        save = pack.setVersion(Integer.parseInt(args[2]));
                        this.sendMessage(sender, "updated", "pack", pack.getName(), "type", "version", "value", String.valueOf(pack.getVersion()));
                    }
                    catch (NumberFormatException e) {
                        try {
                            save = pack.setVersion(MinecraftVersion.parseVersion(args[2]).getProtocolNumber());
                            this.sendMessage(sender, "updated", "pack", pack.getName(), "type", "version", "value", args[2]);
                        }
                        catch (IllegalArgumentException e1) {
                            this.sendMessage(sender, "invalid-input", "expected", "version", "input", args[2]);
                        }
                    }
                } else if ("restricted".equalsIgnoreCase(args[1])) {
                    try {
                        save = pack.setRestricted(Boolean.parseBoolean(args[2]));
                        this.sendMessage(sender, "updated", "pack", pack.getName(), "type", "restricted", "value", String.valueOf(pack.isRestricted()));
                    }
                    catch (NumberFormatException e) {
                        this.sendMessage(sender, "invalid-input", "expected", "boolean", "input", args[2]);
                    }
                } else {
                    return false;
                }
                if (save) {
                    this.plugin.saveConfigChanges();
                }
                return true;
            }

            private void sendPackInfo(ResourcepacksPlayer sender, ResourcePack pack) {
                if (pack.getVariants().isEmpty()) {
                    this.sendMessage(sender, "info", pack.getReplacements());
                } else {
                    this.sendMessage(sender, "info-variants", pack.getReplacements());
                    for (ResourcePack variant : pack.getVariants()) {
                        this.sendPackInfo(sender, variant);
                    }
                }
            }
        }, new PluginCommandExecutor(plugin, this, "listassignments", null, new String[]{"assignments"}){

            @Override
            public boolean run(ResourcepacksPlayer sender, String[] args) {
                this.sendMessage(sender, "head", new String[0]);
                this.plugin.getPackManager().getAssignments().forEach(a -> this.sendMessage(sender, "entry", a.getReplacements()));
                return true;
            }
        }, new PluginCommandExecutor(plugin, this, "deleteassignment <assignment>", null, new String[]{"removeassignment"}){

            @Override
            public boolean run(ResourcepacksPlayer sender, String[] args) {
                if (args.length == 0) {
                    return false;
                }
                PackAssignment assignment = this.plugin.getPackManager().getAssignmentByName(args[0]);
                if (assignment == null) {
                    this.sendMessage(sender, "unknown-assignment", "input", args[0]);
                    return false;
                }
                this.plugin.getPackManager().setDirty(true);
                this.plugin.getPackManager().removeAssignment(assignment);
                this.sendMessage(sender, "deleted", "name", assignment.getName());
                return true;
            }
        }, new PluginCommandExecutor(plugin, this, "assignment <assignment>", null, new String[]{"assign"}){

            @Override
            public boolean run(ResourcepacksPlayer sender, String[] args) {
                if (args.length == 0) {
                    return false;
                }
                PackAssignment assignment = this.plugin.getPackManager().getAssignmentByName(args[0]);
                if (assignment == null) {
                    this.sendMessage(sender, "new-assignment", "input", args[0]);
                    assignment = new PackAssignment(args[0]);
                } else {
                    this.plugin.getPackManager().removeAssignment(assignment);
                }
                boolean success = assignment.update(this, sender, Arrays.copyOfRange(args, 1, args.length));
                this.plugin.getPackManager().setDirty(true);
                this.plugin.getPackManager().addAssignment(assignment);
                return success;
            }
        }, new PluginCommandExecutor(plugin, this, "globalassignment", null, new String[]{"global"}){

            @Override
            public boolean run(ResourcepacksPlayer sender, String[] args) {
                boolean success = this.plugin.getPackManager().getGlobalAssignment().update(this, sender, args);
                this.plugin.getPackManager().setDirty(true);
                this.plugin.getPackManager().checkDirty();
                return success;
            }

            @Override
            public String getKey() {
                return ResourcepacksPluginCommandExecutor.this.getKey() + ".assignment";
            }
        });
    }

    @Override
    public boolean run(ResourcepacksPlayer sender, String[] args) {
        return false;
    }
}

