/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core.commands;

import de.themoep.resourcepacksplugin.core.ClientType;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import de.themoep.resourcepacksplugin.core.commands.PluginCommandExecutor;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class UsePackCommandExecutor
extends PluginCommandExecutor {
    public UsePackCommandExecutor(ResourcepacksPlugin plugin) {
        super(plugin, "usepack <packname> [<playername>] [<temp>]");
    }

    @Override
    public boolean run(ResourcepacksPlayer sender, String[] args) {
        if (args.length > 0) {
            ResourcePack pack2 = this.plugin.getPackManager().getByName(args[0]);
            if (pack2 != null) {
                if (!pack2.isRestricted() || this.plugin.checkPermission(sender, pack2.getPermission())) {
                    String tempStr = null;
                    if (args.length > 1 && this.plugin.checkPermission(sender, this.permission + ".temporary")) {
                        tempStr = args[args.length - 1];
                    }
                    boolean temp = this.plugin.isUsepackTemporary();
                    if ("false".equalsIgnoreCase(tempStr)) {
                        temp = false;
                    } else if ("true".equalsIgnoreCase(tempStr)) {
                        temp = true;
                    } else {
                        if (tempStr != null && args.length > 2) {
                            this.sendMessage(sender, "invalid-temporary", "input", tempStr);
                            return true;
                        }
                        tempStr = null;
                    }
                    ResourcepacksPlayer player = null;
                    if ((args.length > 2 || tempStr == null && args.length > 1) && this.plugin.checkPermission(sender, this.permission + ".others")) {
                        player = this.plugin.getPlayer(args[1]);
                        if (player == null) {
                            this.sendMessage(sender, "player-not-online", "input", args[1]);
                            return true;
                        }
                    } else if (sender != null) {
                        player = sender;
                    } else {
                        this.plugin.log(Level.WARNING, "You have to specify a player if you want to run this command from the console! /usepack <packname> <playername> [<temp>]");
                        return true;
                    }
                    if (this.plugin.getPlayerClientType(player.getUniqueId()) == ClientType.BEDROCK) {
                        this.sendMessage(sender, "bedrock-not-supported", new String[0]);
                        return true;
                    }
                    switch (this.plugin.getPackManager().setPack(player.getUniqueId(), pack2, temp)) {
                        case SUCCESS: {
                            if (!player.equals(sender)) {
                                this.sendMessage(sender, "success-other", "player", player.getName(), "pack", pack2.getName());
                            }
                            this.sendMessage(player, "success", "pack", pack2.getName());
                            String senderName = sender != null ? sender.getName() : "CONSOLE";
                            this.plugin.logDebug(senderName + " set the pack of " + player.getName() + " to '" + pack2.getName() + "'!");
                            break;
                        }
                        case NO_PERMISSION: {
                            this.sendMessage(sender, "no-variant-found.permission", "player", player.getName(), "pack", pack2.getName());
                            break;
                        }
                        case WRONG_VERSION: {
                            this.sendMessage(sender, "no-variant-found.version", "player", player.getName(), "pack", pack2.getName());
                            break;
                        }
                        case NO_PERM_AND_WRONG_VERSION: {
                            this.sendMessage(sender, "no-variant-found.perm-and-version", "player", player.getName(), "pack", pack2.getName());
                            break;
                        }
                        case UNKNOWN: {
                            this.sendMessage(sender, "already-in-use", "player", player.getName(), "pack", pack2.getName());
                        }
                    }
                } else {
                    this.sendMessage(sender, "restricted", "permission", pack2.getPermission(), "pack", pack2.getName());
                }
            } else {
                this.sendMessage(sender, "unknown-pack", "input", args[0]);
            }
        } else {
            this.sendMessage(sender, "pack-list.head", new String[0]);
            List<ResourcePack> packs = this.plugin.getPackManager().getPacks();
            if (packs.size() > 0) {
                List<ResourcePack> applicablePacks;
                ResourcePack userPack = sender != null ? this.plugin.getUserManager().getUserPack(sender.getUniqueId()) : null;
                List<ResourcePack> list = applicablePacks = sender == null ? packs : packs.stream().filter(pack -> pack.getFormat() <= this.plugin.getPlayerPackFormat(sender.getUniqueId()) && pack.getVersion() <= this.plugin.getPlayerProtocol(sender.getUniqueId()) && pack.getType() == this.plugin.getPlayerClientType(sender.getUniqueId()) && (!pack.isRestricted() || this.plugin.checkPermission(sender, pack.getPermission()))).collect(Collectors.toList());
                if (applicablePacks.size() > 0) {
                    for (ResourcePack pack3 : applicablePacks) {
                        this.sendMessage(sender, "pack-list.entry" + (userPack != null && userPack.equals(pack3) ? "-selected" : ""), "pack", pack3.getName(), "hash", pack3.getHash(), "url", pack3.getUrl(), "format", String.valueOf(pack3.getFormat()), "version", String.valueOf(pack3.getVersion()), "selected", userPack != null && userPack.equals(pack3) ? ">" : " ", "optional-format", pack3.getFormat() > 0 ? this.plugin.getMessage(sender, "command.usepack.pack-list.optional-format", "format", String.valueOf(pack3.getFormat())) : "", "optional-version", pack3.getVersion() > 0 ? this.plugin.getMessage(sender, "command.usepack.pack-list.optional-version", "version", String.valueOf(pack3.getVersion())) : "");
                    }
                    return false;
                }
            }
            this.sendMessage(sender, "no-packs", new String[0]);
        }
        return true;
    }
}

