package de.themoep.resourcepacksplugin.velocity.listeners;

/*
 * ResourcepacksPlugins - velocity
 * Copyright (C) 2024 Max Lee aka Phoenix616 (max@themoep.de)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import de.themoep.resourcepacksplugin.velocity.VelocityResourcepacks;

/**
 * Created by Phoenix616 on 14.05.2015.
 */
public class ConnectListener {

    private final VelocityResourcepacks plugin;

    public ConnectListener(VelocityResourcepacks plugin) {
        this.plugin = plugin;
    }

    @Subscribe
    public void onPlayerConnect(PostLoginEvent event) {
        if (plugin.isEnabled()) {
            plugin.getUserManager().onConnect(event.getPlayer().getUniqueId());
        }
    }
}
