/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class UserManager {
    private final ResourcepacksPlugin plugin;
    private final Multimap<UUID, String> userPacksMap = MultimapBuilder.hashKeys().linkedHashSetValues().build();
    private Map<UUID, Long> userPackTime = new ConcurrentHashMap<UUID, Long>();

    public UserManager(ResourcepacksPlugin plugin) {
        this.plugin = plugin;
    }

    @Deprecated
    public ResourcePack getUserPack(UUID playerid) {
        return this.getUserPacks(playerid).stream().findFirst().orElse(null);
    }

    public List<ResourcePack> getUserPacks(UUID playerid) {
        return this.userPacksMap.get((Object)playerid).stream().map(this.plugin.getPackManager()::getByName).collect(Collectors.toList());
    }

    @Deprecated
    public ResourcePack setUserPack(UUID playerid, ResourcePack pack) {
        this.clearUserPacks(playerid);
        this.addUserPack(playerid, pack);
        return null;
    }

    public boolean addUserPack(UUID playerId, ResourcePack pack) {
        return this.userPacksMap.put((Object)playerId, (Object)pack.getName());
    }

    public Multimap<UUID, String> getUserPacks() {
        return this.userPacksMap;
    }

    @Deprecated
    public ResourcePack clearUserPack(UUID playerid) {
        this.clearUserPacks(playerid);
        return null;
    }

    public Collection<String> clearUserPacks(UUID playerId) {
        return this.userPacksMap.removeAll((Object)playerId);
    }

    public void removeUserPack(UUID playerId, ResourcePack pack) {
        if (pack == null) {
            this.clearUserPacks(playerId);
        } else {
            this.removeUserPack(playerId, pack.getName());
        }
    }

    public void removeUserPack(UUID playerId, String packName) {
        this.userPacksMap.remove((Object)playerId, (Object)packName);
    }

    public void clearUserPacks() {
        this.userPacksMap.clear();
        this.userPackTime.clear();
    }

    public void onConnect(UUID playerId) {
        this.userPackTime.remove(playerId);
        this.clearUserPacks(playerId);
    }

    public void onDisconnect(UUID playerId) {
        if (this.checkStoredPack(playerId)) {
            this.plugin.log(this.plugin.getLogLevel(), "Removed stored pack from " + playerId + " as he logged out in under " + this.plugin.getPermanentPackRemoveTime() + " seconds after it got applied!");
        }
        this.userPackTime.remove(playerId);
        this.clearUserPacks(playerId);
        this.plugin.sendPackInfo(playerId);
    }

    public void updatePackTime(UUID playerId) {
        this.userPackTime.put(playerId, System.currentTimeMillis());
    }

    private boolean checkStoredPack(UUID playerId) {
        int packRemoveTime = this.plugin.getPermanentPackRemoveTime();
        if (packRemoveTime <= 0) {
            return false;
        }
        Long packSet = this.userPackTime.get(playerId);
        if (packSet == null) {
            return false;
        }
        if (packSet + (long)(packRemoveTime * 1000) < System.currentTimeMillis()) {
            return false;
        }
        String storedPackName = this.plugin.getStoredPack(playerId);
        if (storedPackName == null) {
            return false;
        }
        List<ResourcePack> currentPack = this.getUserPacks(playerId);
        if (currentPack.stream().noneMatch(p -> p.getName().equalsIgnoreCase(storedPackName))) {
            return false;
        }
        this.plugin.setStoredPack(playerId, null);
        return true;
    }
}

