/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.velocity.libs.lang;

import de.themoep.resourcepacksplugin.velocity.libs.lang.LangLogger;
import de.themoep.resourcepacksplugin.velocity.libs.lang.LanguageConfig;
import de.themoep.resourcepacksplugin.velocity.libs.lang.LanguageProvider;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.zip.ZipError;

public abstract class LanguageManagerCore<S, C> {
    private final String resourceFolder;
    private final File folder;
    protected final String filePrefix;
    protected final String fileSuffix;
    protected final boolean saveFiles;
    private String defaultLocale;
    private LanguageConfig<C> defaultConfig = null;
    private LanguageProvider<S> provider;
    private Map<String, LanguageConfig<C>> languages = new LinkedHashMap<String, LanguageConfig<C>>();
    private String placeholderPrefix = "%";
    private String placeholderSuffix = "%";

    protected LanguageManagerCore(String defaultLocale, String resourceFolder, File folder, LanguageProvider<S> provider, String filePrefix, String fileSuffix, boolean saveFiles, LanguageConfig<C> ... configs) {
        this.defaultLocale = defaultLocale;
        this.filePrefix = filePrefix;
        this.fileSuffix = fileSuffix;
        if (resourceFolder == null || resourceFolder.isEmpty()) {
            resourceFolder = "languages";
        }
        this.resourceFolder = resourceFolder;
        this.folder = folder;
        this.provider = provider;
        this.saveFiles = saveFiles;
        for (LanguageConfig<C> config : configs) {
            this.addConfig(config);
        }
        this.setDefaultLocale(defaultLocale);
    }

    public abstract void loadConfigs();

    protected void loadConfigs(Class<?> pluginClass, LangLogger logger, Function<String, LanguageConfig<C>> configCreator) {
        HashSet<String> loaded;
        block13: {
            loaded = new HashSet<String>(this.languages.keySet());
            try {
                URL url = pluginClass.getResource("/" + this.resourceFolder);
                if (url != null) {
                    URI uri = url.toURI();
                    try (FileSystem fileSystem = uri.getScheme().equals("jar") ? FileSystems.newFileSystem(uri, Collections.emptyMap()) : null;){
                        this.loadInTree(Paths.get(uri), logger, configCreator);
                    }
                    if (this.getConfigs().isEmpty()) {
                        logger.log(Level.WARNING, "No language files found in folder '/" + this.resourceFolder + "' inside the jar!");
                    }
                    break block13;
                }
                logger.log(Level.WARNING, "Could not find folder '/" + this.resourceFolder + "' in jar!");
            }
            catch (IOException | URISyntaxException | ZipError e) {
                logger.log(Level.WARNING, "Error while trying to automatically load languages from the jar!", e);
            }
        }
        if (loaded.size() < this.languages.size()) {
            List newLocales = this.languages.keySet().stream().filter(s -> !loaded.contains(s)).collect(Collectors.toList());
            logger.log(Level.INFO, "Found locale" + (newLocales.size() == 1 ? " " + (String)newLocales.get(0) : "s " + String.join((CharSequence)", ", newLocales)));
        }
        if (this.saveFiles) {
            this.loadInTree(this.folder.toPath(), logger, locale -> {
                if (!this.languages.containsKey(locale.toLowerCase(Locale.ENGLISH))) {
                    return (LanguageConfig)configCreator.apply((String)locale);
                }
                return null;
            });
        }
    }

    private void loadInTree(Path path, LangLogger logger, final Function<String, LanguageConfig<C>> configCreator) {
        try {
            Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String locale;
                    LanguageConfig config;
                    String fileName = file.getFileName().toString();
                    if (fileName.startsWith(LanguageManagerCore.this.filePrefix) && fileName.endsWith(LanguageManagerCore.this.fileSuffix) && (config = (LanguageConfig)configCreator.apply(locale = fileName.substring(LanguageManagerCore.this.filePrefix.length(), fileName.length() - LanguageManagerCore.this.fileSuffix.length()))) != null) {
                        LanguageManagerCore.this.addConfig(config);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to automatically load languages from " + path + "!", e);
        }
    }

    public LanguageConfig<C> addConfig(LanguageConfig<C> config) {
        config.setPlaceholderPrefix(this.placeholderPrefix);
        config.setPlaceholderSuffix(this.placeholderSuffix);
        return this.languages.put(config.getLocale().toLowerCase(Locale.ENGLISH), config);
    }

    public LanguageConfig<C> getConfig(String locale) {
        if (locale == null) {
            return this.getDefaultConfig();
        }
        LanguageConfig<C> config = this.languages.get(locale = locale.toLowerCase(Locale.ENGLISH));
        if (config == null && locale.contains("_") && (config = this.languages.get(locale.split("_")[0])) == null) {
            config = this.languages.get(locale.split("_")[1]);
        }
        if (config == null) {
            for (LanguageConfig<C> c : this.getConfigs()) {
                if (!locale.startsWith(c.getLocale()) && !locale.endsWith(c.getLocale())) continue;
                config = c;
                break;
            }
        }
        return config != null ? config : this.getDefaultConfig();
    }

    public LanguageConfig<C> getConfig(S sender) {
        return this.getConfig((S)this.provider.getLanguage(sender));
    }

    public Collection<LanguageConfig<C>> getConfigs() {
        return this.languages.values();
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(String locale) {
        this.defaultLocale = locale;
    }

    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
        this.languages.values().forEach(c -> c.setPlaceholderPrefix(placeholderPrefix));
        this.defaultConfig = null;
    }

    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
        this.languages.values().forEach(c -> c.setPlaceholderSuffix(placeholderSuffix));
        this.defaultConfig = null;
    }

    public LanguageConfig<C> getDefaultConfig() {
        if (this.defaultConfig != null && this.defaultLocale != null && this.defaultLocale.equals(this.defaultConfig.getLocale())) {
            return this.defaultConfig;
        }
        this.defaultConfig = this.defaultLocale == null ? (this.languages.isEmpty() ? null : this.languages.values().iterator().next()) : this.languages.get(this.defaultLocale.toLowerCase(Locale.ENGLISH));
        return this.defaultConfig;
    }

    public String getResourceFolder() {
        return this.resourceFolder;
    }

    public File getFolder() {
        return this.folder;
    }

    public void setProvider(LanguageProvider<S> provider) throws IllegalArgumentException {
        if (provider == null) {
            throw new IllegalArgumentException("Provider cannot be null!");
        }
        this.provider = provider;
    }

    public LanguageProvider<S> getProvider() {
        return this.provider;
    }
}

